/*
 * Decompiled with CFR 0.152.
 */
package me.theblockbender.xpboost;

import com.gmail.filoghost.holographicdisplays.api.Hologram;
import com.gmail.filoghost.holographicdisplays.api.HologramsAPI;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.theblockbender.xpboost.command.BoosterCommand;
import me.theblockbender.xpboost.event.BottleListener;
import me.theblockbender.xpboost.event.ExperienceListener;
import me.theblockbender.xpboost.event.HologramListener;
import me.theblockbender.xpboost.event.InventoryListener;
import me.theblockbender.xpboost.event.JobsListener;
import me.theblockbender.xpboost.event.SkillAPIListener;
import me.theblockbender.xpboost.event.mcMMOListener;
import me.theblockbender.xpboost.inventory.BoosterGUI;
import me.theblockbender.xpboost.util.Booster;
import me.theblockbender.xpboost.util.BoosterType;
import me.theblockbender.xpboost.util.UtilTime;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin
implements Listener {
    public BoosterGUI boostergui;
    public UtilTime utilTime = new UtilTime(this);
    public List<UUID> openInventories = new ArrayList<UUID>();
    public Map<UUID, Long> clickCooldown = new HashMap<UUID, Long>();
    public boolean spawnHolos = true;
    private File storagef;
    private FileConfiguration storage;
    private FileConfiguration messages;
    private BossBar bar_minecraft = null;
    private BossBar bar_skillapi = null;
    private BossBar bar_mcmmo = null;
    private BossBar bar_jobs = null;
    private List<Booster> activeBoosters = new ArrayList<Booster>();

    public void onEnable() {
        Plugin skill;
        this.saveDefaultConfig();
        this.createFiles();
        PluginManager pm = Bukkit.getPluginManager();
        if (pm.getPlugin("HolographicDisplays") == null) {
            this.spawnHolos = false;
            this.getLogger().warning("----------------------------------------------------------------------------");
            this.getLogger().warning("HolographicDisplays dependency is missing!");
            this.getLogger().warning("Please install the latest version of HolographicDisplays. It can be gotten");
            this.getLogger().warning("from: https://dev.bukkit.org/projects/holographic-displays");
            this.getLogger().warning(" ");
            this.getLogger().warning("[IMPORTANT] No holograms will be shown without this plugin!");
            this.getLogger().warning("----------------------------------------------------------------------------");
        }
        if (this.getConfig().getDouble("version") < 0.7) {
            this.getLogger().severe("----------------------------------------------------------------------------");
            this.getLogger().severe("Your configuration file for this plugin is to old!");
            this.getLogger().severe("Delete the current plugins/ExperienceBooster folder to enable this plugin!");
            this.getLogger().severe("----------------------------------------------------------------------------");
            pm.disablePlugin((Plugin)this);
            return;
        }
        pm.registerEvents((Listener)new InventoryListener(this), (Plugin)this);
        pm.registerEvents((Listener)new HologramListener(this), (Plugin)this);
        pm.registerEvents((Listener)new BottleListener(this), (Plugin)this);
        if (this.isBoosterEnabled(BoosterType.MINECRAFT)) {
            pm.registerEvents((Listener)new ExperienceListener(this), (Plugin)this);
            this.debug("Activated MC Listener");
        }
        if (this.isBoosterEnabled(BoosterType.SKILLAPI)) {
            skill = pm.getPlugin("SkillAPI");
            if (skill != null) {
                pm.registerEvents((Listener)new SkillAPIListener(this), (Plugin)this);
                this.debug("Activated SkillAPI Listener");
            } else {
                this.getLogger().warning("You cannot enable 'SkillAPI' multiplication if you do not have 'SkillAPI' installed!");
            }
        }
        if (this.isBoosterEnabled(BoosterType.MCMMO)) {
            skill = pm.getPlugin("mcMMO");
            if (skill != null) {
                pm.registerEvents((Listener)new mcMMOListener(this), (Plugin)this);
                this.debug("Activated mcMMO Listener");
            } else {
                this.getLogger().warning("You cannot enable 'mcMMO' multiplication if you do not have 'mcMMO' installed!");
            }
        }
        if (this.isBoosterEnabled(BoosterType.JOBS)) {
            skill = pm.getPlugin("Jobs");
            if (skill != null) {
                pm.registerEvents((Listener)new JobsListener(this), (Plugin)this);
                this.debug("Activated Jobs Listener");
            } else {
                this.getLogger().warning("You cannot enable 'Jobs' multiplication if you do not have 'Jobs' installed!");
            }
        }
        this.getCommand("xpboost").setExecutor((CommandExecutor)new BoosterCommand(this));
        this.boostergui = new BoosterGUI(this);
        Bukkit.getScheduler().runTaskTimer((Plugin)this, () -> this.clickCooldown.entrySet().removeIf(pair -> System.currentTimeMillis() > (Long)pair.getValue()), 1200L, 1200L);
        Bukkit.getScheduler().runTaskTimer((Plugin)this, () -> {
            FileConfiguration config = this.getConfig();
            if (this.isBoosted(BoosterType.MINECRAFT)) {
                if (this.bar_minecraft == null) {
                    try {
                        this.bar_minecraft = Bukkit.createBossBar((String)ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("Boosters.MINECRAFT.bossbar-message").replace("{player}", this.getWhoIsBoosting(BoosterType.MINECRAFT)).replace("{time}", this.getTimeLeft(BoosterType.MINECRAFT)).replace("{current-multiplier}", this.getMultiplierName(BoosterType.MINECRAFT))), (BarColor)BarColor.valueOf((String)config.getString("Boosters.MINECRAFT.bossbar-color").toUpperCase()), (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
                    }
                    catch (NullPointerException ex) {
                        ex.printStackTrace();
                    }
                }
                try {
                    this.bar_minecraft.setTitle(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("Boosters.MINECRAFT.bossbar-message").replace("{player}", this.getWhoIsBoosting(BoosterType.MINECRAFT)).replace("{time}", this.getTimeLeft(BoosterType.MINECRAFT)).replace("{current-multiplier}", this.getMultiplierName(BoosterType.MINECRAFT))));
                    for (Player online : Bukkit.getOnlinePlayers()) {
                        if (this.bar_minecraft.getPlayers().contains(online)) continue;
                        this.bar_minecraft.addPlayer(online);
                    }
                }
                catch (NullPointerException ex) {
                    this.debug("Bar task created a NPE (MINECRAFT). It was silenced.");
                }
            }
            if (this.isBoosted(BoosterType.SKILLAPI)) {
                if (this.bar_skillapi == null) {
                    this.bar_skillapi = Bukkit.createBossBar((String)ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("Boosters.SKILLAPI.bossbar-message").replace("{player}", this.getWhoIsBoosting(BoosterType.SKILLAPI)).replace("{time}", this.getTimeLeft(BoosterType.SKILLAPI)).replace("{current-multiplier}", this.getMultiplierName(BoosterType.SKILLAPI))), (BarColor)BarColor.valueOf((String)config.getString("Boosters.SKILLAPI.bossbar-color").toUpperCase()), (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
                }
                try {
                    this.bar_skillapi.setTitle(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("Boosters.SKILLAPI.bossbar-message").replace("{player}", this.getWhoIsBoosting(BoosterType.SKILLAPI)).replace("{time}", this.getTimeLeft(BoosterType.SKILLAPI)).replace("{current-multiplier}", this.getMultiplierName(BoosterType.SKILLAPI))));
                    for (Player online : Bukkit.getOnlinePlayers()) {
                        if (this.bar_skillapi.getPlayers().contains(online)) continue;
                        this.bar_skillapi.addPlayer(online);
                    }
                }
                catch (NullPointerException ex) {
                    this.debug("Bar task created a NPE (SKILLAPI). It was silenced.");
                }
            }
            if (this.isBoosted(BoosterType.MCMMO)) {
                if (this.bar_mcmmo == null) {
                    this.bar_mcmmo = Bukkit.createBossBar((String)ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("Boosters.MCMMO.bossbar-message").replace("{player}", this.getWhoIsBoosting(BoosterType.MCMMO)).replace("{time}", this.getTimeLeft(BoosterType.MCMMO)).replace("{current-multiplier}", this.getMultiplierName(BoosterType.MCMMO))), (BarColor)BarColor.valueOf((String)config.getString("Boosters.MCMMO.bossbar-color").toUpperCase()), (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
                }
                try {
                    this.bar_mcmmo.setTitle(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("Boosters.MCMMO.bossbar-message").replace("{player}", this.getWhoIsBoosting(BoosterType.MCMMO)).replace("{time}", this.getTimeLeft(BoosterType.MCMMO)).replace("{current-multiplier}", this.getMultiplierName(BoosterType.MCMMO))));
                    for (Player online : Bukkit.getOnlinePlayers()) {
                        if (this.bar_mcmmo.getPlayers().contains(online)) continue;
                        this.bar_mcmmo.addPlayer(online);
                    }
                }
                catch (NullPointerException ex) {
                    this.debug("Bar task created a NPE (MCMMO). It was silenced.");
                }
            }
            if (this.isBoosted(BoosterType.JOBS)) {
                if (this.bar_jobs == null) {
                    this.bar_jobs = Bukkit.createBossBar((String)ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("Boosters.JOBS.bossbar-message").replace("{player}", this.getWhoIsBoosting(BoosterType.JOBS)).replace("{time}", this.getTimeLeft(BoosterType.JOBS)).replace("{current-multiplier}", this.getMultiplierName(BoosterType.JOBS))), (BarColor)BarColor.valueOf((String)config.getString("Boosters.JOBS.bossbar-color").toUpperCase()), (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
                }
                try {
                    this.bar_jobs.setTitle(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("Boosters.JOBS.bossbar-message").replace("{player}", this.getWhoIsBoosting(BoosterType.JOBS)).replace("{time}", this.getTimeLeft(BoosterType.JOBS)).replace("{current-multiplier}", this.getMultiplierName(BoosterType.JOBS))));
                    for (Player online : Bukkit.getOnlinePlayers()) {
                        if (this.bar_jobs.getPlayers().contains(online)) continue;
                        this.bar_jobs.addPlayer(online);
                    }
                }
                catch (NullPointerException ex) {
                    this.debug("Bar task created a NPE (JOBS). It was silenced.");
                }
            }
            if (this.spawnHolos) {
                for (Hologram holo : HologramsAPI.getHolograms((Plugin)this)) {
                    if (holo.getCreationTimestamp() + 1750L >= System.currentTimeMillis()) continue;
                    holo.delete();
                }
            }
        }, 20L, 20L);
    }

    public void onDisable() {
        this.boostergui = null;
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!this.openInventories.contains(player.getUniqueId())) continue;
            player.closeInventory();
            player.sendMessage(this.getMessage("event-plugin-disabled"));
            player.sendMessage(this.getMessage("event-force-close-inventory"));
        }
        this.openInventories.clear();
        this.clickCooldown.clear();
        if (this.bar_minecraft != null) {
            this.bar_minecraft.removeAll();
            this.bar_minecraft = null;
        }
        if (this.bar_skillapi != null) {
            this.bar_skillapi.removeAll();
            this.bar_skillapi = null;
        }
        if (this.bar_mcmmo != null) {
            this.bar_mcmmo.removeAll();
            this.bar_mcmmo = null;
        }
        if (this.bar_jobs != null) {
            this.bar_jobs.removeAll();
            this.bar_jobs = null;
        }
        if (this.spawnHolos) {
            for (Hologram holo : HologramsAPI.getHolograms((Plugin)this)) {
                holo.delete();
            }
        }
    }

    private void createFiles() {
        this.storagef = new File(this.getDataFolder(), "playerdata.yml");
        File messagesf = new File(this.getDataFolder(), "language.yml");
        if (!this.storagef.exists()) {
            this.storagef.getParentFile().mkdirs();
            this.saveResource("playerdata.yml", false);
        }
        if (!messagesf.exists()) {
            messagesf.getParentFile().mkdirs();
            this.saveResource("language.yml", false);
        }
        this.storage = new YamlConfiguration();
        this.messages = new YamlConfiguration();
        try {
            this.storage.load(this.storagef);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
        try {
            this.messages.load(messagesf);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void endActiveBooster(Booster booster) {
        Bukkit.broadcastMessage((String)this.getMessage("booster-ended").replace("{player}", booster.getPlayerName()).replace("{type}", this.getConfig().getString("Boosters." + booster.getType().name() + ".type")));
        this.activeBoosters.remove(booster);
        if (this.isBoosted(booster.getType())) {
            this.debug("A booster finished. Since there was however still a booster of this type active, the bar will remain.");
        } else {
            this.debug("A booster finished. The bar was cleared.");
            switch (booster.getType()) {
                case MCMMO: {
                    this.bar_mcmmo.removeAll();
                    this.bar_mcmmo = null;
                    return;
                }
                case MINECRAFT: {
                    this.bar_minecraft.removeAll();
                    this.bar_minecraft = null;
                    return;
                }
                case SKILLAPI: {
                    this.bar_skillapi.removeAll();
                    this.bar_skillapi = null;
                    return;
                }
                case JOBS: {
                    this.bar_jobs.removeAll();
                    this.bar_jobs = null;
                }
            }
        }
    }

    public void addBooster(Player giveTo, int a, CommandSender cmd, BoosterType type) {
        String uuid;
        String boostername = this.getConfig().getString("Boosters." + type.name() + ".type");
        String s = "";
        if (a != 1) {
            s = "s";
        }
        if (this.storage.contains((uuid = giveTo.getUniqueId().toString()) + "." + type.name())) {
            int amount = this.storage.getInt(uuid + "." + type.name()) + a;
            String sa = "";
            if (amount != 1) {
                sa = "s";
            }
            this.storage.set(uuid + "." + type.name(), (Object)amount);
            cmd.sendMessage(this.getMessage("command-give").replace("{player}", giveTo.getName()).replace("{type}", boostername).replace("{amount}", a + "").replace("{s}", s));
            cmd.sendMessage(this.getMessage("command-current-amount").replace("{amount}", amount + ""));
            giveTo.sendMessage(this.getMessage("booster-receive").replace("{amount}", a + "").replace("{type}", boostername).replace("{s}", sa));
            try {
                this.storage.save(this.storagef);
            }
            catch (IOException e) {
                cmd.sendMessage(this.getMessage("command-error-save"));
                this.debug("IOException whilst saving player data.");
                e.printStackTrace();
            }
        } else {
            this.storage.set(uuid + "." + type.name(), (Object)a);
            cmd.sendMessage(this.getMessage("command-give").replace("{player}", giveTo.getName()).replace("{type}", boostername).replace("{amount}", a + "").replace("{s}", s));
            cmd.sendMessage(this.getMessage("command-current-amount").replace("{amount}", a + ""));
            giveTo.sendMessage(this.getMessage("booster-receive").replace("{amount}", a + "").replace("{type}", boostername).replace("{s}", s));
            try {
                this.storage.save(this.storagef);
            }
            catch (IOException e) {
                cmd.sendMessage(this.getMessage("command-error-save"));
                this.debug("IOException whilst saving player data.");
                e.printStackTrace();
            }
        }
    }

    public void takeBooster(Player takeFrom, int a, CommandSender cmd, BoosterType type) {
        String uuid;
        String boostername = this.getConfig().getString("Boosters." + type.name() + ".type");
        String s = "";
        if (a != 1) {
            s = "s";
        }
        if (this.storage.contains((uuid = takeFrom.getUniqueId().toString()) + "." + type.name())) {
            int amount = this.storage.getInt(uuid + "." + type.name());
            int subtracted = amount - a;
            if (subtracted < 1) {
                this.storage.set(uuid + "." + type.name(), null);
                cmd.sendMessage(this.getMessage("command-reset").replace("{player}", takeFrom.getName()).replace("{type}", boostername));
                cmd.sendMessage(this.getMessage("command-current-amount").replace("{amount}", "0"));
            } else {
                this.storage.set(uuid + "." + type.name(), (Object)subtracted);
                cmd.sendMessage(this.getMessage("command-take").replace("{amount}", a + "").replace("{type}", boostername).replace("player", takeFrom.getName()).replace("{s}", s));
                cmd.sendMessage(this.getMessage("command-current-amount").replace("{amount}", subtracted + ""));
            }
            try {
                this.storage.save(this.storagef);
            }
            catch (IOException e) {
                cmd.sendMessage(this.getMessage("command-error-save"));
                this.debug("IOException whilst saving player data.");
                e.printStackTrace();
            }
        } else {
            cmd.sendMessage(this.getMessage("command-error-no-boosters").replace("{player}", takeFrom.getName()).replace("{type}", boostername));
        }
    }

    public void resetBooster(Player reset, CommandSender cmd, BoosterType type) {
        String boostername = this.getConfig().getString("Boosters." + type.name() + ".type");
        String uuid = reset.getUniqueId().toString();
        if (this.storage.contains(uuid + "." + type.name())) {
            this.storage.set(uuid + "." + type.name(), null);
            cmd.sendMessage(this.getMessage("command-reset").replace("{player}", reset.getName()).replace("{type}", boostername));
            try {
                this.storage.save(this.storagef);
            }
            catch (IOException e) {
                cmd.sendMessage(this.getMessage("command-error-save"));
                this.debug("IOException whilst saving player data.");
                e.printStackTrace();
            }
        } else {
            cmd.sendMessage(this.getMessage("command-error-no-boosters").replace("{player}", reset.getName()).replace("{type}", boostername));
        }
    }

    public void cmdActivate(Player sender, BoosterType type) {
        String boostername = this.getConfig().getString("Boosters." + type.name() + ".type");
        int multi = this.getConfig().getInt("Boosters." + type.name() + ".multiplier");
        if (this.isBoosted(type) && this.isBoosterNotStackable(type)) {
            sender.sendMessage(this.getMessage("command-booster-active"));
            return;
        }
        if (this.isPlayerAlreadyUsingThisBooster(type, sender.getName())) {
            sender.sendMessage(this.getMessage("command-booster-this-type-active"));
            return;
        }
        if (this.isBoosterMaxed(type, multi)) {
            sender.sendMessage(this.getMessage("command-booster-maxed"));
            return;
        }
        Bukkit.broadcastMessage((String)this.getMessage("booster-activated").replace("{player}", sender.getName()).replace("{type}", boostername));
        for (Player online : Bukkit.getOnlinePlayers()) {
            online.playSound(online.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
        }
        this.activeBoosters.add(new Booster(sender.getUniqueId(), this, type, multi));
    }

    public void tryActivateBooster(Player activator, BoosterType type) {
        String boostername = this.getConfig().getString("Boosters." + type.name() + ".type");
        int multi = this.getConfig().getInt("Boosters." + type.name() + ".multiplier");
        if (this.isBoosted(type) && this.isBoosterNotStackable(type)) {
            activator.sendMessage(this.getMessage("command-booster-active"));
            return;
        }
        if (this.isPlayerAlreadyUsingThisBooster(type, activator.getName())) {
            activator.sendMessage(this.getMessage("command-booster-this-type-active"));
            return;
        }
        if (this.isBoosterMaxed(type, multi)) {
            activator.sendMessage(this.getMessage("command-booster-maxed"));
            return;
        }
        String uuid = activator.getUniqueId().toString();
        boolean activate = false;
        if (this.storage.contains(uuid + "." + type.name())) {
            int amount = this.storage.getInt(uuid + "." + type.name());
            int subtracted = amount - 1;
            if (subtracted < 1) {
                this.storage.set(uuid + "." + type.name(), null);
                activate = true;
            } else {
                this.storage.set(uuid + "." + type.name(), (Object)subtracted);
                activate = true;
            }
            try {
                this.storage.save(this.storagef);
            }
            catch (IOException e) {
                activator.sendMessage(this.getMessage("command-error-save"));
                activate = false;
                e.printStackTrace();
            }
        } else {
            activator.sendMessage(this.getMessage("command-no-booster"));
        }
        if (activate) {
            Bukkit.broadcastMessage((String)this.getMessage("booster-activated").replace("{player}", activator.getName()).replace("{type}", boostername));
            for (Player online : Bukkit.getOnlinePlayers()) {
                online.playSound(online.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
            }
            this.activeBoosters.add(new Booster(activator.getUniqueId(), this, type, multi));
        }
    }

    private boolean isPlayerAlreadyUsingThisBooster(BoosterType type, String name) {
        for (Booster b : this.activeBoosters) {
            if (b.getType() != type || !b.getPlayerName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private boolean isBoosterMaxed(BoosterType type, int multi) {
        int max = this.getConfig().getInt("Boosters." + type.name() + ".max-active-multiplier");
        return this.getMultiplier(type) + multi > max;
    }

    private boolean isBoosterNotStackable(BoosterType type) {
        return !this.getConfig().getBoolean("Boosters." + type.name() + ".canStack");
    }

    public Integer getBoosterAmount(Player player, BoosterType type) {
        String uuid = player.getUniqueId().toString();
        if (this.storage.contains(uuid + "." + type.name())) {
            int stored = this.storage.getInt(uuid + "." + type.name());
            this.debug("The value " + uuid + "." + type.name() + " was fetched to be " + stored);
            return stored;
        }
        this.debug("The player " + player.getName() + " does not have the type " + type.name());
        return 0;
    }

    public void debug(String string) {
        if (this.getConfig().getBoolean("debug")) {
            this.getLogger().warning("[Debug] " + string);
        }
    }

    public int getMultiplier(BoosterType type) {
        int booster = 0;
        for (Booster b : this.activeBoosters) {
            if (b.getType() != type) continue;
            booster += b.getMultiplier().intValue();
        }
        int max = this.getConfig().getInt("Boosters." + type.name() + ".max-active-multiplier");
        if (booster > max) {
            booster = max;
        }
        if (booster == 0) {
            booster = 1;
        }
        return booster;
    }

    public boolean isBoosted(BoosterType type) {
        for (Booster b : this.activeBoosters) {
            if (b.getType() != type) continue;
            return true;
        }
        return false;
    }

    private String getWhoIsBoosting(BoosterType type) {
        String name = this.getMessage("server");
        for (Booster b : this.activeBoosters) {
            if (b.getType() != type) continue;
            if (name.equalsIgnoreCase(this.getMessage("server"))) {
                name = b.getPlayerName();
                continue;
            }
            return this.getMessage("multiple-players");
        }
        return name;
    }

    public String getMultiplierName(BoosterType type) {
        int multi = this.getMultiplier(type);
        if (this.messages.contains("Name-of-the-multiplier." + multi)) {
            return this.messages.getString("Name-of-the-multiplier." + multi);
        }
        return this.messages.getString("Name-of-the-multiplier.other");
    }

    private String getTimeLeft(BoosterType type) {
        Booster firstOneToRunOut = null;
        Long time = 1000L * (long)this.getConfig().getInt("Boosters." + type.name() + ".time");
        for (Booster b : this.activeBoosters) {
            if (b.getType() != type || b.getRawTimeLeft() >= time) continue;
            firstOneToRunOut = b;
            time = b.getRawTimeLeft();
        }
        if (firstOneToRunOut == null) {
            return this.getMessage("not-active");
        }
        return firstOneToRunOut.getTimeLeft();
    }

    public boolean isBoosterEnabled(BoosterType type) {
        return this.getConfig().getBoolean("Boosters." + type.name() + ".enabled");
    }

    public String getMessage(String path) {
        if (!this.messages.contains(path)) {
            this.debug("Messages file does not contain: " + path);
            return "\u00a74Error: \u00a7cMissing message \u00a74" + path;
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.messages.getString(path));
    }

    public Material getGuiMaterial(String path) {
        if (!this.messages.contains(path)) {
            this.debug("Messages file does not contain material: " + path);
            return Material.BEDROCK;
        }
        try {
            return Material.valueOf((String)this.messages.getString(path).toUpperCase());
        }
        catch (Exception ex) {
            this.debug("Messages file contained an invalid material for: " + path);
            return Material.BEDROCK;
        }
    }

    public Integer getGuiAmount(String path) {
        if (!this.messages.contains(path)) {
            this.debug("Messages file does not contain amount: " + path);
            return -1;
        }
        try {
            return this.messages.getInt(path);
        }
        catch (Exception ex) {
            this.debug("Messages file contained an invalid amount for: " + path);
            return -1;
        }
    }

    public Short getGuiData(String path) {
        if (!this.messages.contains(path)) {
            this.debug("Messages file does not contain data: " + path);
            return (short)0;
        }
        try {
            return (short)this.messages.getInt(path);
        }
        catch (Exception ex) {
            this.debug("Messages file contained an invalid durability (data) for: " + path);
            return (short)0;
        }
    }

    public String getGuiName(String path) {
        if (!this.messages.contains(path)) {
            this.debug("Messages file does not contain item name: " + path);
            return "\u00a74Error: \u00a7cMissing name for " + path;
        }
        return this.getMessage(path);
    }

    public List<String> getGuiLore(String path) {
        ArrayList<String> lore = new ArrayList<String>();
        if (!this.messages.contains(path)) {
            lore.add("\u00a77Invalid lore from " + path);
            this.debug("Messages file does not contain item lore: " + path);
            return lore;
        }
        List retrieved = this.messages.getStringList(path);
        for (String s : retrieved) {
            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)s));
        }
        return lore;
    }

    public Boolean getGuiGlowing(String path) {
        if (!this.messages.contains(path)) {
            this.debug("Messages file does not contain item glow: " + path);
            return false;
        }
        try {
            return this.messages.getBoolean(path);
        }
        catch (Exception ex) {
            this.debug("Messages file contained an invalid boolean for: " + path);
            return false;
        }
    }
}

