/*
 * Decompiled with CFR 0.152.
 */
package lgz.disposal;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Disposal
extends JavaPlugin
implements Listener {
    String disposalInvTitle = this.getConfig().getString("messages.disposalInvTitle");
    String disposalOpened = this.getConfig().getString("messages.disposalOpened");
    String noPermission = this.getConfig().getString("messages.noPermission");
    String playersOnly = this.getConfig().getString("messages.playersOnly");
    String signCreated = this.getConfig().getString("messages.signCreated");
    String signDestroyed = this.getConfig().getString("messages.signDestroyed");
    String usage = this.getConfig().getString("messages.usage");
    String reloadingConfig = this.getConfig().getString("messages.reloadingConfig");
    String reloadConfigSuccess = this.getConfig().getString("messages.reloadConfigSuccess");
    String sign = this.getConfig().getString("signs.sign");
    String signLine1 = this.getConfig().getString("signs.signLine1");
    String signLine2 = this.getConfig().getString("signs.signLine2");
    String signLine3 = this.getConfig().getString("signs.signLine3");
    String signLine4 = this.getConfig().getString("signs.signLine4");

    public void onEnable() {
        this.getLogger().info("Developed by LachGameZ, plugin page is on SpigotMC.org.");
        this.getLogger().info("Loading config...");
        this.getConfig().options().copyDefaults(true);
        this.saveDefaultConfig();
        if (this.getConfig().getDouble("version") != 1.1) {
            this.getLogger().severe(" ");
            this.getLogger().severe("--------------------------------");
            this.getLogger().severe("Please update your config to version 1.1!");
            this.getLogger().severe("Failing to do so may cause errors.");
            this.getLogger().severe("--------------------------------");
            this.getLogger().severe(" ");
        }
        this.getLogger().info("Registering events...");
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("Loaded succesfully!");
    }

    @EventHandler
    public void onSignChange(SignChangeEvent e) {
        if (e.getLine(0).equalsIgnoreCase(this.sign) && e.getPlayer().hasPermission("disposal.signs.create")) {
            e.getPlayer().sendMessage(this.color(this.signCreated));
            e.setLine(0, this.color(this.signLine1));
            e.setLine(1, this.color(this.signLine2));
            e.setLine(2, this.color(this.signLine3));
            e.setLine(3, this.color(this.signLine4));
        }
    }

    @EventHandler
    public void signDestroy(BlockBreakEvent e) {
        Block block;
        Sign sign;
        String[] ln;
        if ((e.getBlock().getType() == Material.SIGN || e.getBlock().getType() == Material.WALL_SIGN) && (ln = (sign = (Sign)(block = e.getBlock()).getState()).getLines())[0].equalsIgnoreCase(this.color(this.signLine1))) {
            if (!e.getPlayer().hasPermission("disposal.signs.destroy")) {
                e.getPlayer().sendMessage(this.color(this.noPermission));
                e.setCancelled(true);
                return;
            }
            e.getPlayer().sendMessage(this.color(this.signDestroyed));
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent e) {
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (e.getClickedBlock().getState() instanceof Sign) {
            Player p = e.getPlayer();
            Sign s = (Sign)e.getClickedBlock().getState();
            if (s.getLine(0).equalsIgnoreCase(this.color(this.signLine1))) {
                if (!p.hasPermission("disposal.signs.use")) {
                    p.sendMessage(this.color(this.noPermission));
                    return;
                }
                this.openDisposal(p);
            }
        }
    }

    public void openDisposal(Player p) {
        Inventory disposalInv = Bukkit.getServer().createInventory((InventoryHolder)p, 54, this.color(this.disposalInvTitle));
        p.openInventory(disposalInv);
        this.sound(p);
        p.sendMessage(this.color(this.disposalOpened));
    }

    public void sound(Player p) {
        if (this.getConfig().getBoolean("sound.enabled")) {
            String soundID = this.getConfig().getString("sound.id");
            double soundVol = this.getConfig().getDouble("sound.volume");
            double soundPitch = this.getConfig().getDouble("sound.pitch");
            p.playSound(p.getLocation(), Sound.valueOf((String)soundID), (float)soundVol, (float)soundPitch);
        }
    }

    public boolean onCommand(CommandSender s, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("disposal")) {
            if (!(s instanceof Player)) {
                s.sendMessage(this.color(this.playersOnly));
                return true;
            }
            if (!s.hasPermission("disposal.command")) {
                s.sendMessage(this.color(this.noPermission));
                return true;
            }
            if (args.length == 0) {
                this.openDisposal((Player)s);
                return true;
            }
            if (args.length == 1) {
                if (args[0].equalsIgnoreCase("info")) {
                    s.sendMessage(this.color("&8&m         &6&l Disposal &fv" + this.getDescription().getVersion() + "&8 &m         &r"));
                    s.sendMessage(this.color(""));
                    s.sendMessage(this.color("&8 - &6/disposal [info/reload]&f Open disposal, plugin info or reload config."));
                    s.sendMessage(this.color(""));
                    s.sendMessage(this.color("&f   Developer: &6LachGameZ"));
                    s.sendMessage(this.color("&f   Thanks for using the plugin!"));
                    s.sendMessage(this.color("&8&m                                           "));
                    return true;
                }
                if (args[0].equalsIgnoreCase("reload")) {
                    s.sendMessage(this.color(this.reloadingConfig));
                    this.reloadConfig();
                    s.sendMessage(this.color(this.reloadConfigSuccess));
                    return true;
                }
                s.sendMessage(this.color(this.usage).replaceAll("%command%", label));
                return true;
            }
            s.sendMessage(this.color(this.usage).replaceAll("%command%", label));
            return true;
        }
        return false;
    }

    public String color(String msg) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)msg);
    }
}

