/*
 * Decompiled with CFR 0.152.
 */
package me.haileykins.disenchanted.handlers;

import java.io.File;
import java.io.IOException;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class LanguageHandler {
    private FileConfiguration config;
    private Plugin plugin;

    public LanguageHandler(Plugin plugin) {
        this.plugin = plugin;
    }

    public void loadLang() {
        File file = new File(this.plugin.getDataFolder(), "lang.yml");
        if (!file.exists()) {
            this.plugin.getLogger().info("No Language File Found, Creating...");
            this.plugin.saveResource("lang.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)file);
    }

    public void saveLang() {
        File file = new File(this.plugin.getDataFolder(), "lang.yml");
        try {
            this.config.save(file);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Lang File Failed To Save!");
        }
    }

    public String color(String s) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)s);
    }

    public String getMessage(String key, boolean prefixed) {
        if (prefixed) {
            return this.color(this.config.getString("prefix") + " " + this.config.getString(key));
        }
        return this.color(this.config.getString(key));
    }
}

