/*
 * Decompiled with CFR 0.152.
 */
package me.haileykins.disenchanted.handlers;

import me.haileykins.disenchanted.common.Utilities;
import me.haileykins.disenchanted.handlers.ConfigHandler;
import me.haileykins.disenchanted.handlers.LanguageHandler;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;

public class EconomyHandler {
    private ConfigHandler configHandler;
    private LanguageHandler languageHandler;
    private Plugin plugin;
    private Economy economy = null;

    public EconomyHandler(ConfigHandler configHandler, LanguageHandler languageHandler, Plugin plugin) {
        this.configHandler = configHandler;
        this.languageHandler = languageHandler;
        this.plugin = plugin;
    }

    public boolean setupEconomy() {
        if (this.plugin.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.plugin.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        this.economy = (Economy)rsp.getProvider();
        return true;
    }

    public void handlePurchase(Enchantment enchantment, ItemStack item, Player player, ItemStack book, ItemMeta meta) {
        int cost = this.getEnchantmentCost(enchantment, (Integer)item.getEnchantments().get(enchantment));
        if (this.configHandler.getConfig().getBoolean("require-book-and-quill")) {
            ItemStack writableBook = new ItemStack(Material.WRITABLE_BOOK, 1);
            if (!player.getInventory().containsAtLeast(writableBook, 1)) {
                player.sendMessage(this.languageHandler.getMessage("writable-book-required", true));
                return;
            }
            player.getInventory().removeItem(new ItemStack[]{new ItemStack(Material.WRITABLE_BOOK, 1)});
        }
        if (player.getInventory().firstEmpty() == -1) {
            player.sendMessage(this.languageHandler.getMessage("no-inv-space", true));
            return;
        }
        if (this.configHandler.getConfig().getBoolean("use-economy")) {
            if (!this.economy.has((OfflinePlayer)player, (double)cost)) {
                player.sendMessage(this.languageHandler.getMessage("cant-afford", true));
                return;
            }
            this.economy.withdrawPlayer((OfflinePlayer)player, (double)cost);
        } else {
            if (player.getLevel() < cost) {
                player.sendMessage(this.languageHandler.getMessage("cant-afford", true));
                return;
            }
            player.setLevel(player.getLevel() - cost);
        }
        book.setItemMeta(meta);
        player.getInventory().addItem(new ItemStack[]{book});
        player.getInventory().getItemInMainHand().removeEnchantment(enchantment);
        player.sendMessage(this.languageHandler.getMessage("purchase-successful", true));
        player.closeInventory();
    }

    public int getEnchantmentCost(Enchantment enchantment, int level) {
        FileConfiguration config = this.plugin.getConfig();
        ConfigurationSection enchants = config.getConfigurationSection("enchantments");
        assert (enchants != null) : " Config Section \"enchantments\" is missing!";
        return enchants.getInt(Utilities.getCommonName(enchantment).toLowerCase() + "." + level);
    }
}

