/*
 * Decompiled with CFR 0.152.
 */
package me.haileykins.disenchanted.common;

import java.util.Collections;
import me.haileykins.disenchanted.handlers.ConfigHandler;
import me.haileykins.disenchanted.handlers.EconomyHandler;
import me.haileykins.disenchanted.handlers.LanguageHandler;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class DisenchantMenu {
    private ConfigHandler configHandler;
    private EconomyHandler economyHandler;
    private LanguageHandler languageHandler;

    public DisenchantMenu(ConfigHandler configHandler, EconomyHandler economyHandler, LanguageHandler languageHandler) {
        this.configHandler = configHandler;
        this.economyHandler = economyHandler;
        this.languageHandler = languageHandler;
    }

    public Inventory open(ItemStack item) {
        String symbol;
        Inventory inventory = Bukkit.createInventory(null, (int)18, (String)this.languageHandler.getMessage("menu-title", false));
        FileConfiguration config = this.configHandler.getConfig();
        boolean useEconomy = config.getBoolean("use-economy");
        String string = symbol = useEconomy ? this.languageHandler.getMessage("economy-symbol", false) : this.languageHandler.getMessage("xp-symbol", false);
        if (!this.configHandler.getConfig().getBoolean("use-economy")) {
            symbol = this.languageHandler.getMessage("xp-symbol", false);
        }
        int slot = 0;
        for (Enchantment enchantment : item.getEnchantments().keySet()) {
            ItemStack book = new ItemStack(Material.ENCHANTED_BOOK);
            ItemMeta meta = book.getItemMeta();
            assert (meta != null) : " Meta For Book Is Null";
            meta.addEnchant(enchantment, item.getEnchantmentLevel(enchantment), true);
            int cost = this.economyHandler.getEnchantmentCost(enchantment, (Integer)item.getEnchantments().get(enchantment));
            String formattedCost = useEconomy ? symbol + cost : cost + symbol;
            meta.setLore(Collections.singletonList(formattedCost));
            book.setItemMeta(meta);
            inventory.setItem(slot, book);
            ++slot;
        }
        return inventory;
    }
}

