/*
 * Decompiled with CFR 0.152.
 */
package me.haileykins.disenchanted.commands.subcommands;

import me.haileykins.disenchanted.commands.CommandBase;
import me.haileykins.disenchanted.handlers.ConfigHandler;
import me.haileykins.disenchanted.handlers.LanguageHandler;
import org.bukkit.command.CommandSender;

public class ReloadCommand
implements CommandBase {
    private ConfigHandler configHandler;
    private LanguageHandler languageHandler;

    public ReloadCommand(ConfigHandler configHandler, LanguageHandler languageHandler) {
        this.configHandler = configHandler;
        this.languageHandler = languageHandler;
    }

    @Override
    public void onCommand(CommandSender sender, String[] args) {
        if (args.length <= 1) {
            this.configHandler.loadConfig();
            sender.sendMessage(this.languageHandler.getMessage("config-reloaded", true));
            this.languageHandler.loadLang();
            sender.sendMessage(this.languageHandler.getMessage("lang-reloaded", true));
            return;
        }
        if (args[1].equalsIgnoreCase("config")) {
            this.configHandler.loadConfig();
            sender.sendMessage(this.languageHandler.getMessage("config-reloaded", true));
            return;
        }
        if (args[1].equalsIgnoreCase("lang")) {
            this.languageHandler.loadLang();
            sender.sendMessage(this.languageHandler.getMessage("lang-reloaded", true));
            return;
        }
        sender.sendMessage(this.languageHandler.getMessage("file-doesnt-exist", true));
    }

    @Override
    public String getCommandName() {
        return "reload";
    }

    @Override
    public String getPermissionNode() {
        return "disenchanted.admin";
    }
}

