/*
 * Decompiled with CFR 0.152.
 */
package me.haileykins.disenchanted.commands;

import java.util.HashSet;
import java.util.Set;
import me.haileykins.disenchanted.commands.CommandBase;
import me.haileykins.disenchanted.common.DisenchantMenu;
import me.haileykins.disenchanted.handlers.LanguageHandler;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CommandManager
implements CommandExecutor {
    private DisenchantMenu disenchantMenu;
    private LanguageHandler languageHandler;
    private final Set<CommandBase> commands = new HashSet<CommandBase>();

    public CommandManager(DisenchantMenu disenchantMenu, LanguageHandler languageHandler) {
        this.disenchantMenu = disenchantMenu;
        this.languageHandler = languageHandler;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length == 0) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(this.languageHandler.getMessage("must-be-player", true));
                return true;
            }
            Player player = (Player)sender;
            if (!player.hasPermission("disenchanted.disenchant.remote")) {
                player.sendMessage(this.languageHandler.getMessage("no-permission", true));
                return true;
            }
            ItemStack item = player.getInventory().getItemInMainHand();
            if (item.getType() != Material.AIR) {
                player.openInventory(this.disenchantMenu.open(item));
            }
            return true;
        }
        CommandBase command = this.getCommand(args[0]);
        if (command == null) {
            sender.sendMessage(this.languageHandler.getMessage("invalid-command", true));
            return true;
        }
        String permission = command.getPermissionNode();
        if (command.hasPermissionNode() && !sender.hasPermission(permission)) {
            sender.sendMessage(this.languageHandler.getMessage("no-permission", true));
            return true;
        }
        command.onCommand(sender, args);
        return true;
    }

    public void registerCommand(CommandBase commandBase) {
        this.commands.add(commandBase);
    }

    private CommandBase getCommand(String command) {
        for (CommandBase commandBase : this.commands) {
            if (!commandBase.getCommandName().equalsIgnoreCase(command)) continue;
            return commandBase;
        }
        return null;
    }
}

