/*
 * Decompiled with CFR 0.152.
 */
package me.haileykins.disenchanted;

import java.util.Objects;
import me.haileykins.disenchanted.commands.CommandManager;
import me.haileykins.disenchanted.commands.subcommands.HelpCommand;
import me.haileykins.disenchanted.commands.subcommands.ReloadCommand;
import me.haileykins.disenchanted.common.DisenchantMenu;
import me.haileykins.disenchanted.handlers.ConfigHandler;
import me.haileykins.disenchanted.handlers.EconomyHandler;
import me.haileykins.disenchanted.handlers.LanguageHandler;
import me.haileykins.disenchanted.listeners.InteractListeners;
import me.haileykins.disenchanted.listeners.InventoryListeners;
import me.haileykins.disenchanted.listeners.UpdateListener;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class Disenchanted
extends JavaPlugin {
    public void onEnable() {
        ConfigHandler configHandler = new ConfigHandler((Plugin)this);
        LanguageHandler languageHandler = new LanguageHandler((Plugin)this);
        EconomyHandler economyHandler = new EconomyHandler(configHandler, languageHandler, (Plugin)this);
        DisenchantMenu disenchantMenu = new DisenchantMenu(configHandler, economyHandler, languageHandler);
        this.getServer().getPluginManager().registerEvents((Listener)new InteractListeners(disenchantMenu, configHandler, languageHandler), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new InventoryListeners(configHandler, economyHandler, languageHandler), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new UpdateListener((Plugin)this, configHandler, languageHandler), (Plugin)this);
        CommandManager commandManager = new CommandManager(disenchantMenu, languageHandler);
        commandManager.registerCommand(new HelpCommand(languageHandler));
        commandManager.registerCommand(new ReloadCommand(configHandler, languageHandler));
        Objects.requireNonNull(this.getCommand("disenchanted")).setExecutor((CommandExecutor)commandManager);
        configHandler.loadConfig();
        languageHandler.loadLang();
        if (!economyHandler.setupEconomy()) {
            this.getLogger().info("No Vault Found. Resorting To XP Purchases!");
            configHandler.getConfig().set("use-economy", (Object)false);
            configHandler.saveConfig();
            configHandler.loadConfig();
        }
    }

    public void onDisable() {
    }
}

