/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.falistos.BungeeMotd;

import com.gmail.falistos.BungeeMotd.MotdCommand;
import com.google.common.io.ByteStreams;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.Favicon;
import net.md_5.bungee.api.ServerPing;
import net.md_5.bungee.api.event.ProxyPingEvent;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;
import net.md_5.bungee.event.EventHandler;

public class BungeeMotd
extends Plugin
implements Listener {
    private Configuration config;
    Favicon favicon;

    public void onEnable() {
        this.saveDefaultConfig();
        this.reloadConfig();
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)this);
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new MotdCommand(this));
    }

    protected Configuration getConfig() {
        return this.config;
    }

    protected void reloadConfig() {
        try {
            this.config = ConfigurationProvider.getProvider(YamlConfiguration.class).load(new File(this.getDataFolder(), "config.yml"));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load configuration", e);
        }
        File file = new File(this.getDataFolder(), "server-icon.png");
        if (file.exists()) {
            try {
                BufferedImage bufferedImage = ImageIO.read(file);
                this.favicon = Favicon.create((BufferedImage)bufferedImage);
            }
            catch (IOException e) {
                this.getLogger().warning("Favicon file is invalid or missing.");
            }
        }
    }

    protected void saveConfig() {
        try {
            ConfigurationProvider.getProvider(YamlConfiguration.class).save(this.getConfig(), new File(this.getDataFolder(), "config.yml"));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to save configuration", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveDefaultConfig() {
        File configFile;
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdir();
        }
        if ((configFile = new File(this.getDataFolder(), "config.yml")).exists()) return;
        try {
            configFile.createNewFile();
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                InputStream is = this.getResourceAsStream("config.yml");
                try {
                    try (FileOutputStream os = new FileOutputStream(configFile);){
                        ByteStreams.copy((InputStream)is, (OutputStream)os);
                    }
                    if (is == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (is == null) throw throwable;
                    is.close();
                    throw throwable;
                }
                is.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create configuration file", e);
        }
    }

    @EventHandler(priority=64)
    public void onServerListPing(ProxyPingEvent event) {
        if (this.getConfig().getString("motd") != null) {
            ServerPing ping = event.getResponse();
            String motd = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("motd"));
            motd = motd.replace("{newline}", "\n");
            ping.setDescription(motd);
            if (this.favicon != null) {
                ping.setFavicon(this.favicon);
            }
            event.setResponse(ping);
        }
    }
}

