/*
 * Decompiled with CFR 0.152.
 */
package me.Logaaan.mlder;

import com.momchil_atanasov.data.front.error.WFException;
import com.momchil_atanasov.data.front.parser.OBJModel;
import com.momchil_atanasov.data.front.parser.OBJParser;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import me.shadow.objectrenderer.BaseMesh;
import me.shadow.objectrenderer.object.IBufferBuilder;
import me.shadow.objectrenderer.object.PointBufferBuilder;
import me.shadow.objectrenderer.object.PrimitiveBuilder;
import me.shadow.objectrenderer.renderer.BlockRenderer;
import me.shadow.objectrenderer.renderer.IRenderer;
import me.shadow.objectrenderer.renderer.PointRenderer;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;

public class Main
extends JavaPlugin
implements CommandExecutor,
Listener {
    public Map<Location, OBJModel> locs = new HashMap<Location, OBJModel>();
    public Map<Location, String> filenames = new HashMap<Location, String>();
    public Map<Location, String> parts = new HashMap<Location, String>();
    public Map<Location, Integer> scales = new HashMap<Location, Integer>();
    public Map<Player, Location> selected = new HashMap<Player, Location>();

    public void onEnable() {
        this.getCommand("mlder").setExecutor((CommandExecutor)this);
        this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                for (Location loc : Main.this.locs.keySet()) {
                    new BaseMesh(Main.this.locs.get(loc)).build((IBufferBuilder)new PointBufferBuilder().scale(new Vector(Main.this.scales.get(loc).intValue(), Main.this.scales.get(loc).intValue(), Main.this.scales.get(loc).intValue()))).setBaseLocation(loc).setRenderer((IRenderer)new PointRenderer().setParticle(Particle.valueOf((String)Main.this.parts.get(loc))).setCount(1)).render();
                }
            }
        }, 1L, 7L);
        for (String key : this.getConfig().getKeys(false)) {
            String[] loc = this.getConfig().getString(String.valueOf(key) + ".loc").split("%");
            float x = Float.parseFloat(loc[0]);
            float y = Float.parseFloat(loc[1]);
            float z = Float.parseFloat(loc[2]);
            World w = this.getServer().getWorld(loc[3]);
            Location lc = new Location(w, (double)x, (double)y, (double)z);
            String filename = this.getConfig().getString(String.valueOf(key) + ".filename");
            String particle = this.getConfig().getString(String.valueOf(key) + ".particle");
            int scale = this.getConfig().getInt(String.valueOf(key) + ".scale");
            try {
                FileInputStream fs = new FileInputStream("plugins/ModelLoader/objs/" + filename + ".obj");
                OBJParser parser = new OBJParser();
                OBJModel model = parser.parse((InputStream)fs);
                this.locs.put(lc, model);
                this.parts.put(lc, particle);
                this.scales.put(lc, scale);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (WFException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void onDisable() {
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player p = (Player)sender;
        if (p.hasPermission("mlder.use")) {
            if (args.length > 0) {
                if (args[0].equals("build")) {
                    if (args.length > 1) {
                        if (args.length > 2) {
                            if (args.length > 3) {
                                OBJParser parser = new OBJParser();
                                float scale = Float.parseFloat(args[3]);
                                try {
                                    FileInputStream fs = new FileInputStream("plugins/ModelLoader/objs/" + args[1] + ".obj");
                                    OBJModel model = parser.parse((InputStream)fs);
                                    BaseMesh lol = new BaseMesh(model);
                                    PrimitiveBuilder b = new PrimitiveBuilder();
                                    lol.build((IBufferBuilder)b).setScale(new Vector(scale, scale, scale)).setBaseLocation(p.getLocation()).setRenderer((IRenderer)new BlockRenderer().setMaterial(Material.valueOf((String)args[2].toString())).setBlocksPerTick(50).setTickDelay(1).setFaceThickness(1.0f)).render();
                                    p.sendMessage(ChatColor.GREEN + "Build in progress... Do not stop server.");
                                    return true;
                                }
                                catch (IOException e) {
                                    p.sendMessage(ChatColor.RED + "File does not exist!");
                                    e.printStackTrace();
                                    return true;
                                }
                            }
                            p.sendMessage(ChatColor.RED + "Enter scale :)");
                            return true;
                        }
                        p.sendMessage(ChatColor.RED + "Type in Material.. Eg.: GLOWSTONE, STONE, NETHERRACK :)");
                        return true;
                    }
                    p.sendMessage(ChatColor.RED + "Type in file name :)");
                    return true;
                }
                if (args[0].equals("save")) {
                    if (args.length > 1) {
                        p.sendMessage(ChatColor.GREEN + "Saving....");
                        if (!this.getConfig().isSet(String.valueOf(args[1]) + ".loc")) {
                            this.getConfig().set(String.valueOf(args[1]) + ".loc", (Object)(String.valueOf(p.getLocation().getX()) + "%" + p.getLocation().getY() + "%" + p.getLocation().getZ() + "%" + p.getLocation().getWorld().getName()));
                            this.getConfig().set(String.valueOf(args[1]) + ".filename", (Object)this.filenames.get(this.selected.get(p)));
                            this.getConfig().set(String.valueOf(args[1]) + ".particle", (Object)this.parts.get(this.selected.get(p)));
                            this.getConfig().set(String.valueOf(args[1]) + ".scale", (Object)this.scales.get(this.selected.get(p)));
                            this.saveConfig();
                            p.sendMessage(ChatColor.GREEN + "Saved!");
                        } else {
                            this.getConfig().set(String.valueOf(args[1]) + ".loc", (Object)(String.valueOf(p.getLocation().getX()) + "%" + p.getLocation().getY() + "%" + p.getLocation().getZ() + "%" + p.getLocation().getWorld().getName()));
                            this.getConfig().set(String.valueOf(args[1]) + ".filename", (Object)this.filenames.get(this.selected.get(p)));
                            this.getConfig().set(String.valueOf(args[1]) + ".particle", (Object)this.parts.get(this.selected.get(p)));
                            this.getConfig().set(String.valueOf(args[1]) + ".scale", (Object)this.scales.get(this.selected.get(p)));
                            this.saveConfig();
                            p.sendMessage(ChatColor.GREEN + "Saved!");
                        }
                    } else {
                        p.sendMessage(ChatColor.RED + "Please, specify name of saved structure :)");
                    }
                }
                if (args[0].equals("delete")) {
                    if (args.length > 1) {
                        p.sendMessage(ChatColor.GREEN + "Deleting....");
                        if (this.getConfig().isSet(String.valueOf(args[1]) + ".loc")) {
                            this.getConfig().set(args[1], null);
                            this.saveConfig();
                            p.sendMessage(ChatColor.GREEN + "Deleted!");
                            this.locs.clear();
                            this.parts.clear();
                            this.filenames.clear();
                            this.scales.clear();
                            this.selected.clear();
                            for (String key : this.getConfig().getKeys(false)) {
                                String[] loc = this.getConfig().getString(String.valueOf(key) + ".loc").split("%");
                                float x = Float.parseFloat(loc[0]);
                                float y = Float.parseFloat(loc[1]);
                                float z = Float.parseFloat(loc[2]);
                                World w = this.getServer().getWorld(loc[3]);
                                Location lc = new Location(w, (double)x, (double)y, (double)z);
                                String filename = this.getConfig().getString(String.valueOf(key) + ".filename");
                                String particle = this.getConfig().getString(String.valueOf(key) + ".particle");
                                int scale = this.getConfig().getInt(String.valueOf(key) + ".scale");
                                try {
                                    FileInputStream fs = new FileInputStream("plugins/ModelLoader/objs/" + filename + ".obj");
                                    OBJParser parser = new OBJParser();
                                    OBJModel model = parser.parse((InputStream)fs);
                                    this.locs.put(lc, model);
                                    this.parts.put(lc, particle);
                                    this.scales.put(lc, scale);
                                }
                                catch (FileNotFoundException e) {
                                    e.printStackTrace();
                                }
                                catch (WFException e) {
                                    e.printStackTrace();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                        } else {
                            p.sendMessage(ChatColor.RED + "This structure save does not exist!");
                        }
                    } else {
                        this.locs.remove(this.selected.get(p));
                        this.filenames.remove(this.selected.get(p));
                        this.parts.remove(this.selected.get(p));
                        this.scales.remove(this.selected.get(p));
                        this.selected.remove(p);
                        p.sendMessage(ChatColor.GREEN + "Current selection deleted!");
                    }
                }
                if (args[0].equals("load")) {
                    if (args.length > 1) {
                        if (args.length > 2) {
                            if (args.length > 3) {
                                String obj = args[1];
                                String part = args[2];
                                int scale = Integer.parseInt(args[3]);
                                try {
                                    Particle x = Particle.valueOf((String)part);
                                }
                                catch (Exception e) {
                                    p.sendMessage(ChatColor.RED + "Error! Particle not found - Particle example: CRIT, CRIT_MAGIC etc.");
                                    return true;
                                }
                                try {
                                    FileInputStream fs = new FileInputStream("plugins/ModelLoader/objs/" + args[1] + ".obj");
                                    OBJParser parser = new OBJParser();
                                    OBJModel model = parser.parse((InputStream)fs);
                                    p.sendMessage(ChatColor.GREEN + "File found, loading object into memory...");
                                    this.locs.put(p.getLocation(), model);
                                    p.sendMessage(ChatColor.GREEN + "Done.. Adding particle to list..");
                                    this.parts.put(p.getLocation(), part);
                                    this.scales.put(p.getLocation(), scale);
                                    this.selected.put(p, p.getLocation());
                                    this.filenames.put(p.getLocation(), args[1]);
                                    p.sendMessage(ChatColor.YELLOW + "Done.. Everything is OK and ready..");
                                }
                                catch (FileNotFoundException e) {
                                    p.sendMessage(ChatColor.RED + "File not found!");
                                    e.printStackTrace();
                                }
                                catch (WFException e) {
                                    p.sendMessage(ChatColor.RED + "Error parsing file!");
                                    e.printStackTrace();
                                }
                                catch (IOException e) {
                                    p.sendMessage(ChatColor.RED + "Error accessing file!");
                                    e.printStackTrace();
                                }
                                return true;
                            }
                            p.sendMessage(ChatColor.RED + "Please, specify scale :)");
                            return true;
                        }
                        p.sendMessage(ChatColor.RED + "Please, specify particle :)");
                        return true;
                    }
                    p.sendMessage(ChatColor.RED + "Please, specify file :)");
                    return true;
                }
                return true;
            }
            p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&b=============&c&lModel Loader&b============="));
            p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&b- &e/mlder load &7loads a model to your position"));
            p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&b- &e/mlder save &7saves current model"));
            p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&b- &e/mlder delete &7deletes current model"));
            p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&b=============&c&lLogaaanCzech&b============="));
            return true;
        }
        p.sendMessage(ChatColor.RED + "You do not have permission to use this particular command :)");
        return true;
    }
}

