/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.wrappers;

public enum MathOperation {
    ADD("+="),
    ASSIGN("="),
    DIVIDE("/="),
    MAX(">"),
    MIN("<"),
    MOD("%="),
    MULTIPLY("*="),
    SUBTRACT("-="),
    SWAP("><");

    private String stringValue;

    private MathOperation(String stringValue) {
        this.stringValue = stringValue;
    }

    public String toString() {
        return this.stringValue;
    }

    public static MathOperation fromString(String input) {
        return switch (input) {
            case "=" -> ASSIGN;
            case "+=" -> ADD;
            case "-=" -> SUBTRACT;
            case "*=" -> MULTIPLY;
            case "/=" -> DIVIDE;
            case "%=" -> MOD;
            case "<" -> MIN;
            case ">" -> MAX;
            case "><" -> SWAP;
            default -> null;
        };
    }

    public int apply(int val1, int val2) {
        return switch (this) {
            case ADD -> val1 + val2;
            case ASSIGN -> val2;
            case DIVIDE -> val1 / val2;
            case MAX -> Math.max(val1, val2);
            case MIN -> Math.min(val1, val2);
            case MOD -> val1 % val2;
            case MULTIPLY -> val1 * val2;
            case SUBTRACT -> val1 - val2;
            case SWAP -> val2;
            default -> val2;
        };
    }

    public float apply(float val1, float val2) {
        return switch (this) {
            case ADD -> val1 + val2;
            case ASSIGN -> val2;
            case DIVIDE -> val1 / val2;
            case MAX -> Math.max(val1, val2);
            case MIN -> Math.min(val1, val2);
            case MOD -> val1 % val2;
            case MULTIPLY -> val1 * val2;
            case SUBTRACT -> val1 - val2;
            case SWAP -> val2;
            default -> val2;
        };
    }
}

