/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.arguments;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.arguments.CommandAPIArgumentType;
import dev.jorel.commandapi.arguments.ICustomProvidedArgument;
import dev.jorel.commandapi.arguments.SafeOverrideableArgument;
import dev.jorel.commandapi.arguments.SoundType;
import dev.jorel.commandapi.arguments.SuggestionProviders;
import dev.jorel.commandapi.nms.NMS;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;

public class SoundArgument<SoundOrNamespacedKey>
extends SafeOverrideableArgument<SoundOrNamespacedKey, SoundOrNamespacedKey>
implements ICustomProvidedArgument {
    private final SoundType soundType;

    public SoundArgument(String nodeName) {
        this(nodeName, SoundType.SOUND);
    }

    public SoundArgument(String nodeName, SoundType soundType) {
        super(nodeName, CommandAPIHandler.getInstance().getNMS()._ArgumentMinecraftKeyRegistered(), soundType.getMapper());
        this.soundType = soundType;
    }

    @Override
    public Class<SoundOrNamespacedKey> getPrimitiveType() {
        return switch (this.soundType) {
            default -> throw new IncompatibleClassChangeError();
            case SoundType.SOUND -> Sound.class;
            case SoundType.NAMESPACED_KEY -> NamespacedKey.class;
        };
    }

    @Override
    public SuggestionProviders getSuggestionProvider() {
        return SuggestionProviders.SOUNDS;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.SOUND;
    }

    @Override
    public <CommandListenerWrapper> SoundOrNamespacedKey parseArgument(NMS<CommandListenerWrapper> nms, CommandContext<CommandListenerWrapper> cmdCtx, String key, Object[] previousArgs) throws CommandSyntaxException {
        return nms.getSound(cmdCtx, key, this.getPrimitiveType());
    }
}

