/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi;

import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.Converter;
import dev.jorel.commandapi.arguments.AdvancementArgument;
import dev.jorel.commandapi.arguments.AdventureChatArgument;
import dev.jorel.commandapi.arguments.AdventureChatComponentArgument;
import dev.jorel.commandapi.arguments.AngleArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.AxisArgument;
import dev.jorel.commandapi.arguments.BiomeArgument;
import dev.jorel.commandapi.arguments.BlockPredicateArgument;
import dev.jorel.commandapi.arguments.BlockStateArgument;
import dev.jorel.commandapi.arguments.BooleanArgument;
import dev.jorel.commandapi.arguments.ChatArgument;
import dev.jorel.commandapi.arguments.ChatColorArgument;
import dev.jorel.commandapi.arguments.ChatComponentArgument;
import dev.jorel.commandapi.arguments.CommandAPIArgumentType;
import dev.jorel.commandapi.arguments.CommandArgument;
import dev.jorel.commandapi.arguments.DoubleArgument;
import dev.jorel.commandapi.arguments.EnchantmentArgument;
import dev.jorel.commandapi.arguments.EntitySelector;
import dev.jorel.commandapi.arguments.EntitySelectorArgument;
import dev.jorel.commandapi.arguments.EntityTypeArgument;
import dev.jorel.commandapi.arguments.EnvironmentArgument;
import dev.jorel.commandapi.arguments.FloatArgument;
import dev.jorel.commandapi.arguments.FloatRangeArgument;
import dev.jorel.commandapi.arguments.FunctionArgument;
import dev.jorel.commandapi.arguments.GreedyStringArgument;
import dev.jorel.commandapi.arguments.IntegerArgument;
import dev.jorel.commandapi.arguments.IntegerRangeArgument;
import dev.jorel.commandapi.arguments.ItemStackArgument;
import dev.jorel.commandapi.arguments.ItemStackPredicateArgument;
import dev.jorel.commandapi.arguments.Location2DArgument;
import dev.jorel.commandapi.arguments.LocationArgument;
import dev.jorel.commandapi.arguments.LocationType;
import dev.jorel.commandapi.arguments.LongArgument;
import dev.jorel.commandapi.arguments.LootTableArgument;
import dev.jorel.commandapi.arguments.MathOperationArgument;
import dev.jorel.commandapi.arguments.MultiLiteralArgument;
import dev.jorel.commandapi.arguments.NBTCompoundArgument;
import dev.jorel.commandapi.arguments.NamespacedKeyArgument;
import dev.jorel.commandapi.arguments.ObjectiveArgument;
import dev.jorel.commandapi.arguments.ObjectiveCriteriaArgument;
import dev.jorel.commandapi.arguments.OfflinePlayerArgument;
import dev.jorel.commandapi.arguments.ParticleArgument;
import dev.jorel.commandapi.arguments.PlayerArgument;
import dev.jorel.commandapi.arguments.PotionEffectArgument;
import dev.jorel.commandapi.arguments.RecipeArgument;
import dev.jorel.commandapi.arguments.RotationArgument;
import dev.jorel.commandapi.arguments.ScoreHolderArgument;
import dev.jorel.commandapi.arguments.ScoreboardSlotArgument;
import dev.jorel.commandapi.arguments.SoundArgument;
import dev.jorel.commandapi.arguments.StringArgument;
import dev.jorel.commandapi.arguments.TeamArgument;
import dev.jorel.commandapi.arguments.TextArgument;
import dev.jorel.commandapi.arguments.TimeArgument;
import dev.jorel.commandapi.arguments.UUIDArgument;
import dev.jorel.commandapi.exceptions.InvalidNumberException;
import dev.jorel.commandapi.exceptions.UnknownArgumentException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.plugin.java.JavaPlugin;

public class AdvancedConverter {
    private static final Pattern ARGUMENT_PATTERN = Pattern.compile("<(\\w+)>\\[([a-z:_]+|(?:[0-9\\.]+)?\\.\\.(?:[0-9\\.]+)?)\\]");
    private static final Pattern LITERAL_PATTERN = Pattern.compile("\\((\\w+(?:\\|\\w+)*)\\)");
    private final JavaPlugin plugin;
    private final String command;
    private int argumentIndex = 1;

    public AdvancedConverter(JavaPlugin plugin, String command) {
        this.plugin = plugin;
        this.command = command;
    }

    public AdvancedConverter(String command) {
        this.plugin = null;
        this.command = command;
    }

    public void convert() {
        List<Argument<?>> arguments;
        String commandName = this.command.split(" ")[0];
        try {
            arguments = this.parseArguments(this.command);
        }
        catch (InvalidNumberException | UnknownArgumentException e) {
            CommandAPI.logError(e.getMessage());
            return;
        }
        if (arguments.size() == 0) {
            Converter.convert(this.plugin, commandName);
        } else {
            Converter.convert(this.plugin, commandName, arguments);
        }
    }

    public void convertCommand() {
        List<Argument<?>> arguments;
        String commandName = this.command.split(" ")[0];
        try {
            arguments = this.parseArguments(this.command);
        }
        catch (InvalidNumberException | UnknownArgumentException e) {
            CommandAPI.logError(e.getMessage());
            return;
        }
        if (arguments.size() == 0) {
            Converter.convert(commandName);
        } else {
            Converter.convert(commandName, arguments);
        }
    }

    private List<Argument<?>> parseArguments(String command) throws UnknownArgumentException, InvalidNumberException {
        ArrayList arguments = new ArrayList();
        String[] parts = command.split(" ");
        this.argumentIndex = 1;
        while (this.argumentIndex < parts.length) {
            Argument<?> argument = this.parseArgument(parts[this.argumentIndex]);
            if (argument != null) {
                arguments.add(argument);
            }
            ++this.argumentIndex;
        }
        return arguments;
    }

    private boolean isRangeAnInteger(double value) {
        return value == (double)((long)value);
    }

    private double parseValue(String bound) throws InvalidNumberException {
        try {
            return Double.parseDouble(bound);
        }
        catch (NumberFormatException e) {
            throw new InvalidNumberException(bound, this.command, this.argumentIndex);
        }
    }

    private Argument<?> parseRange(String nodeName, String[] bounds) throws InvalidNumberException {
        if (bounds.length == 1) {
            double value = this.parseValue(bounds[0]);
            if (this.isRangeAnInteger(value)) {
                return new LongArgument(nodeName, (long)value);
            }
            return new DoubleArgument(nodeName, value);
        }
        if (bounds[0].length() == 0) {
            double value = this.parseValue(bounds[1]);
            if (this.isRangeAnInteger(value)) {
                return new LongArgument(nodeName, Long.MIN_VALUE, (long)value);
            }
            return new DoubleArgument(nodeName, -1.7976931348623157E308, value);
        }
        double value0 = this.parseValue(bounds[0]);
        double value1 = this.parseValue(bounds[1]);
        if (!this.isRangeAnInteger(value0) || !this.isRangeAnInteger(value1)) {
            return new DoubleArgument(nodeName, value0, value1);
        }
        return new LongArgument(nodeName, (long)value0, (long)value1);
    }

    private Argument<?> parseDefinedArgumentType(String argumentType, String nodeName) throws UnknownArgumentException {
        return switch (CommandAPIArgumentType.fromInternal(argumentType)) {
            case CommandAPIArgumentType.ADVANCEMENT -> new AdvancementArgument(nodeName);
            case CommandAPIArgumentType.ADVENTURE_CHAT -> new AdventureChatArgument(nodeName);
            case CommandAPIArgumentType.ADVENTURE_CHAT_COMPONENT -> new AdventureChatComponentArgument(nodeName);
            case CommandAPIArgumentType.ANGLE -> new AngleArgument(nodeName);
            case CommandAPIArgumentType.AXIS -> new AxisArgument(nodeName);
            case CommandAPIArgumentType.BIOME -> new BiomeArgument(nodeName);
            case CommandAPIArgumentType.BLOCKSTATE -> new BlockStateArgument(nodeName);
            case CommandAPIArgumentType.BLOCK_PREDICATE -> new BlockPredicateArgument(nodeName);
            case CommandAPIArgumentType.CHAT -> new ChatArgument(nodeName);
            case CommandAPIArgumentType.CHATCOLOR -> new ChatColorArgument(nodeName);
            case CommandAPIArgumentType.CHAT_COMPONENT -> new ChatComponentArgument(nodeName);
            case CommandAPIArgumentType.COMMAND -> new CommandArgument(nodeName);
            case CommandAPIArgumentType.ENCHANTMENT -> new EnchantmentArgument(nodeName);
            case CommandAPIArgumentType.ENTITY_SELECTOR -> new EntitySelectorArgument(nodeName, EntitySelector.ONE_ENTITY);
            case CommandAPIArgumentType.ENTITY_TYPE -> new EntityTypeArgument(nodeName);
            case CommandAPIArgumentType.ENVIRONMENT -> new EnvironmentArgument(nodeName);
            case CommandAPIArgumentType.FLOAT_RANGE -> new FloatRangeArgument(nodeName);
            case CommandAPIArgumentType.FUNCTION -> new FunctionArgument(nodeName);
            case CommandAPIArgumentType.INT_RANGE -> new IntegerRangeArgument(nodeName);
            case CommandAPIArgumentType.ITEMSTACK -> new ItemStackArgument(nodeName);
            case CommandAPIArgumentType.ITEMSTACK_PREDICATE -> new ItemStackPredicateArgument(nodeName);
            case CommandAPIArgumentType.LOCATION -> new LocationArgument(nodeName, LocationType.BLOCK_POSITION);
            case CommandAPIArgumentType.LOCATION_2D -> new Location2DArgument(nodeName, LocationType.BLOCK_POSITION);
            case CommandAPIArgumentType.LOOT_TABLE -> new LootTableArgument(nodeName);
            case CommandAPIArgumentType.MATH_OPERATION -> new MathOperationArgument(nodeName);
            case CommandAPIArgumentType.NAMESPACED_KEY -> new NamespacedKeyArgument(nodeName);
            case CommandAPIArgumentType.NBT_COMPOUND -> new NBTCompoundArgument(nodeName);
            case CommandAPIArgumentType.OBJECTIVE -> new ObjectiveArgument(nodeName);
            case CommandAPIArgumentType.OBJECTIVE_CRITERIA -> new ObjectiveCriteriaArgument(nodeName);
            case CommandAPIArgumentType.OFFLINE_PLAYER -> new OfflinePlayerArgument(nodeName);
            case CommandAPIArgumentType.PARTICLE -> new ParticleArgument(nodeName);
            case CommandAPIArgumentType.PLAYER -> new PlayerArgument(nodeName);
            case CommandAPIArgumentType.POTION_EFFECT -> new PotionEffectArgument(nodeName);
            case CommandAPIArgumentType.RECIPE -> new RecipeArgument(nodeName);
            case CommandAPIArgumentType.ROTATION -> new RotationArgument(nodeName);
            case CommandAPIArgumentType.SCOREBOARD_SLOT -> new ScoreboardSlotArgument(nodeName);
            case CommandAPIArgumentType.SCORE_HOLDER -> new ScoreHolderArgument(nodeName, ScoreHolderArgument.ScoreHolderType.SINGLE);
            case CommandAPIArgumentType.SOUND -> new SoundArgument(nodeName);
            case CommandAPIArgumentType.TEAM -> new TeamArgument(nodeName);
            case CommandAPIArgumentType.TIME -> new TimeArgument(nodeName);
            case CommandAPIArgumentType.UUID -> new UUIDArgument(nodeName);
            case CommandAPIArgumentType.PRIMITIVE_BOOLEAN -> new BooleanArgument(nodeName);
            case CommandAPIArgumentType.PRIMITIVE_DOUBLE -> new DoubleArgument(nodeName);
            case CommandAPIArgumentType.PRIMITIVE_FLOAT -> new FloatArgument(nodeName);
            case CommandAPIArgumentType.PRIMITIVE_GREEDY_STRING -> new GreedyStringArgument(nodeName);
            case CommandAPIArgumentType.PRIMITIVE_INTEGER -> new IntegerArgument(nodeName);
            case CommandAPIArgumentType.PRIMITIVE_LONG -> new LongArgument(nodeName);
            case CommandAPIArgumentType.PRIMITIVE_STRING -> new StringArgument(nodeName);
            case CommandAPIArgumentType.PRIMITIVE_TEXT -> new TextArgument(nodeName);
            case CommandAPIArgumentType.LITERAL, CommandAPIArgumentType.MULTI_LITERAL, CommandAPIArgumentType.CUSTOM -> throw new UnknownArgumentException(argumentType);
            default -> throw new UnknownArgumentException(argumentType);
        };
    }

    private Argument<?> parseArgument(String argument) throws UnknownArgumentException, InvalidNumberException {
        Matcher literalMatcher = LITERAL_PATTERN.matcher(argument);
        Matcher argumentMatcher = ARGUMENT_PATTERN.matcher(argument);
        if (literalMatcher.matches()) {
            String literals = literalMatcher.group(1);
            return new MultiLiteralArgument(literals.split("\\|"));
        }
        if (argumentMatcher.matches()) {
            String nodeName = argumentMatcher.group(1);
            String argumentType = argumentMatcher.group(2);
            if (argumentType.contains("..")) {
                return this.parseRange(nodeName, argumentType.split("\\.\\."));
            }
            return switch (argumentType) {
                case "api:entity" -> new EntitySelectorArgument(nodeName, EntitySelector.ONE_ENTITY);
                case "api:entities" -> new EntitySelectorArgument(nodeName, EntitySelector.MANY_ENTITIES);
                case "api:player" -> new EntitySelectorArgument(nodeName, EntitySelector.ONE_PLAYER);
                case "api:players" -> new EntitySelectorArgument(nodeName, EntitySelector.MANY_PLAYERS);
                case "minecraft:vec3" -> new LocationArgument(nodeName, LocationType.PRECISE_POSITION);
                case "minecraft:vec2" -> new Location2DArgument(nodeName, LocationType.PRECISE_POSITION);
                default -> this.parseDefinedArgumentType(argumentType, nodeName);
            };
        }
        throw new UnknownArgumentException(argument);
    }
}

