/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.wrappers;

import org.bukkit.ChatColor;
import org.bukkit.scoreboard.DisplaySlot;

public class ScoreboardSlot {
    private final DisplaySlot displaySlot;
    private final ChatColor teamColor;

    public ScoreboardSlot(int i) {
        this.displaySlot = switch (i) {
            case 0 -> DisplaySlot.PLAYER_LIST;
            case 1 -> DisplaySlot.SIDEBAR;
            case 2 -> DisplaySlot.BELOW_NAME;
            default -> DisplaySlot.SIDEBAR;
        };
        this.teamColor = ChatColor.getByChar((String)Integer.toHexString(i - 3));
    }

    public static ScoreboardSlot of(DisplaySlot slot) {
        return new ScoreboardSlot(switch (slot) {
            case DisplaySlot.PLAYER_LIST -> 0;
            case DisplaySlot.SIDEBAR -> 1;
            case DisplaySlot.BELOW_NAME -> 2;
            default -> 1;
        });
    }

    public static ScoreboardSlot ofTeamColor(ChatColor color) {
        try {
            return new ScoreboardSlot(Integer.parseInt(color.toString().substring(1), 16) + 3);
        }
        catch (NumberFormatException e) {
            return new ScoreboardSlot(1);
        }
    }

    public DisplaySlot getDisplaySlot() {
        return this.displaySlot;
    }

    public ChatColor getTeamColor() {
        return this.teamColor;
    }

    public boolean hasTeamColor() {
        return this.teamColor != null;
    }

    public String toString() {
        if (this.teamColor != null) {
            return "sidebar.team." + this.teamColor.name().toLowerCase();
        }
        return switch (this.displaySlot) {
            case DisplaySlot.PLAYER_LIST -> "list";
            case DisplaySlot.SIDEBAR -> "sidebar";
            case DisplaySlot.BELOW_NAME -> "belowName";
            default -> "sidebar";
        };
    }
}

