/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.nms;

import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.arguments.PreviewInfo;
import dev.jorel.commandapi.exceptions.WrapperCommandSyntaxException;
import dev.jorel.commandapi.nms.NMS;
import dev.jorel.commandapi.wrappers.PreviewableFunction;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundChatPreviewPacket;
import net.minecraft.network.protocol.game.ServerboundChatPreviewPacket;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class NMS_1_19_R1_ChatPreviewHandler
extends ChannelDuplexHandler {
    private final NMS<CommandListenerWrapper> nms;
    private final Plugin plugin;
    private final Player player;
    private final NetworkManager connection;

    public NMS_1_19_R1_ChatPreviewHandler(NMS<CommandListenerWrapper> nms, Plugin plugin, Player player) {
        this.nms = nms;
        this.plugin = plugin;
        this.player = player;
        this.connection = ((CraftPlayer)player).getHandle().b.b;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ServerboundChatPreviewPacket chatPreview;
        if (msg instanceof ServerboundChatPreviewPacket && !(chatPreview = (ServerboundChatPreviewPacket)msg).c().isEmpty() && chatPreview.c().charAt(0) == '/') {
            Bukkit.getScheduler().runTask(this.plugin, () -> {
                String jsonToSend;
                String fullInput = chatPreview.c().substring(1);
                ParseResults results = this.nms.getBrigadierDispatcher().parse(fullInput, (Object)this.nms.getCLWFromCommandSender((CommandSender)this.player));
                ArrayList<String> path = new ArrayList<String>();
                for (ParsedCommandNode commandNode : results.getContext().getNodes()) {
                    path.add(commandNode.getNode().getName());
                }
                Optional<PreviewableFunction<?>> preview = CommandAPIHandler.getInstance().lookupPreviewable(path);
                if (!preview.isPresent()) return;
                String input = ((ParsedCommandNode)results.getContext().getNodes().get(results.getContext().getNodes().size() - 1)).getRange().get(fullInput);
                Component component = null;
                try {
                    PreviewInfo<Component> previewInfo;
                    if (CommandAPIHandler.getInstance().lookupPreviewableLegacyStatus(path)) {
                        parsedInput = null;
                        try {
                            parsedInput = this.nms.getChat((CommandContext<CommandListenerWrapper>)results.getContext().build(fullInput), (String)path.get(path.size() - 1));
                        }
                        catch (CommandSyntaxException e) {
                            throw new WrapperCommandSyntaxException(e);
                        }
                        previewInfo = new PreviewInfo<Component>(this.player, input, chatPreview.c(), parsedInput);
                    } else {
                        parsedInput = null;
                        try {
                            parsedInput = this.nms.getAdventureChat((CommandContext<CommandListenerWrapper>)results.getContext().build(fullInput), (String)path.get(path.size() - 1));
                        }
                        catch (CommandSyntaxException e) {
                            throw new WrapperCommandSyntaxException(e);
                        }
                        previewInfo = new PreviewInfo<Component>(this.player, input, chatPreview.c(), parsedInput);
                    }
                    component = preview.get().generatePreview(previewInfo);
                }
                catch (WrapperCommandSyntaxException e) {
                    component = TextComponent.fromLegacyText((String)(e.getMessage() == null ? "" : e.getMessage()));
                }
                if (component == null) throw new NullPointerException("Returned value from chat preview was null");
                if (component instanceof BaseComponent[]) {
                    Component baseComponent = component;
                    jsonToSend = ComponentSerializer.toString((BaseComponent[])baseComponent);
                } else {
                    if (!CommandAPIHandler.getInstance().getPaper().isPresent()) throw new IllegalArgumentException("Unexpected type returned from chat preview, got: " + component.getClass().getSimpleName());
                    if (!(component instanceof Component)) throw new IllegalArgumentException("Unexpected type returned from chat preview, got: " + component.getClass().getSimpleName());
                    Component adventureComponent = component;
                    jsonToSend = (String)GsonComponentSerializer.gson().serialize(adventureComponent);
                }
                if (jsonToSend == null) return;
                this.connection.a((Packet)new ClientboundChatPreviewPacket(chatPreview.b(), (IChatBaseComponent)IChatBaseComponent.ChatSerializer.a((String)jsonToSend)));
            });
        }
        super.channelRead(ctx, msg);
    }
}

