/*
 * Decompiled with CFR 0.152.
 */
package it.derpyt.web;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Updater
implements Listener {
    private JavaPlugin plugin;
    private String version;
    private long nextInformationCheck;
    private int resource;

    public Updater(JavaPlugin plugin, int resource) {
        this.plugin = plugin;
        this.nextInformationCheck = 0L;
        this.resource = resource;
        this.refresh();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        new BukkitRunnable(){

            public void run() {
                Updater.this.notifyUpdate();
            }
        }.runTaskTimer((Plugin)plugin, 18000L, 18000L);
    }

    @EventHandler
    public void onJoin(final PlayerJoinEvent e) {
        new BukkitRunnable(){

            public void run() {
                Updater.this.notifyUpdate(e.getPlayer());
            }
        }.runTaskLater((Plugin)this.plugin, 80L);
    }

    public String getRawLatestVersion() {
        return this.version;
    }

    public void checkForUpdates() throws Exception {
        this.plugin.getLogger().info("\u00a76\u00a7lVoidUp \u00a78>> \u00a77Checking for updates...");
        if (this.canRefresh()) {
            this.refresh();
        }
    }

    public boolean hasUpdate() {
        return !this.version.equalsIgnoreCase(this.plugin.getDescription().getVersion());
    }

    public String getLatestVersion() {
        return this.isBeta() ? this.version.replace("-BETA", "") : this.version;
    }

    public boolean isBeta() {
        return this.version.endsWith("-BETA");
    }

    public int getVersionsBehind() {
        return Integer.parseInt(this.version.replaceAll("[^0-9]", "")) - Integer.parseInt(this.plugin.getDescription().getVersion().replaceAll("[^0-9]", ""));
    }

    public boolean canRefresh() {
        return this.nextInformationCheck <= System.currentTimeMillis();
    }

    public void refresh() {
        if (this.nextInformationCheck > System.currentTimeMillis()) {
            return;
        }
        try {
            URLConnection con = new URL("https://api.spigotmc.org/legacy/update.php?resource=" + this.resource).openConnection();
            this.version = new BufferedReader(new InputStreamReader(con.getInputStream())).readLine();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void notifyUpdate() {
        if (!this.hasUpdate()) {
            return;
        }
        this.plugin.getLogger().info("\u00a77A" + (this.isBeta() ? " beta" : "n") + " update is available! v" + this.plugin.getDescription().getVersion() + " -> v" + this.version + ". You are " + this.getVersionsBehind() + " versions behind. Update at \u00a76https://spigotmc.org/resources/" + this.resource);
        Player[] onlinePlayers = Bukkit.getOnlinePlayers();
        int i = 0;
        while (i < onlinePlayers.length) {
            Player p = onlinePlayers[i];
            this.notifyUpdate(p);
            ++i;
        }
    }

    public void notifyUpdate(Player arg0) {
        if (!this.hasUpdate() || !arg0.isOp()) {
            return;
        }
        arg0.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("\u00a76\u00a7l" + this.plugin.getName() + " \u00a78>> \u00a77A" + (this.isBeta() ? " beta" : "n") + " update is available! v" + this.plugin.getDescription().getVersion() + " -> v" + this.version + ". You are " + this.getVersionsBehind() + " versions behind. Update at https://spigotmc.org/resources/" + this.resource)));
    }
}

