/*
 * Decompiled with CFR 0.152.
 */
package xyz.theducc.play.DPlayerWarps.commands;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import xyz.theducc.play.DPlayerWarps.Core;

public class CreateWarp
implements CommandExecutor {
    protected Core main;

    public CreateWarp(Core main) {
        this.main = main;
        main.getCommand("pw-create").setExecutor((CommandExecutor)this);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        Player player;
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(this.main.PREFIX) + this.main.color("&cYou must be a player to create a warp."));
        }
        if (!(player = (Player)sender).hasPermission("dpw.create")) {
            player.sendMessage(String.valueOf(this.main.PREFIX) + this.main.color("&cYou do not have permission to create a warp."));
            return true;
        }
        Location playerLoc = player.getLocation();
        UUID playerUUID = player.getUniqueId();
        File file = this.main.getFolder(playerUUID.toString());
        FileConfiguration yamlFile = this.main.getPlayerFile(playerUUID.toString(), file);
        if (yamlFile.getString("hasWarp").equals("true")) {
            player.sendMessage(String.valueOf(this.main.PREFIX) + this.main.color("&cYou have already reached the limit of how many warps you can have."));
            return true;
        }
        if (this.main.getConfig().getBoolean("create-costs-money")) {
            double bankBalance;
            double cost = 2000.0;
            cost = this.main.getConfig().getDouble("create-cost") <= 0.0 ? 1.0 : this.main.getConfig().getDouble("create-cost");
            if (cost > (bankBalance = Core.economy.getBalance((OfflinePlayer)player))) {
                player.sendMessage(String.valueOf(this.main.PREFIX) + this.main.color("&cYou need &d$" + cost + " &cto buy a warp."));
                return true;
            }
            Core.economy.withdrawPlayer((OfflinePlayer)player, cost);
        }
        yamlFile.createSection("warp");
        yamlFile.getConfigurationSection("warp").set("location", (Object)playerLoc);
        yamlFile.getConfigurationSection("warp").set("world", (Object)playerLoc.getWorld().getName());
        yamlFile.set("hasWarp", (Object)"true");
        yamlFile.set("isPrivate", (Object)false);
        yamlFile.set("trustedPlayers", (Object)"[]");
        try {
            yamlFile.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        player.sendMessage(String.valueOf(this.main.PREFIX) + this.main.color("Your warp has been created!"));
        player.playSound(playerLoc, Sound.NOTE_PLING, 1.0f, 1.0f);
        return true;
    }
}

