/*
 * Decompiled with CFR 0.152.
 */
package eu.mip.alandioda.spigot.SM;

import eu.mip.alandioda.spigot.SM.Menu;
import eu.mip.alandioda.spigot.SM.MenuItem;
import eu.mip.alandioda.spigot.SM.Place;
import eu.mip.alandioda.spigot.SM.ToolBar;
import eu.mip.alandioda.spigot.SM.main;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.meta.ItemMeta;

public class LoadingAndSaving {
    private main main;
    FileConfiguration config;
    FileConfiguration playerConfig;

    public LoadingAndSaving(main m) {
        this.main = m;
    }

    void LoadSaves() {
        this.main.hubs = this.config.getStringList("hubs");
        this.LoadPlaces();
        this.LoadMenuBars();
        this.LoadMenuItems();
        this.LoadMenuInventory();
        this.LoadUserDataConfig();
    }

    void SaveSaves() {
        for (Map.Entry<String, Place> entry : this.main.places.entrySet()) {
            this.SavePlace(entry.getKey());
        }
        for (Map.Entry<String, Object> entry : this.main.menuItems.entrySet()) {
            this.SaveMenuItem(entry.getKey());
        }
        for (Map.Entry<String, Object> entry : this.main.toolBars.entrySet()) {
            this.SaveMenuBar(entry.getKey());
        }
        for (Map.Entry<String, Object> entry : this.main.menus.entrySet()) {
            this.SaveMenuInventory(entry.getKey());
        }
        this.config.set("hubs", this.main.hubs);
        this.SaveDataConfig();
    }

    void LoadPlaces() {
        List places = this.config.getStringList("places");
        for (String name : places) {
            File loadFile = new File(this.main.getDataFolder() + "/data/place/" + name + ".yml");
            if (!loadFile.exists()) continue;
            YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)loadFile);
            Place place = new Place();
            place.gamemode = GameMode.valueOf((String)dataFile.getString("place.GameMode"));
            String worldName = dataFile.getString("place.location.world");
            World world = Bukkit.getWorld((String)worldName);
            double x = dataFile.getDouble("place.location.x");
            double y = dataFile.getDouble("place.location.y");
            double z = dataFile.getDouble("place.location.z");
            float yaw = (float)dataFile.getDouble("place.location.yaw");
            float pitch = (float)dataFile.getDouble("place.location.pitch");
            place.location = new Location(world, x, y, z, yaw, pitch);
            place.message = dataFile.getString("place.message");
            place.message = place.message != null ? place.message.replaceAll("&", "\u00a7") : place.message;
            place.sound = dataFile.getString("place.sound");
            place.title = dataFile.getString("place.title");
            place.title = place.title != null ? place.title.replaceAll("&", "\u00a7") : place.title;
            place.menu = dataFile.getString("place.menu");
            place.canPickUpItems = dataFile.getBoolean("place.Can_Pick_Up_Items");
            place.isGravity = dataFile.getBoolean("place.Is_Gravity");
            place.clearInventory = dataFile.getBoolean("place.Clear_Inventory");
            place.invulnerable = dataFile.getBoolean("place.Invulnerable");
            place.isRestricted = dataFile.getBoolean("place.Is_Restricted");
            place.canFly = dataFile.getBoolean("place.Can_Fly");
            place.dontUpdateHunger = dataFile.getBoolean("place.Hunger");
            place.speed = dataFile.getInt("place.Speed");
            place.weather = main.WeatherType.valueOf(dataFile.getString("place.Weather"));
            place.time = main.TimeType.valueOf(dataFile.getString("place.Time"));
            place.border_enabled = dataFile.getBoolean("place.border.enabled");
            place.border_pos_x = dataFile.getInt("place.border.pos.x");
            place.border_pos_y = dataFile.getInt("place.border.pos.y");
            place.border_pos_z = dataFile.getInt("place.border.pos.z");
            place.border_neg_x = dataFile.getInt("place.border.neg.x");
            place.border_neg_y = dataFile.getInt("place.border.neg.y");
            place.border_neg_z = dataFile.getInt("place.border.neg.z");
            this.main.places.put(name, place);
        }
    }

    void SavePlace(String name) {
        if (this.main.places.containsKey(name)) {
            File saveFile = new File(this.main.getDataFolder() + "/data/place/" + name + ".yml");
            if (!saveFile.exists()) {
                saveFile.getParentFile().mkdirs();
                try {
                    saveFile.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                saveFile = new File(this.main.getDataFolder(), "data/place/" + name + ".yml");
            }
            YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)saveFile);
            try {
                Place place = this.main.places.get(name);
                dataFile.set("place.GameMode", (Object)place.gamemode.toString());
                dataFile.set("place.location.world", (Object)place.location.getWorld().getName());
                dataFile.set("place.location.x", (Object)place.location.getX());
                dataFile.set("place.location.y", (Object)place.location.getY());
                dataFile.set("place.location.z", (Object)place.location.getZ());
                dataFile.set("place.location.yaw", (Object)Float.valueOf(place.location.getYaw()));
                dataFile.set("place.location.pitch", (Object)Float.valueOf(place.location.getPitch()));
                if (place.message != null) {
                    dataFile.set("place.message", (Object)place.message.replaceAll("\u00a7", "&"));
                }
                dataFile.set("place.sound", (Object)place.sound);
                if (place.title != null) {
                    dataFile.set("place.title", (Object)place.title.replaceAll("\u00a7", "&"));
                }
                dataFile.set("place.menu", (Object)place.menu);
                dataFile.set("place.Can_Pick_Up_Items", (Object)place.canPickUpItems);
                dataFile.set("place.Is_Gravity", (Object)place.isGravity);
                dataFile.set("place.Clear_Inventory", (Object)place.clearInventory);
                dataFile.set("place.Invulnerable", (Object)place.invulnerable);
                dataFile.set("place.Is_Restricted", (Object)place.isRestricted);
                dataFile.set("place.Can_Fly", (Object)place.canFly);
                dataFile.set("place.Hunger", (Object)place.dontUpdateHunger);
                dataFile.set("place.Speed", (Object)place.speed);
                dataFile.set("place.Weather", (Object)place.weather.toString());
                dataFile.set("place.Time", (Object)place.time.toString());
                dataFile.set("place.border.enabled", (Object)place.border_enabled);
                dataFile.set("place.border.pos.x", (Object)place.border_pos_x);
                dataFile.set("place.border.pos.y", (Object)place.border_pos_y);
                dataFile.set("place.border.pos.z", (Object)place.border_pos_z);
                dataFile.set("place.border.neg.x", (Object)place.border_neg_x);
                dataFile.set("place.border.neg.y", (Object)place.border_neg_y);
                dataFile.set("place.border.neg.z", (Object)place.border_neg_z);
                dataFile.save(saveFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            List places = this.config.getStringList("places");
            if (!places.contains(name)) {
                places.add(name);
                this.config.set("places", (Object)places);
            }
        }
    }

    void SaveMenuItem(String name) {
        if (this.main.menuItems.containsKey(name)) {
            List items;
            File saveFile = new File(this.main.getDataFolder() + "/data/items/" + name + ".yml");
            if (!saveFile.exists()) {
                saveFile.getParentFile().mkdirs();
                try {
                    saveFile.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                saveFile = new File(this.main.getDataFolder(), "data/items/" + name + ".yml");
            }
            YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)saveFile);
            try {
                MenuItem item = this.main.menuItems.get(name);
                if (item != null) {
                    dataFile.set("item.data.perms", (Object)item.item);
                    dataFile.set("item.data.noperms", (Object)item.noPermsItem);
                    dataFile.set("item.exe", (Object)item.exe.toString());
                    dataFile.set("item.exe_name", (Object)item.exeName);
                    dataFile.set("item.sound", (Object)item.sound);
                    dataFile.save(saveFile);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (!(items = this.config.getStringList("items")).contains(name)) {
                items.add(name);
                this.config.set("items", (Object)items);
            }
        }
    }

    void LoadMenuItems() {
        List items = this.config.getStringList("items");
        for (String name : items) {
            File loadFile = new File(this.main.getDataFolder() + "/data/items/" + name + ".yml");
            if (!loadFile.exists()) continue;
            YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)loadFile);
            MenuItem item = new MenuItem();
            item.item = dataFile.getItemStack("item.data.perms");
            ItemMeta meta = item.item.getItemMeta();
            meta.setLocalizedName(name);
            item.item.setItemMeta(meta);
            item.noPermsItem = dataFile.getItemStack("item.data.noperms");
            ItemMeta meta2 = item.item.getItemMeta();
            meta2.setLocalizedName(name);
            item.item.setItemMeta(meta2);
            item.exe = main.ExecutionType.valueOf(dataFile.getString("item.exe"));
            item.exeName = dataFile.getString("item.exe_name");
            item.sound = dataFile.getString("item.sound");
            this.main.menuItems.put(name, item);
        }
    }

    void SaveMenuBar(String name) {
        if (this.main.toolBars.containsKey(name)) {
            File saveFile = new File(this.main.getDataFolder() + "/data/bars/" + name + ".yml");
            if (!saveFile.exists()) {
                saveFile.getParentFile().mkdirs();
                try {
                    saveFile.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                saveFile = new File(this.main.getDataFolder(), "data/bars/" + name + ".yml");
            }
            YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)saveFile);
            try {
                ToolBar bar = this.main.toolBars.get(name);
                int i = 0;
                while (i < 9) {
                    dataFile.set("bar.item_" + i, (Object)bar.itemNames.get(i));
                    ++i;
                }
                dataFile.save(saveFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            List bars = this.config.getStringList("bars");
            if (!bars.contains(name)) {
                bars.add(name);
                this.config.set("bars", (Object)bars);
            }
        }
    }

    void LoadMenuBars() {
        List items = this.config.getStringList("bars");
        for (String name : items) {
            File loadFile = new File(this.main.getDataFolder() + "/data/bars/" + name + ".yml");
            if (!loadFile.exists()) continue;
            YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)loadFile);
            ToolBar bar = new ToolBar();
            int i = 0;
            while (i < 9) {
                bar.itemNames.add(dataFile.getString("bar.item_" + i));
                ++i;
            }
            this.main.toolBars.put(name, bar);
        }
    }

    void SaveMenuInventory(String name) {
        if (this.main.menus.containsKey(name)) {
            File saveFile = new File(this.main.getDataFolder() + "/data/menus/" + name + ".yml");
            if (!saveFile.exists()) {
                saveFile.getParentFile().mkdirs();
                try {
                    saveFile.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                saveFile = new File(this.main.getDataFolder(), "data/menus/" + name + ".yml");
            }
            YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)saveFile);
            try {
                Menu menu = this.main.menus.get(name);
                dataFile.set("menu.title", (Object)menu.title);
                dataFile.set("menu.size", (Object)menu.menuList.size());
                int i = 0;
                while (i < menu.menuList.size()) {
                    dataFile.set("menu.item_" + i, (Object)menu.menuList.get(i));
                    ++i;
                }
                dataFile.save(saveFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            List menus = this.config.getStringList("menus");
            if (!menus.contains(name)) {
                menus.add(name);
                this.config.set("menus", (Object)menus);
            }
        }
    }

    void LoadMenuInventory() {
        List items = this.config.getStringList("menus");
        for (String name : items) {
            File loadFile = new File(this.main.getDataFolder() + "/data/menus/" + name + ".yml");
            if (!loadFile.exists()) continue;
            YamlConfiguration dataFile = YamlConfiguration.loadConfiguration((File)loadFile);
            Menu menu = new Menu();
            menu.title = dataFile.getString("menu.title");
            int size = dataFile.getInt("menu.size");
            int i = 0;
            while (i < size) {
                menu.menuList.add(dataFile.getString("menu.item_" + i));
                ++i;
            }
            this.main.menus.put(name, menu);
        }
    }

    void SaveDataConfig() {
        File saveFile = new File(this.main.getDataFolder() + "/data.yml");
        if (!saveFile.exists()) {
            saveFile.getParentFile().mkdirs();
            try {
                saveFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            this.config.save(saveFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void LoadDataConfig() {
        File loadFile = new File(this.main.getDataFolder() + "/data.yml");
        if (loadFile.exists()) {
            this.config = YamlConfiguration.loadConfiguration((File)loadFile);
        } else {
            loadFile.getParentFile().mkdirs();
            try {
                loadFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.config = YamlConfiguration.loadConfiguration((File)loadFile);
        }
    }

    void SaveUserDataConfig() {
        File saveFile = new File(this.main.getDataFolder() + "/data/player/data.yml");
        if (!saveFile.exists()) {
            saveFile.getParentFile().mkdirs();
            try {
                saveFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            this.playerConfig.save(saveFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void LoadUserDataConfig() {
        File loadFile = new File(this.main.getDataFolder() + "/data/player/data.yml");
        if (loadFile.exists()) {
            this.playerConfig = YamlConfiguration.loadConfiguration((File)loadFile);
        } else {
            loadFile.getParentFile().mkdirs();
            try {
                loadFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.playerConfig = YamlConfiguration.loadConfiguration((File)loadFile);
        }
    }
}

