/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.waitForCommand;

import java.util.ArrayList;
import java.util.UUID;
import nl.pim16aap2.bigDoors.BigDoors;
import nl.pim16aap2.bigDoors.Door;
import nl.pim16aap2.bigDoors.util.DoorAttribute;
import nl.pim16aap2.bigDoors.util.DoorOwner;
import nl.pim16aap2.bigDoors.util.Util;
import nl.pim16aap2.bigDoors.waitForCommand.WaitForCommand;
import org.bukkit.entity.Player;

public class WaitForRemoveOwner
extends WaitForCommand {
    private long doorUID;

    public WaitForRemoveOwner(BigDoors plugin, Player player, long doorUID) {
        super(plugin);
        this.player = player;
        this.command = "removeowner";
        this.doorUID = doorUID;
        Util.messagePlayer(player, plugin.getMessages().getString("COMMAND.RemoveOwner.Init"));
        Util.messagePlayer(player, plugin.getMessages().getString("COMMAND.SetBlocksToMove.ListOfOwners"));
        String ownersStr = "";
        ArrayList<DoorOwner> doorOwners = plugin.getCommander().getDoorOwners(doorUID, player.getUniqueId());
        for (DoorOwner owner : doorOwners) {
            ownersStr = ownersStr + owner.getPlayerName() + ", ";
        }
        Util.messagePlayer(player, ownersStr);
        plugin.addCommandWaiter(this);
    }

    @Override
    public boolean executeCommand(String[] args) {
        if (!this.plugin.getCommander().hasPermissionForAction(this.player, this.doorUID, DoorAttribute.REMOVEOWNER)) {
            return true;
        }
        if (args.length == 2) {
            UUID playerUUID = this.plugin.getCommander().playerUUIDFromName(args[1]);
            Door door = this.plugin.getCommander().getDoor(this.player.getUniqueId(), this.doorUID);
            if (playerUUID != null) {
                if (this.plugin.getCommander().removeOwner(door, playerUUID, this.getPlayer())) {
                    Util.messagePlayer(this.player, this.plugin.getMessages().getString("COMMAND.RemoveOwner.Success"));
                    this.isFinished = true;
                    this.abort();
                    return true;
                }
                Util.messagePlayer(this.player, this.plugin.getMessages().getString("COMMAND.RemoveOwner.Fail"));
                this.abort();
                return true;
            }
            Util.messagePlayer(this.player, this.plugin.getMessages().getString("GENERAL.PlayerNotFound") + ": \"" + args[1] + "\"");
            this.abort();
            return true;
        }
        this.abort();
        return false;
    }
}

