/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.util;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.security.SecureRandom;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Scanner;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import nl.pim16aap2.bigDoors.BigDoors;
import nl.pim16aap2.bigDoors.Door;
import nl.pim16aap2.bigDoors.lib.xseries.XMaterial;
import nl.pim16aap2.bigDoors.util.ConfigLoader;
import nl.pim16aap2.bigDoors.util.DoorDirection;
import nl.pim16aap2.bigDoors.util.RotateDirection;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.Plugin;

public final class Util {
    private static final Set<Material> WHITELIST = EnumSet.noneOf(Material.class);
    private static final Set<Material> BLACKLIST = EnumSet.noneOf(Material.class);
    private static final Set<Material> DESTROYLIST = EnumSet.noneOf(Material.class);
    private static final Map<DoorDirection, RotateDirection> doorDirectionMapper = new EnumMap<DoorDirection, RotateDirection>(DoorDirection.class);
    private static final Map<RotateDirection, DoorDirection> rotateDirectionMapper = new EnumMap<RotateDirection, DoorDirection>(RotateDirection.class);
    static final String chars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    static SecureRandom srnd;
    static Random rnd;
    private static final Pattern VERSION_CLEANUP;

    private Util() {
        throw new IllegalAccessError();
    }

    public static void processConfig(ConfigLoader configLoader) {
        WHITELIST.clear();
        BLACKLIST.clear();
        DESTROYLIST.clear();
        WHITELIST.addAll(configLoader.getWhitelist());
        BLACKLIST.addAll(configLoader.getBlacklist());
        DESTROYLIST.addAll(configLoader.getDestroyList());
        boolean mcMMO = Util.checkMcMMO();
        for (Material mat : Material.values()) {
            if (WHITELIST.contains(mat) || (!mcMMO || !Util.isOre(mat)) && Util.isAllowedBlockBackDoor(mat)) continue;
            BLACKLIST.add(mat);
        }
        DESTROYLIST.add(Material.AIR);
        Material caveAir = XMaterial.CAVE_AIR.parseMaterial();
        if (caveAir != null) {
            DESTROYLIST.add(caveAir);
        }
    }

    private static boolean checkMcMMO() {
        boolean mcMMO = Bukkit.getPluginManager().isPluginEnabled("mcMMO");
        if (mcMMO) {
            BigDoors.get().getMyLogger().warn("mcMMO detected! All ores are blacklisted to avoid item duplication! This can be overridden in the config.");
        }
        return mcMMO;
    }

    public static boolean isPosInCuboid(Location pos, Location min, Location max) {
        return pos.getBlockX() >= min.getBlockX() && pos.getBlockX() <= max.getBlockX() && pos.getBlockY() >= min.getBlockY() && pos.getBlockY() <= max.getBlockY() && pos.getBlockZ() >= min.getBlockZ() && pos.getBlockZ() <= max.getBlockZ();
    }

    @Nullable
    public static <T> T firstNonNull(Supplier<T> ... suppliers) {
        for (Supplier<T> supplier : suppliers) {
            T ret = supplier.get();
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public static Optional<DoorDirection> getDoorDirection(RotateDirection rot) {
        return Optional.ofNullable(rot == null ? null : rotateDirectionMapper.get((Object)rot));
    }

    public static RotateDirection getRotateDirection(DoorDirection dir) {
        if (dir == null) {
            return RotateDirection.NONE;
        }
        RotateDirection mapped = doorDirectionMapper.get((Object)dir);
        if (mapped == null) {
            throw new IllegalStateException("Failed to find rotate direction for direction: " + (Object)((Object)dir));
        }
        return mapped;
    }

    public static void messagePlayer(Player player, ChatColor color, String s) {
        player.sendMessage(color + s);
    }

    public static String throwableToString(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static void broadcastMessage(String message) {
        if (ConfigLoader.DEBUG) {
            Bukkit.broadcastMessage((String)message);
        }
    }

    public static String locIntToString(Location loc) {
        return String.format("(%d;%d;%d)", loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
    }

    public static String locDoubleToString(Location loc) {
        return String.format("(%.2f;%.2f;%.2f)", loc.getX(), loc.getY(), loc.getZ());
    }

    public static long chunkHashFromLocation(Location loc) {
        return Util.chunkHashFromLocation(loc.getBlockX(), loc.getBlockZ(), loc.getWorld().getUID());
    }

    public static long chunkHashFromLocation(int x, int z, UUID worldUUID) {
        int chunk_X = x >> 4;
        int chunk_Z = z >> 4;
        long hash = 3L;
        hash = 19L * hash + (long)worldUUID.hashCode();
        hash = 19L * hash + (long)((int)(Double.doubleToLongBits(chunk_X) ^ Double.doubleToLongBits(chunk_X) >>> 32));
        hash = 19L * hash + (long)((int)(Double.doubleToLongBits(chunk_Z) ^ Double.doubleToLongBits(chunk_Z) >>> 32));
        return hash;
    }

    public static long locationHash(Location loc) {
        return loc.hashCode();
    }

    public static long locationHash(int x, int y, int z, UUID worldUUID) {
        return Util.locationHash(new Location(Bukkit.getWorld((UUID)worldUUID), (double)x, (double)y, (double)z));
    }

    public static String randomString(int length) {
        StringBuilder sb = new StringBuilder(length);
        for (int idx = 0; idx != length; ++idx) {
            sb.append(chars.charAt(rnd.nextInt(chars.length())));
        }
        return sb.toString();
    }

    public static String secureRandomString(int length) {
        StringBuilder sb = new StringBuilder(length);
        for (int idx = 0; idx != length; ++idx) {
            sb.append(chars.charAt(srnd.nextInt(chars.length())));
        }
        return sb.toString();
    }

    public static String readSHA256FromURL(URL url) {
        Scanner scanner2 = new Scanner(url.openStream());
        try {
            String hash = scanner2.nextLine();
            String string = hash.length() == 64 ? hash : "";
            scanner2.close();
            return string;
        }
        catch (Throwable throwable) {
            try {
                try {
                    scanner2.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                return "";
            }
        }
    }

    public static String getCleanedVersionString() {
        return Util.getCleanedVersionString(BigDoors.get().getDescription().getVersion());
    }

    public static String getCleanedVersionString(String version) {
        Matcher matcher = VERSION_CLEANUP.matcher(version);
        if (!matcher.find()) {
            return "";
        }
        return matcher.group(0);
    }

    public static String getSHA256(File file) throws IOException {
        return Files.hash((File)file, (HashFunction)Hashing.sha256()).toString();
    }

    public static String nameFromUUID(UUID playerUUID) {
        if (playerUUID == null) {
            return null;
        }
        String output = null;
        Player player = Bukkit.getPlayer((UUID)playerUUID);
        output = player != null ? player.getName() : Bukkit.getOfflinePlayer((UUID)playerUUID).getName();
        return output;
    }

    public static String playerUUIDStrFromString(String input) {
        UUID playerUUID = Util.playerUUIDFromString(input);
        return playerUUID == null ? null : playerUUID.toString();
    }

    public static UUID playerUUIDFromString(String input) {
        Player player = null;
        player = Bukkit.getPlayer((String)input);
        if (player == null) {
            try {
                player = Bukkit.getPlayer((UUID)UUID.fromString(input));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (player != null) {
            return player.getName().equals(input) ? player.getUniqueId() : null;
        }
        OfflinePlayer offPlayer = null;
        try {
            offPlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(input));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (offPlayer != null) {
            return offPlayer.getName().equals(input) ? offPlayer.getUniqueId() : null;
        }
        return null;
    }

    public static String getBasicDoorInfo(Door door) {
        return String.format("%5d (%d): %s", door.getDoorUID(), door.getPermission(), door.getName());
    }

    public static String getFullDoorInfo(Door door) {
        return door == null ? "Door not found!" : door.getDoorUID() + ": " + door.getName() + ", Min(" + door.getMinimum().getBlockX() + ";" + door.getMinimum().getBlockY() + ";" + door.getMinimum().getBlockZ() + "), Max(" + door.getMaximum().getBlockX() + ";" + door.getMaximum().getBlockY() + ";" + door.getMaximum().getBlockZ() + "), Engine(" + door.getEngine().getBlockX() + ";" + door.getEngine().getBlockY() + ";" + door.getEngine().getBlockZ() + "), " + (door.isLocked() ? "" : "NOT ") + "locked; Type=" + (Object)((Object)door.getType()) + (door.getEngSide() == null ? "" : "; EngineSide = " + door.getEngSide().toString() + "; doorLen = " + door.getLength()) + ", PowerBlockPos = (" + door.getPowerBlockLoc().getBlockX() + ";" + door.getPowerBlockLoc().getBlockY() + ";" + door.getPowerBlockLoc().getBlockZ() + ") = (" + door.getPowerBlockChunkHash() + "). It is " + (door.isOpen() ? "OPEN." : "CLOSED.") + " OpenDir = " + door.getOpenDir().toString() + ", Looking " + door.getLookingDir().toString() + ". It " + (door.getAutoClose() == -1 ? "does not auto close." : "auto closes after " + door.getAutoClose() + " seconds.");
    }

    private static void playSoundSync(Location loc, String sound, float volume, float pitch) {
        int range = BigDoors.get().getConfigLoader().getSoundRange();
        if (range < 1) {
            return;
        }
        for (Entity ent : loc.getWorld().getNearbyEntities(loc, (double)range, (double)range, (double)range)) {
            if (!(ent instanceof Player)) continue;
            ((Player)ent).playSound(loc, sound, volume, pitch);
        }
    }

    public static void playSound(Location loc, String sound, float volume, float pitch) {
        Bukkit.getScheduler().callSyncMethod((Plugin)BigDoors.get(), () -> {
            Util.playSoundSync(loc, sound, volume, pitch);
            return null;
        });
    }

    public static int getMaxDoorsForPlayer(Player player) {
        if (player.isOp()) {
            return -1;
        }
        return Util.getHighestPermissionSuffix(player, "bigdoors.own.");
    }

    public static int getMaxDoorSizeForPlayer(Player player) {
        if (player.isOp()) {
            return -1;
        }
        return Util.getHighestPermissionSuffix(player, "bigdoors.maxsize.");
    }

    public static int minPositive(int ... values) {
        boolean foundPositive = false;
        int lowest = Integer.MAX_VALUE;
        for (int value : values) {
            if (value < 0) continue;
            foundPositive = true;
            if (value >= lowest) continue;
            lowest = value;
        }
        return foundPositive ? lowest : -1;
    }

    private static int getHighestPermissionSuffix(Player player, String permissionNode) {
        int ret = -1;
        for (PermissionAttachmentInfo perms : player.getEffectivePermissions()) {
            if (!perms.getPermission().startsWith(permissionNode)) continue;
            try {
                ret = Math.max(ret, Integer.parseInt(perms.getPermission().split(permissionNode)[1]));
            }
            catch (Exception exception) {}
        }
        return ret;
    }

    public static int tickRateFromSpeed(double speed) {
        int tickRate = speed > 9.0 ? 1 : (speed > 7.0 ? 2 : (speed > 6.0 ? 3 : 4));
        return tickRate;
    }

    public static double[] calculateTimeAndTickRate(int doorSize, double time, double speedMultiplier, double baseSpeed) {
        double maxSpeed;
        double[] ret = new double[3];
        double distance = Math.PI * (double)doorSize / 2.0;
        if (time == 0.0) {
            time = baseSpeed + (double)doorSize / 3.5;
        }
        double speed = distance / time;
        if (speedMultiplier != 1.0 && speedMultiplier != 0.0) {
            time = distance / (speed *= speedMultiplier);
        }
        if (speed > (maxSpeed = 11.0) || speed <= 0.0) {
            time = distance / maxSpeed;
        }
        double distanceMultiplier = speed > 4.0 ? 1.01 : (speed > 3.918 ? 1.08 : (speed > 3.916 ? 1.1 : (speed > 2.812 ? 1.12 : (speed > 2.537 ? 1.19 : (speed > 2.2 ? 1.22 : (speed > 2.0 ? 1.23 : (speed > 1.77 ? 1.25 : (speed > 1.57 ? 1.28 : 1.3))))))));
        ret[0] = time;
        ret[1] = Util.tickRateFromSpeed(speed);
        ret[2] = distanceMultiplier;
        return ret;
    }

    public static double doubleFromString(String input, double defaultVal) {
        try {
            return input == null ? defaultVal : Double.parseDouble(input);
        }
        catch (NumberFormatException e) {
            return defaultVal;
        }
    }

    public static long longFromString(String input, long defaultVal) {
        try {
            return input == null ? defaultVal : Long.parseLong(input);
        }
        catch (NumberFormatException e) {
            return defaultVal;
        }
    }

    public static void messagePlayer(Player player, String s) {
        Util.messagePlayer(player, ChatColor.WHITE, s);
    }

    public static void messagePlayer(Player player, String[] s) {
        String message = "";
        for (String str : s) {
            message = message + str + "\n";
        }
        Util.messagePlayer(player, message);
    }

    public static void messagePlayer(Player player, ChatColor color, String[] s) {
        String message = "";
        for (String str : s) {
            message = message + str + "\n";
        }
        Util.messagePlayer(player, color, message);
    }

    public static void swap(Door door, int mode) {
        Location newMin = door.getMinimum();
        Location newMax = door.getMaximum();
        switch (mode) {
            case 0: {
                double temp = door.getMaximum().getX();
                newMax.setX(newMin.getX());
                newMin.setX(temp);
                break;
            }
            case 1: {
                double temp = door.getMaximum().getY();
                newMax.setY(newMin.getY());
                newMin.setY(temp);
                break;
            }
            case 2: {
                double temp = door.getMaximum().getZ();
                newMax.setZ(newMin.getZ());
                newMin.setZ(temp);
            }
        }
    }

    @Nullable
    private static XMaterial matchXMaterial(Material mat) {
        try {
            return XMaterial.matchXMaterial(mat);
        }
        catch (Exception e) {
            BigDoors.get().getMyLogger().warn("Could not determine material of mat: " + mat.name() + ". Reason: " + e.getMessage());
            return null;
        }
    }

    public static boolean isAirOrWater(Material mat) {
        XMaterial xMat = Util.matchXMaterial(mat);
        return xMat == XMaterial.AIR || xMat == XMaterial.CAVE_AIR || xMat == XMaterial.WATER || xMat == XMaterial.LAVA;
    }

    public static boolean canOverwriteMaterial(Material mat) {
        return DESTROYLIST.contains(mat);
    }

    public static int canRotate(Material mat) {
        if (mat.toString().endsWith("STAIRS")) {
            return 2;
        }
        if (mat.toString().endsWith("_WALL")) {
            return 5;
        }
        if (mat.toString().endsWith("BUTTON") || mat.toString().endsWith("RAIL") || mat.toString().endsWith("DOOR") || mat.toString().endsWith("_HEAD") || mat.toString().endsWith("_SIGN") || mat.toString().endsWith("_BANNER") || mat.toString().endsWith("FENCE_GATE")) {
            return 8;
        }
        if (BigDoors.isOnFlattenedVersion() && mat.toString().endsWith("GLASS_PANE")) {
            return 3;
        }
        XMaterial xmat = Util.matchXMaterial(mat);
        if (xmat == null) {
            return 0;
        }
        if (xmat.equals((Object)XMaterial.ACACIA_LOG) || xmat.equals((Object)XMaterial.BIRCH_LOG) || xmat.equals((Object)XMaterial.DARK_OAK_LOG) || xmat.equals((Object)XMaterial.JUNGLE_LOG) || xmat.equals((Object)XMaterial.OAK_LOG) || xmat.equals((Object)XMaterial.SPRUCE_LOG)) {
            return 1;
        }
        if (xmat.equals((Object)XMaterial.ANVIL)) {
            return 4;
        }
        if (xmat.equals((Object)XMaterial.STRIPPED_ACACIA_LOG) || xmat.equals((Object)XMaterial.STRIPPED_BIRCH_LOG) || xmat.equals((Object)XMaterial.STRIPPED_SPRUCE_LOG) || xmat.equals((Object)XMaterial.STRIPPED_DARK_OAK_LOG) || xmat.equals((Object)XMaterial.STRIPPED_JUNGLE_LOG) || xmat.equals((Object)XMaterial.STRIPPED_OAK_LOG) || xmat.equals((Object)XMaterial.CHAIN)) {
            return 6;
        }
        if (xmat.equals((Object)XMaterial.END_ROD)) {
            return 7;
        }
        if (xmat.equals((Object)XMaterial.LIGHTNING_ROD) || xmat.equals((Object)XMaterial.REDSTONE_WIRE) || xmat.equals((Object)XMaterial.REPEATER) || xmat.equals((Object)XMaterial.TRIPWIRE_HOOK) || xmat.equals((Object)XMaterial.WALL_TORCH) || xmat.equals((Object)XMaterial.SOUL_WALL_TORCH) || xmat.equals((Object)XMaterial.REDSTONE_WALL_TORCH) || xmat.equals((Object)XMaterial.VINE) || xmat.equals((Object)XMaterial.COMPARATOR) || xmat.equals((Object)XMaterial.LADDER) || xmat.equals((Object)XMaterial.LEVER) || xmat.equals((Object)XMaterial.BIG_DRIPLEAF) || xmat.equals((Object)XMaterial.BIG_DRIPLEAF_STEM) || xmat.equals((Object)XMaterial.SMALL_DRIPLEAF) || xmat.equals((Object)XMaterial.SCULK_VEIN)) {
            return 8;
        }
        return 0;
    }

    public static boolean isAllowedBlock(Material mat) {
        if (Util.isAirOrWater(mat)) {
            return false;
        }
        return WHITELIST.contains(mat) || !BLACKLIST.contains(mat);
    }

    public static boolean isOre(Material mat) {
        XMaterial xMat = Util.matchXMaterial(mat);
        if (xMat == null) {
            return false;
        }
        return xMat == XMaterial.ANCIENT_DEBRIS || xMat.name().endsWith("_ORE");
    }

    public static boolean isAllowedBlockBackDoor(Material mat) {
        if (BigDoors.get().getConfigLoader().getBlacklist().contains(mat)) {
            return false;
        }
        String name = mat.toString();
        if (name.endsWith("SLAB") || name.endsWith("STAIRS") || name.endsWith("WALL")) {
            return true;
        }
        if (name.contains("POLISHED") || name.contains("SMOOTH") || name.contains("BRICKS") || name.contains("DEEPSLATE")) {
            return true;
        }
        if (name.endsWith("TRAPDOOR")) {
            return BigDoors.getMCVersion().isAtLeast(BigDoors.MCVersion.v1_18_R1);
        }
        if (name.endsWith("BANNER") || name.endsWith("SHULKER_BOX") || name.endsWith("DOOR") || name.endsWith("BED") || name.endsWith("SIGN") || name.endsWith("HEAD") || name.endsWith("SKULL")) {
            return false;
        }
        if (name.endsWith("CARPET") || name.endsWith("BUTTON") || name.endsWith("PRESSURE_PLATE") || name.endsWith("SAPLING") || name.endsWith("TORCH") || name.endsWith("RAIL") || name.endsWith("TULIP")) {
            return BigDoors.getMCVersion().isAtLeast(BigDoors.MCVersion.v1_18_R1);
        }
        XMaterial xmat = Util.matchXMaterial(mat);
        if (xmat == null) {
            return false;
        }
        switch (xmat) {
            case CAKE: 
            case LEVER: 
            case REDSTONE_WIRE: 
            case TRIPWIRE: 
            case TRIPWIRE_HOOK: 
            case BROWN_MUSHROOM: 
            case RED_MUSHROOM: 
            case DEAD_BUSH: 
            case FERN: 
            case LARGE_FERN: 
            case ROSE_BUSH: 
            case ATTACHED_MELON_STEM: 
            case ATTACHED_PUMPKIN_STEM: 
            case WHITE_TULIP: 
            case LILY_PAD: 
            case SUGAR_CANE: 
            case PUMPKIN_STEM: 
            case NETHER_WART: 
            case NETHER_WART_BLOCK: 
            case VINE: 
            case CHORUS_FLOWER: 
            case CHORUS_FRUIT: 
            case CHORUS_PLANT: 
            case SUNFLOWER: 
            case REPEATER: 
            case COMPARATOR: 
            case SEA_PICKLE: 
            case POPPY: 
            case BLUE_ORCHID: 
            case ALLIUM: 
            case AZURE_BLUET: 
            case OXEYE_DAISY: 
            case LILAC: 
            case PEONY: 
            case GRASS: 
            case TALL_GRASS: 
            case SEAGRASS: 
            case TALL_SEAGRASS: 
            case LADDER: 
            case DANDELION: 
            case CORNFLOWER: 
            case LILY_OF_THE_VALLEY: 
            case WITHER_ROSE: 
            case SWEET_BERRY_BUSH: 
            case LANTERN: 
            case BELL: 
            case CAVE_VINES: 
            case CAVE_VINES_PLANT: 
            case GLOW_LICHEN: 
            case MOSS_CARPET: 
            case AMETHYST_CLUSTER: 
            case BIG_DRIPLEAF: 
            case BIG_DRIPLEAF_STEM: {
                return BigDoors.getMCVersion().isAtLeast(BigDoors.MCVersion.v1_18_R1);
            }
            case AIR: 
            case WATER: 
            case LAVA: 
            case GLOW_ITEM_FRAME: 
            case ITEM_FRAME: 
            case ARMOR_STAND: 
            case BREWING_STAND: 
            case CAULDRON: 
            case CHEST: 
            case DROPPER: 
            case DRAGON_EGG: 
            case ENDER_CHEST: 
            case HOPPER: 
            case JUKEBOX: 
            case PAINTING: 
            case SPAWNER: 
            case FURNACE: 
            case FURNACE_MINECART: 
            case REDSTONE: 
            case TRAPPED_CHEST: 
            case COMMAND_BLOCK: 
            case COMMAND_BLOCK_MINECART: 
            case STRUCTURE_BLOCK: 
            case STRUCTURE_VOID: 
            case BARREL: 
            case BLAST_FURNACE: 
            case CARTOGRAPHY_TABLE: 
            case COMPOSTER: 
            case FLETCHING_TABLE: 
            case GRINDSTONE: 
            case JIGSAW: 
            case LECTERN: 
            case LOOM: 
            case SMITHING_TABLE: 
            case STONECUTTER: 
            case BEEHIVE: 
            case BEE_NEST: 
            case FROGSPAWN: {
                return false;
            }
        }
        return true;
    }

    public static Optional<UUID> parseUUID(String str) {
        try {
            return Optional.of(UUID.fromString(str));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public static OptionalInt parseInt(String str) {
        if (str == null) {
            return OptionalInt.empty();
        }
        try {
            return OptionalInt.of(Integer.parseInt(str));
        }
        catch (NumberFormatException e) {
            return OptionalInt.empty();
        }
    }

    public static boolean between(int value, int start, int end) {
        return value <= end && value >= start;
    }

    static {
        doorDirectionMapper.put(DoorDirection.NORTH, RotateDirection.NORTH);
        doorDirectionMapper.put(DoorDirection.EAST, RotateDirection.EAST);
        doorDirectionMapper.put(DoorDirection.SOUTH, RotateDirection.SOUTH);
        doorDirectionMapper.put(DoorDirection.WEST, RotateDirection.WEST);
        rotateDirectionMapper.put(RotateDirection.NORTH, DoorDirection.NORTH);
        rotateDirectionMapper.put(RotateDirection.EAST, DoorDirection.EAST);
        rotateDirectionMapper.put(RotateDirection.SOUTH, DoorDirection.SOUTH);
        rotateDirectionMapper.put(RotateDirection.WEST, DoorDirection.WEST);
        srnd = new SecureRandom();
        rnd = new Random();
        VERSION_CLEANUP = Pattern.compile("\\d+(\\.\\d+)+");
    }
}

