/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public class TimedCache<K, V> {
    private final JavaPlugin plugin;
    private int timeout = -1;
    private Map<K, Value<V>> cache = new ConcurrentHashMap<K, Value<V>>();
    private BukkitTask verifyTask;

    public TimedCache(JavaPlugin plugin, int time) {
        this.plugin = plugin;
        this.reinit(time);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        this.cache.forEach((K, V) -> sb.append(K.toString()).append("=").append(V.toString()).append(", "));
        sb.append("}");
        return sb.toString();
    }

    public void reinit(int time) {
        if (this.timeout != time) {
            this.destructor();
            this.timeout = time;
            this.startTask();
        }
        this.cache.clear();
    }

    private void startTask() {
        if (this.timeout > 0) {
            this.verifyTask = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> this.verifyCache(), (long)(600 * this.timeout), (long)(1200 * this.timeout));
        }
    }

    public void destructor() {
        if (this.timeout > 0) {
            this.verifyTask.cancel();
        }
    }

    public void put(K key, V value) {
        if (this.timeout < 0) {
            return;
        }
        this.cache.put(key, new Value<V>(value));
    }

    public V get(K key) {
        if (this.timeout < 0) {
            return null;
        }
        if (this.cache.containsKey(key)) {
            return this.cache.get(key).timedOut() ? null : (V)this.cache.get(key).value;
        }
        return null;
    }

    public boolean contains(K key) {
        return this.get(key) != null;
    }

    public void invalidate(K key) {
        this.cache.remove(key);
    }

    private void verifyCache() {
        Iterator<Map.Entry<K, Value<V>>> it = this.cache.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<K, Value<V>> entry = it.next();
            if (!entry.getValue().timedOut()) continue;
            it.remove();
        }
    }

    public ArrayList<K> getKeys() {
        if (this.timeout < 0) {
            return null;
        }
        ArrayList<K> keys = new ArrayList<K>();
        Iterator<Map.Entry<K, Value<V>>> it = this.cache.entrySet().iterator();
        while (it.hasNext()) {
            keys.add(it.next().getKey());
        }
        return keys;
    }

    public int getChunkCount() {
        return this.cache.size();
    }

    private final class Value<T> {
        public final long insertTime;
        public final T value;

        public Value(T val) {
            this.value = val;
            this.insertTime = System.currentTimeMillis();
        }

        public boolean timedOut() {
            return TimeUnit.MILLISECONDS.toMinutes(System.currentTimeMillis() - this.insertTime) > (long)TimedCache.this.timeout;
        }
    }
}

