/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.util;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.block.BlockFace;

public enum DoorDirection {
    NORTH(Math.PI, 0, BlockFace.NORTH),
    EAST(1.5707963267948966, 1, BlockFace.EAST),
    SOUTH(0.0, 2, BlockFace.SOUTH),
    WEST(4.71238898038469, 3, BlockFace.WEST);

    private static Map<Integer, DoorDirection> map;
    private static final DoorDirection[] DOOR_DIRECTIONS;
    private double extraAngle;
    private int val;
    private final BlockFace blockFace;

    private DoorDirection(double extraAngle, int val, BlockFace blockFace) {
        this.extraAngle = extraAngle;
        this.val = val;
        this.blockFace = blockFace;
    }

    public static DoorDirection getOpposite(DoorDirection dir) {
        switch (dir) {
            case NORTH: {
                return SOUTH;
            }
            case EAST: {
                return WEST;
            }
            case SOUTH: {
                return NORTH;
            }
            case WEST: {
                return EAST;
            }
        }
        return null;
    }

    public static double getExtraAngle(DoorDirection dir) {
        return dir.extraAngle;
    }

    public static int getValue(DoorDirection dir) {
        return dir.val;
    }

    public static DoorDirection valueOf(int dir) {
        return map.get(dir);
    }

    private static DoorDirection cycleCardinalDirection(int steps, DoorDirection dir) {
        int curIdx = dir.ordinal() + DOOR_DIRECTIONS.length;
        return DOOR_DIRECTIONS[(curIdx + steps) % DOOR_DIRECTIONS.length];
    }

    public static DoorDirection cycleCardinalDirection(DoorDirection dir) {
        return DoorDirection.cycleCardinalDirection(1, dir);
    }

    public static DoorDirection cycleCardinalDirectionReverse(DoorDirection dir) {
        return DoorDirection.cycleCardinalDirection(-1, dir);
    }

    public BlockFace getBlockFace() {
        return this.blockFace;
    }

    static {
        map = new HashMap<Integer, DoorDirection>();
        DOOR_DIRECTIONS = DoorDirection.values();
        for (DoorDirection dir : DoorDirection.values()) {
            map.put(dir.val, dir);
        }
    }
}

