/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import nl.pim16aap2.bigDoors.BigDoors;
import nl.pim16aap2.bigDoors.compatibility.IProtectionCompatDefinition;
import nl.pim16aap2.bigDoors.compatibility.ProtectionCompatDefinition;
import nl.pim16aap2.bigDoors.lib.xseries.XMaterial;
import nl.pim16aap2.bigDoors.util.ChunkUtils;
import nl.pim16aap2.bigDoors.util.ConfigOption;
import nl.pim16aap2.bigDoors.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigLoader {
    private static final List<Material> DEFAULT_DESTROY_LIST = ConfigLoader.createParsedMaterialsList(XMaterial.LAVA, XMaterial.WATER, XMaterial.SNOW, XMaterial.FERN, XMaterial.GRASS, XMaterial.TALL_GRASS, XMaterial.SEAGRASS, XMaterial.TALL_SEAGRASS);
    private static final List<Material> DEFAULT_BLACK_LIST = ConfigLoader.createParsedMaterialsList(XMaterial.BEDROCK, XMaterial.END_PORTAL, XMaterial.END_PORTAL_FRAME, XMaterial.NETHER_PORTAL);
    private static final List<String> DEFAULT_POWER_BLOCK = Collections.unmodifiableList(new ArrayList<String>(Collections.singletonList("GOLD_BLOCK")));
    private String dbFile;
    private final String header;
    private int coolDown;
    private boolean makeBackup;
    private boolean allowStats;
    private int maxDoorSize;
    private double pcMultiplier = 1.0;
    private double dbMultiplier = 1.0;
    private double bdMultiplier = 1.0;
    private double sdMultiplier = 1.0;
    private double flMultiplier = 1.0;
    private double elMultiplier = 1.0;
    private boolean resourcePackEnabled;
    private String resourcePack;
    private String languageFile;
    private int maxDoorCount;
    private int cacheTimeout;
    private boolean announceUpdateCheck;
    private boolean autoDLUpdate;
    private long downloadDelay;
    private boolean enableRedstone;
    private int commandWaiterTimeout;
    private boolean enableFileLogging;
    private int maxBlocksToMove;
    private int soundRange;
    private boolean unsafeMode;
    private boolean unsafeModeNotification = true;
    private boolean loadChunksForToggle;
    private int maxPowerBlockDistance;
    private int maxAutoCloseTimer;
    private boolean skipUnloadedAutoCloseToggle;
    private boolean allowNotifications;
    private boolean allowCodeGeneration;
    private boolean forceCodeGeneration;
    private Map<IProtectionCompatDefinition, Boolean> hooksMap;
    private Set<Material> powerBlockTypesMap;
    private Set<Material> blacklist;
    private Set<Material> whitelist;
    private Set<Material> destroyList;
    private String doorPrice;
    private String drawbridgePrice;
    private String portcullisPrice;
    private String slidingDoorPrice;
    private boolean refundOnDelete;
    private final ArrayList<ConfigOption> configOptionsList;
    public static boolean DEBUG = false;
    private final BigDoors plugin;
    private static final BigDoors.MCVersion LATEST_RESOURCE_PACK_VERSION = BigDoors.MCVersion.v1_18_R1;
    private static final EnumMap<BigDoors.MCVersion, String> RESOURCEPACKS = new EnumMap(BigDoors.MCVersion.class);

    public ConfigLoader(BigDoors plugin) {
        this.plugin = plugin;
        this.resourcePack = RESOURCEPACKS.getOrDefault((Object)BigDoors.getMCVersion(), RESOURCEPACKS.get((Object)LATEST_RESOURCE_PACK_VERSION));
        this.configOptionsList = new ArrayList();
        this.powerBlockTypesMap = new HashSet<Material>();
        this.hooksMap = new HashMap<IProtectionCompatDefinition, Boolean>(ProtectionCompatDefinition.DEFAULT_COMPAT_DEFINITIONS.size());
        this.header = "Config file for BigDoors. Don't forget to make a backup before making changes!";
        this.makeConfig();
    }

    public void makeConfig() {
        String[] enableRedstoneComment = new String[]{"Allow doors to be opened using redstone signals."};
        String[] powerBlockTypeComment = new String[]{"Choose the type of the power block that is used to open doors using redstone.", "A list can be found here: https://hub.spigotmc.org/javadocs/spigot/org/bukkit/Material.html", "This is the block that will open the door attached to it when it receives a redstone signal."};
        String[] blacklistComment = new String[]{"List of blacklisted materials. Materials on this list can not be animated.", "Use the same list of materials as for the power blocks. For example, you would blacklist bedrock like so:", "  - BEDROCK", "If you don't want to blacklist any materials, use \"  - NONE\" instead."};
        String[] whitelistComment = new String[]{"List of whitelisted materials. Materials on this list can be animated even if they're blacklisted ", "(either in the blacklist setting or hardcoded in the plugin).", "Use the same list of materials as for the power blocks. For example, you would whitelist a bell like so:", "  - BELL"};
        String[] destroyListComment = new String[]{"List of materials that can be destroyed by opening a door.", "Normally, when a door encounters another block in the way, it will not toggle to avoid destroying that block", "However, when the material of that block is on this list, BigDoors will ignore the block and just overwrite it.", "This is mostly intended to avoid issues with toggling doors in snowy areas."};
        String[] maxDoorCountComment = new String[]{"Maximum number of doors a player can own. -1 = infinite."};
        String[] languageFileComment = new String[]{"Specify a language file to be used. Note that en_US.txt will get regenerated!"};
        String[] dbFileComment = new String[]{"Pick the name (and location if you want) of the database."};
        String[] downloadDelayComment = new String[]{"Time (in minutes) to delay auto downloading updates after their release.", "Setting it to 2160 means that updates will be downloaded 36h after their release.", "This is useful, as it will mean that the update won't get downloaded if I decide to pull it for some reason", "(within the specified timeframe, of course). Note that updates cannot be deferred for more than 1 week (10080 minutes)."};
        String[] announceUpdateCheckComment = new String[]{"Whether to announce that the plugin is looking for updates when no updates are available.", "This does not affect the actual check, just the messages that it is checking (once per 12 hours)."};
        String[] autoDLUpdateComment = new String[]{"Allow this plugin to automatically download new updates. They will be applied on restart."};
        String[] allowStatsComment = new String[]{"Allow this plugin to send (anonymised) stats using bStats. Please consider keeping it enabled.", "It has a negligible impact on performance and more users on stats keeps me more motivated to support this plugin!", "You can see all the stats that are gathered here: https://bstats.org/plugin/bukkit/BigDoors"};
        String[] maxDoorSizeComment = new String[]{"Max. number of blocks allowed in a door (including air blocks). Doors exceeding this limit cannt be created or used.", "For example, If you'd want to allow doors of 20 by 10 blocks, you'd need a limit of at least 200.", "This is a global limit that not even OPs can bypass. Use permissions for more fine-grained control.", "Use -1 to disable this limit."};
        String[] maxPowerBlockDistanceComment = new String[]{"The maximum distance between a door's engine and its powerblock. Like maxDoorSize, this is a global limit. ", "Not even OPs can bypass it! Use -1 to disable this limit."};
        String[] maxAutocloseTimerComment = new String[]{"The maximum value of an autoCloseTimer (specified in ticks). ", "A value of 6000 is 5 minutes. Use a negative value to allow unlimited values. "};
        String[] resourcePackComment = new String[]{"This plugin uses a support resource pack for things suchs as sound.", "Different packs will be used for different versions of Minecraft:", "The resource pack for 1.11.x/1.12.x is: '" + RESOURCEPACKS.get((Object)BigDoors.MCVersion.v1_11_R1) + "'", "The resource pack for 1.13.x/1.14.x is: '" + RESOURCEPACKS.get((Object)BigDoors.MCVersion.v1_13_R1) + "'", "The resource pack for 1.15.x/1.16.x is: '" + RESOURCEPACKS.get((Object)BigDoors.MCVersion.v1_15_R1) + "'", "The resource pack for 1.17.x is: '" + RESOURCEPACKS.get((Object)BigDoors.MCVersion.v1_17_R1) + "'", "The resource pack for 1.18.x is: '" + RESOURCEPACKS.get((Object)BigDoors.MCVersion.v1_18_R1) + "'", "The resource pack for 1.19 - 1.19.2 is: '" + RESOURCEPACKS.get((Object)BigDoors.MCVersion.v1_19_R1) + "'", "The resource pack for 1.19.3 is: '" + RESOURCEPACKS.get((Object)BigDoors.MCVersion.v1_19_R2) + "'"};
        String[] multiplierComment = new String[]{"These multipliers affect the opening/closing speed of their respective door types.", "Note that the maximum speed is limited, so beyond a certain point rasising these values won't have any effect.", "To use the default values, set them to \"0.0\" or \"1.0\" (without quotation marks).", "bd = Big Door, pc = PortCullis, db = DrawBridge, sd = Sliding Door.", "Note that everything is optimized for default values, so it's recommended to leave this setting as-is."};
        String[] compatibilityHooks = new String[]{"Enable or disable compatibility hooks for certain plugins. If the plugins aren't installed, these options do nothing.", "When enabled, doors cannot be opened or created in areas not owned by the door's owner."};
        String[] coolDownComment = new String[]{"Cooldown on using doors. Time is measured in seconds."};
        String[] cacheTimeoutComment = new String[]{"Amount of time (in minutes) to cache powerblock positions. -1 means no caching (not recommended!), 0 = infinite cache.", "Doesn't take up a lot of RAM, so it's recommended to leave this value high. It'll get updated automatically when needed anyway."};
        String[] pricesComment = new String[]{"When Vault is present, you can set the price of door creation here for every type of door.", "You can use the word \"blockCount\" (without quotationmarks, case sensitive) as a variable that will be replaced by the actual blockCount.", "Furthermore, you can use these operators: -, +, *, /, sqrt(), ^, %, min(a,b), max(a,b), abs(), log(a), ln(a), e, pi, and parentheses.", "For example: \"doorPrice='max(10, sqrt(16)^4/100*blockCount)'\" would return 10 for a blockCount of 0 to 3 and 10.24 for a blockCount of 4.", "You must always put the formula or simple value or whatever in quotation marks! Also, these settings do nothing if Vault isn't installed!"};
        String[] refundOnDeleteComment = new String[]{"Whether to refund the price of the door when it is deleted. This uses the price that is currently configured for it."};
        String[] commandWaiterTimeoutComment = new String[]{"Amount of time (measured in seconds) until a command waiter times out.", "Don't forget to update the language file if you change this!"};
        String[] maxBlocksToMoveComment = new String[]{"The maximum number of blocks a door can move. This only applies to doors that move in a straight line (e.g. sliding door).", "Values less than 1 are invalid. "};
        String[] loadChunksForToggleComment = new String[]{"Try to load chunks when a door is toggled. When set to false, doors will not be toggled if more than 1 chunk needs to be loaded.", "When set to true, the plugin will try to load all chunks the door will interact with before toggling. If more than 1 chunk ", "needs to be loaded, the door will skip its animation to avoid spawning a bunch of entities no one can see anyway."};
        String[] skipUnloadedAutoCloseToggleComment = new String[]{"Skip toggles in unloaded chunks if the door has an autoCloseTimer set. ", "This avoids loading chunks only to load them again a little bit later for the autoCloseTimer. ", "The autoCloseTimer itself is not affected, so the timer can still toggle doors regardless of ", "this specific setting. ", "Note that this setting has not effect if \"loadChunksForToggle\" is disabled."};
        String[] soundRangeComment = new String[]{"The range of the sounds the doors make, counted in number of blocks. Note that using too high ranges may cause lag.", "The sound is only played at the engine of a door.", "Use a value of 0 or less to completely disable all sounds."};
        String[] unsafeModeComment = new String[]{"Only load this plugin in supported environments.", "Enabling this is NOT SUPPORTED and you WILL run into issues. ", "By enabling this option you agree that you will not complain if any issues arise and that it is completely", "your own responsibility.", "If you need to enable this option you are doing it wrong and you should rethink your life choices."};
        String[] unsafeModeNotificationComment = new String[]{"Whether to show the notification about unsafe mode to admins."};
        String[] allowNotificationsComment = new String[]{"Whether or not to allow toggle notifications. ", "When enabled, door creators can opt-in to receive notifications whenever a door is toggled.", "This is on a per-door basis."};
        String[] allowCodeGenerationComment = new String[]{"On unsupported versions of Minecraft, BigDoors can try to generate the required code itself.", "This means that the plugin may work even on unsupported versions, ", "but also that unexpected issues might pop up! Be sure to test everything when using this!", "Note that this is geared only towards NEWER version of Minecraft!", "In other words: No, this cannot be used to support 1.8! It. Will. Not. Work.", "There are many other reasons than the code to be generated why it will not work.", "The code being generated is the code used to create/move/etc animated blocks.", "So when testing this on your TEST SERVER, be sure to check that that still works."};
        String[] forceCodeGenerationComment = new String[]{"Forces BigDoors to use generated code even on supported versions.", "This may be useful in case the mappings change within a single version.", "In general, however, you will not need this and you're better off not using it!", "When this option is enabled, it overrides the \"allowCodeGeneration\" option."};
        String[] debugComment = new String[]{"Don't use this. Just leave it on false."};
        String[] enableFileLoggingComment = new String[]{"Whether to write stuff to BigDoor's own log file. Please keep this enabled if you want to receive support."};
        String[] backupComment = new String[]{"Make a backup of the database before upgrading it. I'd recommend leaving this on true. ", "In case anything goes wrong, you can just revert to the old version! Only the most recent backup will be kept."};
        FileConfiguration config = this.plugin.getConfig();
        this.enableRedstone = config.getBoolean("allowRedstone", true);
        this.configOptionsList.add(new ConfigOption("allowRedstone", this.enableRedstone, enableRedstoneComment));
        this.readPowerBlockConfig(config, powerBlockTypeComment);
        this.blacklist = this.readMaterialConfig(config, blacklistComment, "materialBlacklist", "Blacklisted", DEFAULT_BLACK_LIST);
        this.whitelist = this.readMaterialConfig(config, whitelistComment, "materialWhitelist", "Whitelisted", Collections.emptyList());
        this.destroyList = this.readMaterialConfig(config, destroyListComment, "materialDestroyList", "DestroyListed", DEFAULT_DESTROY_LIST);
        this.maxDoorCount = config.getInt("maxDoorCount", -1);
        this.configOptionsList.add(new ConfigOption("maxDoorCount", this.maxDoorCount, maxDoorCountComment));
        this.maxBlocksToMove = Math.max(1, config.getInt("maxBlocksToMove", 100));
        this.configOptionsList.add(new ConfigOption("maxBlocksToMove", this.maxBlocksToMove, maxBlocksToMoveComment));
        this.languageFile = config.getString("languageFile", "en_US");
        this.configOptionsList.add(new ConfigOption("languageFile", this.languageFile, languageFileComment));
        this.dbFile = config.getString("dbFile", "doorDB.db");
        this.configOptionsList.add(new ConfigOption("dbFile", this.dbFile, dbFileComment));
        this.announceUpdateCheck = config.getBoolean("announceUpdateCheck", true);
        this.configOptionsList.add(new ConfigOption("announceUpdateCheck", this.announceUpdateCheck, announceUpdateCheckComment));
        this.autoDLUpdate = config.getBoolean("auto-update", true);
        this.configOptionsList.add(new ConfigOption("auto-update", this.autoDLUpdate, autoDLUpdateComment));
        this.downloadDelay = Math.min(10080L, config.getLong("downloadDelay", 2160L));
        this.configOptionsList.add(new ConfigOption("downloadDelay", this.downloadDelay, downloadDelayComment));
        this.downloadDelay *= 60L;
        this.allowStats = config.getBoolean("allowStats", true);
        this.configOptionsList.add(new ConfigOption("allowStats", this.allowStats, allowStatsComment));
        int idx = 0;
        for (IProtectionCompatDefinition compat : ProtectionCompatDefinition.DEFAULT_COMPAT_DEFINITIONS) {
            String name = compat.getName().toLowerCase(Locale.US);
            boolean isEnabled = config.getBoolean(name, true);
            this.configOptionsList.add(new ConfigOption(name, isEnabled, (String[])(idx++ == 0 ? compatibilityHooks : null)));
            this.hooksMap.put(compat, isEnabled);
        }
        this.maxDoorSize = config.getInt("maxDoorSize", -1);
        this.configOptionsList.add(new ConfigOption("maxDoorSize", this.maxDoorSize, maxDoorSizeComment));
        this.maxPowerBlockDistance = config.getInt("maxPowerBlockDistance", -1);
        this.configOptionsList.add(new ConfigOption("maxPowerBlockDistance", this.maxPowerBlockDistance, maxPowerBlockDistanceComment));
        this.maxAutoCloseTimer = config.getInt("maxAutoCloseTimer", 6000);
        this.configOptionsList.add(new ConfigOption("maxAutoCloseTimer", this.maxAutoCloseTimer, maxAutocloseTimerComment));
        this.resourcePackEnabled = config.getBoolean("resourcePackEnabled", true);
        this.configOptionsList.add(new ConfigOption("resourcePackEnabled", this.resourcePackEnabled, resourcePackComment));
        this.soundRange = config.getInt("soundRange", 15);
        this.configOptionsList.add(new ConfigOption("soundRange", this.soundRange, soundRangeComment));
        this.bdMultiplier = config.getDouble("bdMultiplier", 1.0);
        this.configOptionsList.add(new ConfigOption("bdMultiplier", this.bdMultiplier, multiplierComment));
        this.pcMultiplier = config.getDouble("pcMultiplier", 1.0);
        this.configOptionsList.add(new ConfigOption("pcMultiplier", this.pcMultiplier, null));
        this.dbMultiplier = config.getDouble("dbMultiplier", 1.0);
        this.configOptionsList.add(new ConfigOption("dbMultiplier", this.dbMultiplier, null));
        this.sdMultiplier = config.getDouble("sdMultiplier", 1.0);
        this.configOptionsList.add(new ConfigOption("sdMultiplier", this.sdMultiplier, null));
        this.flMultiplier = config.getDouble("flMultiplier", 1.0);
        this.configOptionsList.add(new ConfigOption("flMultiplier", this.flMultiplier, null));
        this.elMultiplier = config.getDouble("elMultiplier", 1.0);
        this.configOptionsList.add(new ConfigOption("elMultiplier", this.elMultiplier, null));
        this.coolDown = config.getInt("coolDown", 0);
        this.configOptionsList.add(new ConfigOption("coolDown", this.coolDown, coolDownComment));
        this.makeBackup = config.getBoolean("makeBackup", true);
        this.configOptionsList.add(new ConfigOption("makeBackup", this.makeBackup, backupComment));
        this.cacheTimeout = config.getInt("cacheTimeout", 120);
        this.configOptionsList.add(new ConfigOption("cacheTimeout", this.cacheTimeout, cacheTimeoutComment));
        this.doorPrice = config.getString("doorPrice", "0");
        this.configOptionsList.add(new ConfigOption("doorPrice", this.doorPrice, pricesComment));
        this.drawbridgePrice = config.getString("drawbridgePrice", "0");
        this.configOptionsList.add(new ConfigOption("drawbridgePrice", this.drawbridgePrice, null));
        this.portcullisPrice = config.getString("portcullisPrice", "0");
        this.configOptionsList.add(new ConfigOption("portcullisPrice", this.portcullisPrice, null));
        this.slidingDoorPrice = config.getString("slidingDoorPrice", "0");
        this.configOptionsList.add(new ConfigOption("slidingDoorPrice", this.slidingDoorPrice, null));
        this.refundOnDelete = config.getBoolean("refundOnDelete", false);
        this.configOptionsList.add(new ConfigOption("refundOnDelete", this.refundOnDelete, refundOnDeleteComment));
        this.commandWaiterTimeout = config.getInt("commandWaiterTimeout", 40);
        this.configOptionsList.add(new ConfigOption("commandWaiterTimeout", this.commandWaiterTimeout, commandWaiterTimeoutComment));
        this.loadChunksForToggle = config.getBoolean("loadChunksForToggle", true);
        this.configOptionsList.add(new ConfigOption("loadChunksForToggle", this.loadChunksForToggle, loadChunksForToggleComment));
        this.skipUnloadedAutoCloseToggle = config.getBoolean("skipUnloadedAutoCloseToggle", true);
        this.configOptionsList.add(new ConfigOption("skipUnloadedAutoCloseToggle", this.skipUnloadedAutoCloseToggle, skipUnloadedAutoCloseToggleComment));
        this.allowNotifications = config.getBoolean("allowNotifications", true);
        this.configOptionsList.add(new ConfigOption("allowNotifications", this.allowNotifications, allowNotificationsComment));
        this.allowCodeGeneration = config.getBoolean("allowCodeGeneration", true);
        this.configOptionsList.add(new ConfigOption("allowCodeGeneration", this.allowCodeGeneration, allowCodeGenerationComment));
        this.forceCodeGeneration = config.getBoolean("forceCodeGeneration", false);
        this.configOptionsList.add(new ConfigOption("forceCodeGeneration", this.forceCodeGeneration, forceCodeGenerationComment));
        this.enableFileLogging = config.getBoolean("enableFileLogging", true);
        this.configOptionsList.add(new ConfigOption("enableFileLogging", this.enableFileLogging, enableFileLoggingComment));
        this.unsafeMode = config.getBoolean("unsafeMode", false);
        this.configOptionsList.add(new ConfigOption("unsafeMode", this.unsafeMode, unsafeModeComment));
        if (this.unsafeMode) {
            this.unsafeModeNotification = config.getBoolean("unsafeModeNotification", true);
            this.configOptionsList.add(new ConfigOption("unsafeModeNotification", this.unsafeModeNotification, unsafeModeNotificationComment));
        }
        DEBUG = config.getBoolean("DEBUG", false);
        this.configOptionsList.add(new ConfigOption("DEBUG", DEBUG, debugComment));
        this.writeConfig();
    }

    private void readPowerBlockConfig(FileConfiguration config, String[] powerBlockTypeComment) {
        List materialsTmp = config.getList("powerBlockTypes", DEFAULT_POWER_BLOCK);
        ArrayList<String> materials = new ArrayList<String>();
        materialsTmp.forEach(K -> materials.add(K.toString()));
        for (String str : materials) {
            if (str.equals("NONE")) continue;
            try {
                Material mat = Material.valueOf((String)str);
                if (mat.isSolid()) {
                    this.powerBlockTypesMap.add(mat);
                    continue;
                }
                this.plugin.getMyLogger().logMessage("Failed to add material: \"" + str + "\". Only solid materials are allowed to be powerblocks!", true, false);
            }
            catch (Exception e) {
                this.plugin.getMyLogger().logMessage("Failed to parse material: \"" + str + "\"", true, false);
            }
        }
        if (this.powerBlockTypesMap.size() == 0) {
            StringBuilder sb = new StringBuilder();
            DEFAULT_POWER_BLOCK.forEach(K -> sb.append((String)K).append(" "));
            this.plugin.getMyLogger().logMessage("No materials found for powerBlockType! Defaulting to:" + sb, true, false);
            DEFAULT_POWER_BLOCK.forEach(K -> {
                this.powerBlockTypesMap.add(Material.valueOf((String)K));
                materials.add((String)K);
            });
        }
        this.configOptionsList.add(new ConfigOption("powerBlockTypes", materials, powerBlockTypeComment));
        this.plugin.getMyLogger().logMessageToConsoleOnly("Power Block Types:");
        this.powerBlockTypesMap.forEach(K -> this.plugin.getMyLogger().logMessageToConsoleOnly(" - " + K.toString()));
    }

    private Set<Material> readMaterialConfig(FileConfiguration config, String[] comment, String optionName, String reportName, List<Material> defaults) {
        List materialsTmp = config.getList(optionName, defaults);
        ArrayList<String> materialNames = new ArrayList<String>();
        materialsTmp.forEach(K -> materialNames.add(K.toString()));
        ArrayList<Material> materials = new ArrayList<Material>(materialNames.size());
        for (String str : materialNames) {
            if (str.equals("NONE")) continue;
            try {
                Material mat = Material.valueOf((String)str);
                if (mat != null) {
                    materials.add(mat);
                    continue;
                }
                this.plugin.getMyLogger().logMessageToConsoleOnly("Failed to parse material: \"" + str + "\"");
            }
            catch (Exception e) {
                this.plugin.getMyLogger().logMessageToConsoleOnly("Failed to parse material: \"" + str + "\"");
            }
        }
        if (materials.size() == 0) {
            this.plugin.getMyLogger().logMessageToConsoleOnly("No materials " + reportName + "!");
        } else {
            this.plugin.getMyLogger().logMessageToConsoleOnly(reportName + " materials:");
            materialNames.forEach(K -> this.plugin.getMyLogger().logMessageToConsoleOnly(" - " + K));
        }
        this.configOptionsList.add(new ConfigOption(optionName, materialNames, comment));
        return materials.isEmpty() ? Collections.emptySet() : EnumSet.copyOf(materials);
    }

    public void writeConfig() {
        try {
            File saveTo;
            File dataFolder = this.plugin.getDataFolder();
            if (!dataFolder.exists()) {
                dataFolder.mkdirs();
            }
            if (!(saveTo = new File(this.plugin.getDataFolder(), "config.yml")).exists()) {
                saveTo.createNewFile();
            }
            if (!saveTo.canWrite()) {
                this.plugin.getMyLogger().warn("=======================================");
                this.plugin.getMyLogger().warn("============== !WARNING! ==============");
                this.plugin.getMyLogger().warn("=======================================");
                this.plugin.getMyLogger().warn("====== CANNOT WRITE CONFIG FILE! ======");
                this.plugin.getMyLogger().warn("==== NEW OPTIONS WILL NOT SHOW UP! ====");
                this.plugin.getMyLogger().warn("==== THEY WILL USE DEFAULT VALUES! ====");
                this.plugin.getMyLogger().warn("=======================================");
                this.plugin.getMyLogger().warn("============== !WARNING! ==============");
                this.plugin.getMyLogger().warn("=======================================");
            }
            FileWriter fw = new FileWriter(saveTo, false);
            PrintWriter pw = new PrintWriter(fw);
            if (this.header != null) {
                pw.println("# " + this.header + "\n");
            }
            for (int idx = 0; idx < this.configOptionsList.size(); ++idx) {
                try {
                    pw.println(this.configOptionsList.get(idx).toString() + (idx < this.configOptionsList.size() - 1 && this.configOptionsList.get(idx + 1).getComment() == null ? "" : "\n"));
                    continue;
                }
                catch (Exception e) {
                    this.plugin.getMyLogger().warn("Failed to write config option \"" + this.configOptionsList.get(idx).getName() + "\"! Please contact pim16aap2 and attach the error below:");
                    e.printStackTrace();
                    this.plugin.getMyLogger().logMessageToLogFile(Util.throwableToString(e));
                }
            }
            pw.flush();
            pw.close();
        }
        catch (IOException e) {
            Bukkit.getLogger().log(Level.SEVERE, "Could not save config.yml! Please contact pim16aap2 and show him the following code:");
            e.printStackTrace();
        }
    }

    private static List<Material> createParsedMaterialsList(XMaterial ... materials) {
        ArrayList<Material> ret = new ArrayList<Material>(materials.length);
        for (XMaterial xMat : materials) {
            Material mat = xMat.parseMaterial();
            if (mat == null) continue;
            ret.add(mat);
        }
        ret.trimToSize();
        return Collections.unmodifiableList(ret);
    }

    private static void populateResourcePacks(EnumMap<BigDoors.MCVersion, String> map, String url, BigDoors.MCVersion ... versions) {
        for (BigDoors.MCVersion version : versions) {
            map.put(version, url);
        }
    }

    public String dbFile() {
        return this.dbFile;
    }

    public boolean dbBackup() {
        return this.makeBackup;
    }

    public int coolDown() {
        return this.coolDown;
    }

    public boolean allowStats() {
        return this.allowStats;
    }

    public int maxDoorSize() {
        return this.maxDoorSize;
    }

    public int cacheTimeout() {
        return this.cacheTimeout;
    }

    public double pcMultiplier() {
        return this.pcMultiplier;
    }

    public double dbMultiplier() {
        return this.dbMultiplier;
    }

    public double bdMultiplier() {
        return this.bdMultiplier;
    }

    public double sdMultiplier() {
        return this.sdMultiplier;
    }

    public double flMultiplier() {
        return this.flMultiplier;
    }

    public double elMultiplier() {
        return this.elMultiplier;
    }

    public String resourcePack() {
        return this.resourcePack;
    }

    public String languageFile() {
        return this.languageFile;
    }

    public int maxdoorCount() {
        return this.maxDoorCount;
    }

    public boolean announceUpdateCheck() {
        return this.announceUpdateCheck;
    }

    public boolean autoDLUpdate() {
        return this.autoDLUpdate;
    }

    public long downloadDelay() {
        return this.downloadDelay;
    }

    public boolean enableRedstone() {
        return this.enableRedstone;
    }

    public Set<Material> getPowerBlockTypes() {
        return this.powerBlockTypesMap;
    }

    public boolean isHookEnabled(IProtectionCompatDefinition hook) {
        return this.hooksMap.get(hook);
    }

    public int getMaxBlocksToMove() {
        return this.maxBlocksToMove;
    }

    public String doorPrice() {
        return this.doorPrice;
    }

    public String drawbridgePrice() {
        return this.drawbridgePrice;
    }

    public String portcullisPrice() {
        return this.portcullisPrice;
    }

    public String slidingDoorPrice() {
        return this.slidingDoorPrice;
    }

    public int commandWaiterTimeout() {
        return this.commandWaiterTimeout;
    }

    public ChunkUtils.ChunkLoadMode getChunkLoadMode() {
        return this.loadChunksForToggle ? ChunkUtils.ChunkLoadMode.ATTEMPT_LOAD : ChunkUtils.ChunkLoadMode.VERIFY_LOADED;
    }

    public int maxPowerBlockDistance() {
        return this.maxPowerBlockDistance;
    }

    public int maxAutoCloseTimer() {
        return this.maxAutoCloseTimer;
    }

    public boolean skipUnloadedAutoCloseToggle() {
        return this.skipUnloadedAutoCloseToggle;
    }

    public boolean allowNotifications() {
        return this.allowNotifications;
    }

    public boolean allowCodeGeneration() {
        return this.allowCodeGeneration;
    }

    public boolean forceCodeGeneration() {
        return this.forceCodeGeneration;
    }

    public Set<Material> getBlacklist() {
        return this.blacklist;
    }

    public Set<Material> getWhitelist() {
        return this.whitelist;
    }

    public Set<Material> getDestroyList() {
        return this.destroyList;
    }

    public boolean resourcePackEnabled() {
        return this.resourcePackEnabled;
    }

    public boolean enableFileLogging() {
        return this.enableFileLogging;
    }

    public boolean unsafeMode() {
        return this.unsafeMode;
    }

    public boolean unsafeModeNotification() {
        return this.unsafeModeNotification;
    }

    public int getSoundRange() {
        return this.soundRange;
    }

    public boolean refundOnDelete() {
        return this.refundOnDelete;
    }

    static {
        ConfigLoader.populateResourcePacks(RESOURCEPACKS, "https://www.dropbox.com/s/6zdkg4jr90pc1mi/BigDoorsResourcePack-1_11.zip?dl=1", BigDoors.MCVersion.v1_11_R1, BigDoors.MCVersion.v1_12_R1);
        ConfigLoader.populateResourcePacks(RESOURCEPACKS, "https://www.dropbox.com/s/al4idl017ggpnuq/BigDoorsResourcePack-1_13.zip?dl=1", BigDoors.MCVersion.v1_13_R1, BigDoors.MCVersion.v1_13_R2, BigDoors.MCVersion.v1_14_R1);
        ConfigLoader.populateResourcePacks(RESOURCEPACKS, "https://www.dropbox.com/s/6zdkg4jr90pc1mi/BigDoorsResourcePack-1_15.zip?dl=1", BigDoors.MCVersion.v1_15_R1, BigDoors.MCVersion.v1_16_R1, BigDoors.MCVersion.v1_16_R2, BigDoors.MCVersion.v1_16_R3);
        ConfigLoader.populateResourcePacks(RESOURCEPACKS, "https://www.dropbox.com/s/frkik8qpv3jep9v/BigDoorsResourcePack-Format7.zip?dl=1", BigDoors.MCVersion.v1_17_R1);
        ConfigLoader.populateResourcePacks(RESOURCEPACKS, "https://www.dropbox.com/s/4pkvrpb9kmrq590/BigDoorsResourcePack-Format8.zip?dl=1", BigDoors.MCVersion.v1_18_R1, BigDoors.MCVersion.v1_18_R2);
        ConfigLoader.populateResourcePacks(RESOURCEPACKS, "https://www.dropbox.com/s/mrft439gckhz2cw/BigDoorsResourcePack-Format9.zip?dl=1", BigDoors.MCVersion.v1_19_R1);
        ConfigLoader.populateResourcePacks(RESOURCEPACKS, "https://www.dropbox.com/s/8vpwzjkd9jnp1xu/BigDoorsResourcePack-Format12.zip?dl=1", BigDoors.MCVersion.v1_19_R2);
    }
}

