/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import nl.pim16aap2.bigDoors.util.Pair;
import nl.pim16aap2.bigDoors.util.TriFunction;
import nl.pim16aap2.bigDoors.util.Vector2D;
import org.bukkit.Location;
import org.bukkit.World;

public final class ChunkUtils {
    private static final Method isChunkGeneratedMethod;

    private ChunkUtils() {
        throw new IllegalAccessError();
    }

    public static Pair<Vector2D, Vector2D> getChunkRangeBetweenCoords(Location locA, Location locB) {
        return ChunkUtils.getChunkRangeBetweenSortedCoords(locA, locB, locA, locB);
    }

    public static Pair<Vector2D, Vector2D> getChunkRangeBetweenSortedCoords(Location minA, Location minB, Location maxA, Location maxB) {
        int minX = Math.min(minA.getBlockX(), minB.getBlockX());
        int minZ = Math.min(minA.getBlockZ(), minB.getBlockZ());
        int maxX = Math.max(maxA.getBlockX(), maxB.getBlockX());
        int maxZ = Math.max(maxA.getBlockZ(), maxB.getBlockZ());
        return new Pair<Vector2D, Vector2D>(new Vector2D(minX >>= 4, minZ >>= 4), new Vector2D(maxX >>= 4, maxZ >>= 4));
    }

    public static Pair<Vector2D, Vector2D> getChunkRangeBetweenCoords(Location locA, Location locB, Location locC, Location locD) {
        int minX = Math.min(Math.min(locA.getBlockX(), locB.getBlockX()), Math.min(locC.getBlockX(), locD.getBlockX()));
        int minZ = Math.min(Math.min(locA.getBlockZ(), locB.getBlockZ()), Math.min(locC.getBlockZ(), locD.getBlockZ()));
        int maxX = Math.max(Math.max(locA.getBlockX(), locB.getBlockX()), Math.max(locC.getBlockX(), locD.getBlockX()));
        int maxZ = Math.max(Math.max(locA.getBlockZ(), locB.getBlockZ()), Math.max(locC.getBlockZ(), locD.getBlockZ()));
        return new Pair<Vector2D, Vector2D>(new Vector2D(minX >>= 4, minZ >>= 4), new Vector2D(maxX >>= 4, maxZ >>= 4));
    }

    public static ChunkLoadResult checkChunks(World world, Pair<Vector2D, Vector2D> chunkRange, ChunkLoadMode mode) {
        TriFunction<World, Integer, Integer, ChunkLoadResult> modeFun;
        switch (mode) {
            case VERIFY_LOADED: {
                modeFun = ChunkUtils::verifyLoaded;
                break;
            }
            case ATTEMPT_LOAD: {
                modeFun = ChunkUtils::attemptLoad;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        boolean requiredLoad = false;
        for (int x = ((Vector2D)chunkRange.first).getX(); x <= ((Vector2D)chunkRange.second).getX(); ++x) {
            for (int z = ((Vector2D)chunkRange.first).getY(); z <= ((Vector2D)chunkRange.second).getY(); ++z) {
                ChunkLoadResult result = modeFun.apply(world, x, z);
                if (result == ChunkLoadResult.REQUIRED_LOAD) {
                    requiredLoad = true;
                    continue;
                }
                if (result != ChunkLoadResult.FAIL) continue;
                return ChunkLoadResult.FAIL;
            }
        }
        return requiredLoad ? ChunkLoadResult.REQUIRED_LOAD : ChunkLoadResult.PASS;
    }

    private static boolean isChunkGenerated(World world, Integer chunkX, Integer chunkZ) {
        if (isChunkGeneratedMethod == null) {
            return true;
        }
        try {
            return (Boolean)isChunkGeneratedMethod.invoke((Object)world, chunkX, chunkZ);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return true;
        }
    }

    private static ChunkLoadResult attemptLoad(World world, Integer chunkX, Integer chunkZ) {
        if (ChunkUtils.verifyLoaded(world, chunkX, chunkZ) == ChunkLoadResult.PASS) {
            return ChunkLoadResult.PASS;
        }
        if (!ChunkUtils.isChunkGenerated(world, chunkX, chunkZ)) {
            return ChunkLoadResult.FAIL;
        }
        world.getChunkAt(chunkX.intValue(), chunkZ.intValue());
        return ChunkLoadResult.REQUIRED_LOAD;
    }

    private static ChunkLoadResult verifyLoaded(World world, Integer chunkX, Integer chunkZ) {
        return world.isChunkLoaded(chunkX.intValue(), chunkZ.intValue()) ? ChunkLoadResult.PASS : ChunkLoadResult.FAIL;
    }

    static {
        Method isChunkGeneratedMethodTmp = null;
        try {
            isChunkGeneratedMethodTmp = World.class.getMethod("isChunkGenerated\u200b", Integer.TYPE, Integer.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        isChunkGeneratedMethod = isChunkGeneratedMethodTmp;
    }

    public static enum ChunkLoadMode {
        VERIFY_LOADED,
        ATTEMPT_LOAD;

    }

    public static enum ChunkLoadResult {
        PASS,
        FAIL,
        REQUIRED_LOAD;

    }
}

