/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.toolUsers;

import nl.pim16aap2.bigDoors.BigDoors;
import nl.pim16aap2.bigDoors.toolUsers.ToolUser;
import nl.pim16aap2.bigDoors.util.DoorType;
import nl.pim16aap2.bigDoors.util.Util;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class SlidingDoorCreator
extends ToolUser {
    public SlidingDoorCreator(BigDoors plugin, Player player, String name) {
        super(plugin, player, name, DoorType.SLIDINGDOOR);
        Util.messagePlayer(player, this.messages.getString("CREATOR.SLIDINGDOOR.Init"));
        if (name == null) {
            Util.messagePlayer(player, this.messages.getString("CREATOR.GENERAL.GiveNameInstruc"));
        } else {
            this.triggerGiveTool();
        }
    }

    @Override
    protected void triggerGiveTool() {
        this.giveToolToPlayer(this.messages.getString("CREATOR.SLIDINGDOOR.StickLore").split("\n"), this.messages.getString("CREATOR.SLIDINGDOOR.StickReceived").split("\n"));
    }

    @Override
    protected boolean isReadyToCreateDoor() {
        return this.one != null && this.two != null && this.engine != null;
    }

    @Override
    protected void triggerFinishUp() {
        this.finishUp(this.messages.getString("CREATOR.SLIDINGDOOR.Success"));
    }

    private void setEngine() {
        int xMid = this.one.getBlockX() + (this.two.getBlockX() - this.one.getBlockX()) / 2;
        int zMid = this.one.getBlockZ() + (this.two.getBlockZ() - this.one.getBlockZ()) / 2;
        int yMin = this.one.getBlockY();
        this.engine = new Location(this.one.getWorld(), (double)xMid, (double)yMin, (double)zMid);
    }

    private boolean isPositionValid(Location loc) {
        if (this.one == null && this.two == null) {
            return true;
        }
        return !this.one.equals((Object)loc);
    }

    @Override
    public void selector(Location loc) {
        if (this.name == null) {
            Util.messagePlayer(this.player, this.messages.getString("CREATOR.GENERAL.GiveNameInstruc"));
            return;
        }
        String canBreakBlock = this.plugin.canBreakBlock(this.player.getUniqueId(), this.player.getName(), loc);
        if (canBreakBlock != null) {
            Util.messagePlayer(this.player, this.messages.getString("CREATOR.GENERAL.NoPermissionHere") + " " + canBreakBlock);
            return;
        }
        if (!this.isPositionValid(loc)) {
            return;
        }
        if (this.one == null) {
            this.one = loc;
            Util.messagePlayer(this.player, this.messages.getString("CREATOR.SLIDINGDOOR.Step1"));
        } else {
            this.two = loc;
        }
        if (this.one != null && this.two != null) {
            this.minMaxFix();
            this.setEngine();
            this.setIsDone(true);
        }
    }
}

