/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.toolUsers;

import nl.pim16aap2.bigDoors.BigDoors;
import nl.pim16aap2.bigDoors.Door;
import nl.pim16aap2.bigDoors.toolUsers.ToolUser;
import nl.pim16aap2.bigDoors.util.Util;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class PowerBlockRelocator
extends ToolUser {
    private final Door door;
    private boolean powerBlockLocationChanged = false;

    public PowerBlockRelocator(BigDoors plugin, Player player, Door door) {
        super(plugin, player, null, null);
        this.door = door;
        this.doorUID = door.getDoorUID();
        Util.messagePlayer(player, this.messages.getString("CREATOR.PBRELOCATOR.Init"));
        this.triggerGiveTool();
    }

    @Override
    protected void triggerGiveTool() {
        this.giveToolToPlayer(this.messages.getString("CREATOR.PBRELOCATOR.StickLore").split("\n"), this.messages.getString("CREATOR.PBRELOCATOR.StickReceived").split("\n"));
    }

    @Override
    protected void triggerFinishUp() {
        if (this.one != null) {
            if (this.powerBlockLocationChanged) {
                this.plugin.getCommander().updatePowerBlockLoc(this.doorUID, this.one);
            }
            Util.messagePlayer(this.player, this.messages.getString("CREATOR.PBRELOCATOR.Success"));
        }
        this.finishUp(null);
    }

    private boolean verifyDistance(Location loc) {
        if (this.plugin.getConfigLoader().maxPowerBlockDistance() < 0) {
            return true;
        }
        double distance = this.door.getEngine().toVector().distance(loc.toVector());
        return distance <= (double)this.plugin.getConfigLoader().maxPowerBlockDistance();
    }

    @Override
    public void selector(Location loc) {
        if (!this.verifyDistance(loc)) {
            Util.messagePlayer(this.player, this.messages.getString("CREATOR.PBRELOCATOR.LocationTooFar"));
            return;
        }
        if (loc.equals((Object)this.door.getPowerBlockLoc())) {
            this.powerBlockLocationChanged = false;
            this.applySelected(loc);
        } else if (this.plugin.getCommander().isPowerBlockLocationValid(loc)) {
            this.powerBlockLocationChanged = true;
            this.applySelected(loc);
        } else {
            Util.messagePlayer(this.player, this.messages.getString("CREATOR.PBRELOCATOR.LocationInUse"));
        }
    }

    private void applySelected(Location loc) {
        this.done = true;
        this.one = loc;
        this.setIsDone(true);
    }

    @Override
    protected boolean isReadyToCreateDoor() {
        return false;
    }
}

