/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.toolUsers;

import nl.pim16aap2.bigDoors.BigDoors;
import nl.pim16aap2.bigDoors.toolUsers.ToolUser;
import nl.pim16aap2.bigDoors.util.DoorType;
import nl.pim16aap2.bigDoors.util.Util;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class DoorCreator
extends ToolUser {
    protected String typeString;

    public DoorCreator(BigDoors plugin, Player player, String name, String typeString) {
        super(plugin, player, name, DoorType.DOOR);
        this.typeString = typeString;
        Util.messagePlayer(player, this.messages.getString("CREATOR." + typeString + ".Init"));
        if (name == null) {
            Util.messagePlayer(player, this.messages.getString("CREATOR.GENERAL.GiveNameInstruc"));
        } else {
            this.triggerGiveTool();
        }
    }

    public DoorCreator(BigDoors plugin, Player player, String name) {
        this(plugin, player, name, "DOOR");
    }

    @Override
    protected void triggerGiveTool() {
        this.giveToolToPlayer(this.messages.getString("CREATOR." + this.typeString + ".StickLore").split("\n"), this.messages.getString("CREATOR." + this.typeString + ".StickReceived").split("\n"));
    }

    @Override
    protected void triggerFinishUp() {
        this.finishUp(this.messages.getString("CREATOR." + this.typeString + ".Success"));
    }

    @Override
    protected boolean isReadyToCreateDoor() {
        return this.one != null && this.two != null && this.engine != null;
    }

    private boolean isEngineValid(Location loc) {
        if (loc.getBlockY() < this.one.getBlockY() || loc.getBlockY() > this.two.getBlockY()) {
            return false;
        }
        int xDepth = Math.abs(this.one.getBlockX() - this.two.getBlockX());
        int zDepth = Math.abs(this.one.getBlockZ() - this.two.getBlockZ());
        if (xDepth == 0 && loc.getBlockX() == this.one.getBlockX()) {
            return loc.getBlockZ() == this.one.getBlockZ() || loc.getBlockZ() == this.two.getBlockZ();
        }
        if (zDepth == 0 && loc.getBlockZ() == this.one.getBlockZ()) {
            return loc.getBlockX() == this.one.getBlockX() || loc.getBlockX() == this.two.getBlockX();
        }
        return false;
    }

    private boolean isPosTwoValid(Location loc) {
        int xDepth = Math.abs(this.one.getBlockX() - loc.getBlockX());
        int yDepth = Math.abs(this.one.getBlockY() - loc.getBlockY());
        int zDepth = Math.abs(this.one.getBlockZ() - loc.getBlockZ());
        if (yDepth == 0) {
            return false;
        }
        return xDepth == 0 ^ zDepth == 0;
    }

    @Override
    public void selector(Location loc) {
        if (this.name == null) {
            Util.messagePlayer(this.player, this.messages.getString("CREATOR.GENERAL.GiveNameInstruc"));
            return;
        }
        String canBreakBlock = this.plugin.canBreakBlock(this.player.getUniqueId(), this.player.getName(), loc);
        if (canBreakBlock != null) {
            Util.messagePlayer(this.player, this.messages.getString("CREATOR.GENERAL.NoPermissionHere") + " " + canBreakBlock);
            return;
        }
        if (this.one == null) {
            this.one = loc;
            String[] message = this.messages.getString("CREATOR." + this.typeString + ".Step1").split("\n");
            Util.messagePlayer(this.player, message);
        } else if (this.two == null) {
            if (this.isPosTwoValid(loc) && this.one != loc) {
                this.two = loc;
                String[] message = this.messages.getString("CREATOR." + this.typeString + ".Step2").split("\n");
                Util.messagePlayer(this.player, message);
                this.minMaxFix();
            } else {
                Util.messagePlayer(this.player, this.messages.getString("CREATOR.GENERAL.InvalidPoint"));
            }
        } else if (this.engine == null) {
            if (this.isEngineValid(loc)) {
                this.engine = loc;
                this.engine.setY(this.one.getY());
                this.setIsDone(true);
                this.engine.setY((double)this.one.getBlockY());
            } else {
                Util.messagePlayer(this.player, this.messages.getString("CREATOR.GENERAL.InvalidRotation"));
            }
        } else {
            this.setIsDone(true);
        }
    }
}

