/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import nl.pim16aap2.bigDoors.reflection.ParameterGroup;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ReflectionBackend {
    @Nullable
    private static final Method ENUM_VALUE_NAME;

    private ReflectionBackend() {
    }

    @NotNull
    public static Object[] getEnumValues(@NotNull Class<?> source) {
        if (ENUM_VALUE_NAME == null) {
            throw new IllegalStateException("Failed to find name method for enums!");
        }
        Object[] values = source.getEnumConstants();
        if (values == null) {
            throw new IllegalStateException("Class " + source.getName() + " is not an enum!");
        }
        return values;
    }

    @Contract(value="true, _, _ -> !null")
    public static Object getNamedEnumConstant(boolean nonNull, @NotNull Class<?> source, @NotNull String name) {
        Object[] values;
        for (Object value : values = ReflectionBackend.getEnumValues(source)) {
            try {
                if (!name.equals(ENUM_VALUE_NAME.invoke(value, new Object[0]))) continue;
                return value;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                break;
            }
        }
        if (nonNull) {
            throw new NullPointerException(String.format("Failed to find enum value: [%s.%s].", source.getName(), name));
        }
        return null;
    }

    @Contract(value="true, _, _ -> !null")
    public static Class<?> findFirstClass(boolean nonNull, int modifiers, String ... names) {
        for (String name : names) {
            try {
                Class<?> clz = Class.forName(name);
                if (modifiers != 0 && clz.getModifiers() != modifiers) continue;
                return clz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (nonNull) {
            throw new NullPointerException(String.format("Failed to find %s %s.", names.length > 1 ? "any of the classes:" : "the class:", Arrays.toString(names)));
        }
        return null;
    }

    @Contract(value="true, _, _, _, _ -> !null")
    public static Field getField(boolean nonNull, @NotNull Class<?> source, @NotNull String name, int modifiers, @Nullable Class<?> type) {
        for (Field field : source.getDeclaredFields()) {
            if (type != null && !field.getType().equals(type) || modifiers != 0 && field.getModifiers() != modifiers || !field.getName().equals(name)) continue;
            return field;
        }
        if (nonNull) {
            throw new NullPointerException(String.format("Failed to find field [%s %s %s.%s].", ReflectionBackend.optionalModifiersToString(modifiers), ReflectionBackend.formatOptionalValue(type, Class::getName), source.getName(), name));
        }
        return null;
    }

    @Contract(value="true, _, _, _ -> !null")
    public static Field getField(boolean nonNull, @NotNull Class<?> source, int modifiers, @NotNull Class<?> type) {
        for (Field field : source.getDeclaredFields()) {
            if (modifiers != 0 && field.getModifiers() != modifiers || !field.getType().equals(type)) continue;
            return field;
        }
        if (nonNull) {
            throw new NullPointerException(String.format("Failed to find field: [%s %s %s.[*]].", ReflectionBackend.optionalModifiersToString(modifiers), type.getName(), source.getName()));
        }
        return null;
    }

    @NotNull
    public static List<Field> getFields(@NotNull Class<?> source, int modifiers, @NotNull Class<?> type) {
        ArrayList<Field> ret = new ArrayList<Field>();
        for (Field field : source.getDeclaredFields()) {
            if (modifiers != 0 && field.getModifiers() != modifiers || !field.getType().equals(type)) continue;
            ret.add(field);
        }
        return ret;
    }

    private static List<Method> findMethods(@NotNull Class<?> source, @Nullable String name, int modifiers, @Nullable ParameterGroup parameters, @Nullable Class<?> returnType) {
        ArrayList<Method> ret = new ArrayList<Method>();
        for (Method method : source.getDeclaredMethods()) {
            if (modifiers != 0 && method.getModifiers() != modifiers || returnType != null && !method.getReturnType().equals(returnType) || name != null && !method.getName().equals(name) || parameters != null && !parameters.matches(method.getParameterTypes())) continue;
            ret.add(method);
        }
        return ret;
    }

    @Contract(value="true, _, _, _, _, _, _, _ -> !null")
    public static Method findMethod(boolean nonNull, boolean checkSuperClasses, boolean checkInterfaces, @NotNull Class<?> source, @Nullable String name, int modifiers, @Nullable ParameterGroup parameters, @Nullable Class<?> returnType) {
        ArrayList<Method> ret = new ArrayList<Method>();
        ReflectionBackend.findMethods(ret, checkSuperClasses, checkInterfaces, source, name, modifiers, parameters, returnType);
        if (ret.size() != 1) {
            if (nonNull) {
                throw new NullPointerException("Expected 1 method, but got " + ret.size() + " for input: " + ReflectionBackend.methodSearchRequestToString(checkSuperClasses, checkInterfaces, source, name, modifiers, parameters, returnType) + "\nFound methods: " + ret);
            }
            return null;
        }
        return (Method)ret.get(0);
    }

    public static String methodSearchRequestToString(boolean checkSuperClasses, boolean checkInterfaces, @NotNull Class<?> source, @Nullable String name, int modifiers, @Nullable ParameterGroup parameters, @Nullable Class<?> returnType) {
        return String.format("[%s %s %s#%s(%s)]. %s superclasses, %s interfaces", ReflectionBackend.optionalModifiersToString(modifiers), ReflectionBackend.formatOptionalValue(returnType, Class::getName), source.getName(), ReflectionBackend.formatOptionalValue(name), ReflectionBackend.formatOptionalValue(parameters), checkSuperClasses ? "including" : "excluding", checkInterfaces ? "including" : "excluding");
    }

    @Contract(value="true, _, _, _, _, _, _ -> !null")
    public static List<Method> findMethods(boolean checkSuperClasses, boolean checkInterfaces, @NotNull Class<?> source, @Nullable String name, int modifiers, @Nullable ParameterGroup parameters, @Nullable Class<?> returnType) {
        ArrayList<Method> ret = new ArrayList<Method>();
        ReflectionBackend.findMethods(ret, checkSuperClasses, checkInterfaces, source, name, modifiers, parameters, returnType);
        return ret;
    }

    private static void findMethods(List<Method> list, boolean checkSuperClasses, boolean checkInterfaces, @NotNull Class<?> source, @Nullable String name, int modifiers, @Nullable ParameterGroup parameters, @Nullable Class<?> returnType) {
        List<Method> methods = ReflectionBackend.findMethods(source, name, modifiers, parameters, returnType);
        if (!methods.isEmpty()) {
            list.addAll(methods);
        }
        boolean continueSuperClassChecking = checkSuperClasses;
        boolean continueInterfaceChecking = checkInterfaces;
        while (continueSuperClassChecking || continueInterfaceChecking) {
            if (continueSuperClassChecking) {
                continueSuperClassChecking = false;
                Class<?> superClass = source.getSuperclass();
                if (superClass == null) continue;
                ReflectionBackend.findMethods(list, true, continueInterfaceChecking, superClass, name, modifiers, parameters, returnType);
            }
            if (!continueInterfaceChecking) continue;
            continueInterfaceChecking = false;
            Class<?>[] superInterfaces = source.getInterfaces();
            if (superInterfaces.length == 0) continue;
            for (Class<?> superInterface : superInterfaces) {
                ReflectionBackend.findMethods(list, false, true, superInterface, name, modifiers, parameters, returnType);
            }
        }
    }

    @Contract(value="true, _, _, _ -> !null")
    public static Constructor<?> findCTor(boolean nonNull, @NotNull Class<?> source, int modifiers, @Nullable ParameterGroup parameters) {
        for (Constructor<?> ctor : source.getDeclaredConstructors()) {
            if (modifiers != 0 && ctor.getModifiers() != modifiers || parameters != null && !parameters.matches(ctor.getParameterTypes())) continue;
            return ctor;
        }
        if (nonNull) {
            throw new NullPointerException(String.format("Failed to find constructor [%s %s(%s)].", ReflectionBackend.optionalModifiersToString(modifiers), source.getName(), ReflectionBackend.formatOptionalValue(parameters)));
        }
        return null;
    }

    public static int getModifiers(int ... mods) {
        int ret = 0;
        for (int mod : mods) {
            ret |= mod;
        }
        return ret;
    }

    @NotNull
    public static String optionalModifiersToString(int modifiers) {
        return modifiers == 0 ? "[*]" : Modifier.toString(modifiers);
    }

    @NotNull
    public static <T> String formatOptionalValue(@Nullable T obj, @NotNull Function<T, String> mapper) {
        return obj == null ? "[*]" : mapper.apply(obj);
    }

    @NotNull
    public static <T> String formatOptionalValue(@Nullable T obj) {
        return ReflectionBackend.formatOptionalValue(obj, Object::toString);
    }

    static {
        Method m = null;
        try {
            m = Enum.class.getMethod("name", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        ENUM_VALUE_NAME = m;
    }
}

