/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.reflection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ParameterGroup {
    @NotNull
    private final List<Parameter> parameters;
    private final int requiredCount;

    private ParameterGroup(@NotNull List<Parameter> parameters, int requiredCount) {
        this.parameters = Collections.unmodifiableList(parameters);
        this.requiredCount = requiredCount;
    }

    public ParameterGroup(@NotNull ParameterGroup other) {
        Objects.requireNonNull(other, "Copy constructor cannot copy from null!");
        ArrayList tmpList = new ArrayList(other.parameters.size());
        other.parameters.forEach(parameter -> tmpList.add(new Parameter((Parameter)parameter)));
        this.parameters = Collections.unmodifiableList(tmpList);
        this.requiredCount = other.requiredCount;
    }

    @NotNull
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    private int findStepsToNextParameterOfType(@NotNull Class<?> target, int startIdx) {
        int skipped = 0;
        for (int idx = startIdx; idx < this.parameters.size(); ++idx) {
            Parameter parameter = this.parameters.get(idx);
            if (target.equals(parameter.getType())) {
                return skipped;
            }
            if (parameter.isRequired()) {
                return -1;
            }
            ++skipped;
        }
        return -1;
    }

    public boolean matches(@NotNull Class<?>[] types) {
        int idx;
        if (types.length > this.parameters.size()) {
            return false;
        }
        if (this.requiredCount > types.length) {
            return false;
        }
        int skipped = 0;
        for (idx = 0; idx < types.length; ++idx) {
            Class<?> type = types[idx];
            int skip = this.findStepsToNextParameterOfType(type, idx + skipped);
            if (skip == -1) {
                return false;
            }
            skipped += skip;
        }
        for (idx = types.length + skipped; idx < this.parameters.size(); ++idx) {
            if (!this.parameters.get(idx).isRequired()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        int lastIdx = this.parameters.size() - 1;
        StringBuilder sb = new StringBuilder();
        for (int idx = 0; idx < this.parameters.size(); ++idx) {
            sb.append(this.parameters.get(idx));
            if (idx == lastIdx) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static final class Parameter {
        @NotNull
        private final Class<?> type;
        private final boolean optional;

        private Parameter(@NotNull Class<?> type, boolean optional) {
            this.type = type;
            this.optional = optional;
        }

        private Parameter(@NotNull Parameter other) {
            this.type = Objects.requireNonNull(other, (String)"Copy constructor cannot copy from null!").type;
            this.optional = other.optional;
        }

        @NotNull
        private Class<?> getType() {
            return this.type;
        }

        private boolean isRequired() {
            return !this.optional;
        }

        private boolean isOptional() {
            return this.optional;
        }

        public String toString() {
            return this.optional ? "[" + this.type.getName() + "]" : this.type.getName();
        }
    }

    public static class Builder {
        @NotNull
        private final List<Parameter> parameters = new ArrayList<Parameter>();
        private int requiredCount = 0;

        public Builder() {
        }

        public Builder(@NotNull ParameterGroup group) {
            group.getParameters().forEach(parameter -> this.parameters.add(new Parameter((Parameter)parameter)));
            this.requiredCount = group.requiredCount;
        }

        @Contract(value="_ -> this")
        public Builder withRequiredParameters(Class<?> ... types) {
            Objects.requireNonNull(types);
            for (Class<?> type : types) {
                if (type == null) continue;
                this.parameters.add(new Parameter(type, false));
                ++this.requiredCount;
            }
            return this;
        }

        @Contract(value="_ -> this")
        public Builder withOptionalParameters(Class<?> ... types) {
            Objects.requireNonNull(types);
            for (Class<?> type : types) {
                if (type == null) continue;
                this.parameters.add(new Parameter(type, true));
            }
            return this;
        }

        public ParameterGroup construct() {
            return new ParameterGroup(this.parameters, this.requiredCount);
        }
    }
}

