/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.reflection;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import nl.pim16aap2.bigDoors.reflection.IBoundedRetriever;
import nl.pim16aap2.bigDoors.reflection.ReflectionBackend;
import nl.pim16aap2.bigDoors.reflection.ReflectionFinder;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldFinder {
    @Contract(value="_ -> new")
    public FieldFinderInSource inClass(@NotNull Class<?> source) {
        return new FieldFinderInSource(source);
    }

    public static final class FieldFinderInSource {
        @NotNull
        private final Class<?> source;

        private FieldFinderInSource(@NotNull Class<?> source) {
            this.source = Objects.requireNonNull(source, "Source class cannot be null!");
        }

        @Contract(value="_ -> new")
        public NamedFieldFinder withName(@NotNull String name) {
            return new NamedFieldFinder(name, this.source);
        }

        @Contract(value="_ -> new")
        public TypedFieldFinder ofType(@NotNull Class<?> type) {
            return new TypedFieldFinder(this.source, type);
        }

        @Contract(value="_ -> new")
        public TypedMultipleFieldsFinder allOfType(@NotNull Class<?> type) {
            return new TypedMultipleFieldsFinder(this.source, type);
        }
    }

    public static final class TypedMultipleFieldsFinder
    extends ReflectionFinder<List<Field>, TypedMultipleFieldsFinder>
    implements IBoundedRetriever<List<Field>, TypedMultipleFieldsFinder> {
        @NotNull
        private final Class<?> source;
        @NotNull
        private final Class<?> fieldType;
        private int expected = -1;
        private int atMost = -1;
        private int atLeast = -1;

        private TypedMultipleFieldsFinder(@NotNull Class<?> source, @NotNull Class<?> fieldType) {
            this.source = source;
            this.fieldType = Objects.requireNonNull(fieldType, "Field type cannot be null!");
        }

        @Override
        public List<Field> get() {
            List<Field> found = ReflectionBackend.getFields(this.source, this.modifiers, this.fieldType);
            if (this.expected >= 0 && this.expected != found.size()) {
                return this.handleInvalid(String.format("Expected %d fields of type %s in class %s with modifiers %d, but found %d", this.expected, this.fieldType, this.source, this.modifiers, found.size()));
            }
            if (this.atMost >= 0 && found.size() > this.atMost) {
                return this.handleInvalid(String.format("Expected at most %d fields of type %s in class %s with modifiers %d, but found %d", this.atMost, this.fieldType, this.source, this.modifiers, found.size()));
            }
            if (this.atLeast >= 0 && found.size() < this.atLeast) {
                return this.handleInvalid(String.format("Expected at least %d fields of type %s in class %s with modifiers %d, but found %d", this.atLeast, this.fieldType, this.source, this.modifiers, found.size()));
            }
            return found;
        }

        private List<Field> handleInvalid(@NotNull String str) {
            if (this.nonnull) {
                throw new IllegalStateException(str);
            }
            return null;
        }

        @Override
        public TypedMultipleFieldsFinder atLeast(int val) {
            this.atLeast = val;
            return this;
        }

        @Override
        public TypedMultipleFieldsFinder atMost(int val) {
            this.atMost = val;
            return this;
        }

        @Override
        public TypedMultipleFieldsFinder exactCount(int val) {
            this.expected = val;
            return this;
        }
    }

    public static final class TypedFieldFinder
    extends ReflectionFinder<Field, TypedFieldFinder> {
        @NotNull
        private final Class<?> source;
        @NotNull
        private final Class<?> fieldType;

        private TypedFieldFinder(@NotNull Class<?> source, @NotNull Class<?> fieldType) {
            this.source = source;
            this.fieldType = Objects.requireNonNull(fieldType, "Field type cannot be null!");
        }

        @Override
        public Field get() {
            return ReflectionBackend.getField(this.nonnull, this.source, this.modifiers, this.fieldType);
        }
    }

    public static final class NamedFieldFinder
    extends ReflectionFinder<Field, NamedFieldFinder> {
        @NotNull
        private final String name;
        @NotNull
        private final Class<?> source;
        @Nullable
        private Class<?> fieldType = null;

        private NamedFieldFinder(@NotNull String name, @NotNull Class<?> source) {
            this.name = Objects.requireNonNull(name, "Name cannot be null!");
            this.source = source;
        }

        @Override
        public Field get() {
            return ReflectionBackend.getField(this.nonnull, this.source, this.name, this.modifiers, this.fieldType);
        }

        @Contract(value="_ -> this")
        public NamedFieldFinder ofType(@Nullable Class<?> fieldType) {
            this.fieldType = fieldType;
            return this;
        }
    }
}

