/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.reflection;

import java.util.Objects;
import nl.pim16aap2.bigDoors.reflection.ReflectionBackend;
import nl.pim16aap2.bigDoors.reflection.ReflectionFinder;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class EnumValuesFinder {
    @Contract(value="_ -> new")
    public EnumValuesFinderInSource inClass(@NotNull Class<?> source) {
        return new EnumValuesFinderInSource(source);
    }

    public static class EnumValuesFinderInSource
    extends ReflectionFinder<Object[], EnumValuesFinderInSource> {
        @NotNull
        private final Class<?> source;

        private EnumValuesFinderInSource(@NotNull Class<?> source) {
            this.source = Objects.requireNonNull(source, "Source class cannot be null!");
        }

        @Override
        @NotNull
        public Object[] get() {
            return ReflectionBackend.getEnumValues(this.source);
        }

        @Contract(value="_ -> new")
        public NamedEnumValueFinder withName(@NotNull String name) {
            return new NamedEnumValueFinder(this.source, Objects.requireNonNull(name, "Name of named enum constant cannot be null!"));
        }

        @Contract(value="_ -> new")
        public IndexedEnumValueFinder atIndex(int index) {
            return new IndexedEnumValueFinder(this.source, index);
        }
    }

    public static final class IndexedEnumValueFinder
    extends ReflectionFinder<Object, NamedEnumValueFinder> {
        @NotNull
        private final Class<?> source;
        private final int index;

        private IndexedEnumValueFinder(@NotNull Class<?> source, int index) {
            this.source = source;
            this.index = index;
        }

        @Override
        public Object get() {
            Object[] values = ReflectionBackend.getEnumValues(this.source);
            if (this.index >= values.length) {
                if (this.nonnull) {
                    throw new NullPointerException(String.format("Requested index %d exceeded the %d enum values found in class %s!", this.index, values.length, this.source.getName()));
                }
                return null;
            }
            return values[this.index];
        }
    }

    public static final class NamedEnumValueFinder
    extends ReflectionFinder<Object, NamedEnumValueFinder> {
        @NotNull
        private final Class<?> source;
        @NotNull
        private final String name;

        private NamedEnumValueFinder(@NotNull Class<?> source, @NotNull String name) {
            this.source = source;
            this.name = name;
        }

        @Override
        public Object get() {
            return ReflectionBackend.getNamedEnumConstant(this.nonnull, this.source, this.name);
        }
    }
}

