/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.moveBlocks;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import nl.pim16aap2.bigDoors.BigDoors;
import nl.pim16aap2.bigDoors.Door;
import nl.pim16aap2.bigDoors.moveBlocks.Opener;
import nl.pim16aap2.bigDoors.moveBlocks.VerticalMover;
import nl.pim16aap2.bigDoors.util.ChunkUtils;
import nl.pim16aap2.bigDoors.util.DoorOpenResult;
import nl.pim16aap2.bigDoors.util.Pair;
import nl.pim16aap2.bigDoors.util.RotateDirection;
import nl.pim16aap2.bigDoors.util.Util;
import nl.pim16aap2.bigDoors.util.Vector2D;
import org.bukkit.Location;
import org.bukkit.World;

public class PortcullisOpener
implements Opener {
    private static final List<RotateDirection> VALID_ROTATE_DIRECTIONS = Collections.unmodifiableList(Arrays.asList(RotateDirection.UP, RotateDirection.DOWN));
    private final BigDoors plugin;

    public PortcullisOpener(BigDoors plugin) {
        this.plugin = plugin;
    }

    @Override
    @Nonnull
    public List<RotateDirection> getValidRotateDirections() {
        return VALID_ROTATE_DIRECTIONS;
    }

    @Override
    public Pair<Vector2D, Vector2D> getChunkRange(Door door) {
        return this.getCurrentChunkRange(door);
    }

    protected boolean isRotateDirectionValid(RotateDirection openDirection) {
        return openDirection.equals((Object)RotateDirection.UP) || openDirection.equals((Object)RotateDirection.DOWN);
    }

    @Override
    public boolean isRotateDirectionValid(@Nonnull Door door) {
        return this.isRotateDirectionValid(door.getOpenDir());
    }

    @Override
    public RotateDirection getRotateDirection(Door door) {
        if (this.isRotateDirectionValid(door)) {
            return door.getOpenDir();
        }
        return RotateDirection.UP;
    }

    @Override
    @Nonnull
    public Optional<Pair<Location, Location>> getNewCoordinates(@Nonnull Door door) {
        if (door.getBlocksToMove() > this.plugin.getConfigLoader().getMaxBlocksToMove()) {
            return Optional.empty();
        }
        int maxDoorSize = this.getSizeLimit(door);
        if (maxDoorSize > 0 && door.getBlockCount() > maxDoorSize) {
            this.plugin.getMyLogger().warn("Size " + door.getBlockCount() + " exceeds limit of " + maxDoorSize + " for portcullis: " + door);
            return Optional.empty();
        }
        int blocksToMove = this.getBlocksToMove(door);
        if (blocksToMove == 0) {
            return Optional.empty();
        }
        return Optional.of(new Pair<Location, Location>(door.getMinimum().add(0.0, (double)blocksToMove, 0.0), door.getMaximum().add(0.0, (double)blocksToMove, 0.0)));
    }

    @Override
    @Nonnull
    public DoorOpenResult openDoor(@Nonnull Door door, double time, boolean instantOpen, boolean silent, @Nonnull ChunkUtils.ChunkLoadMode mode, boolean bypassProtectionHooks) {
        int maxDoorSize;
        if (!this.plugin.getCommander().canGo()) {
            this.plugin.getMyLogger().info("Failed to toggle: " + door.toSimpleString() + ", as door toggles are currently disabled!");
            return this.abort(DoorOpenResult.ERROR, door.getDoorUID());
        }
        if (this.plugin.getCommander().isDoorBusyRegisterIfNot(door.getDoorUID())) {
            if (!silent) {
                this.plugin.getMyLogger().myLogger(Level.INFO, "Portcullis " + door.toSimpleString() + " is not available right now!");
            }
            return this.abort(DoorOpenResult.BUSY, door.getDoorUID());
        }
        ChunkUtils.ChunkLoadResult chunkLoadResult = this.chunksLoaded(door, mode);
        if (chunkLoadResult == ChunkUtils.ChunkLoadResult.FAIL) {
            this.plugin.getMyLogger().logMessage("Chunks for portcullis " + door.toSimpleString() + " are not loaded!", true, false);
            return this.abort(DoorOpenResult.CHUNKSNOTLOADED, door.getDoorUID());
        }
        if (chunkLoadResult == ChunkUtils.ChunkLoadResult.REQUIRED_LOAD) {
            instantOpen = true;
        }
        if ((maxDoorSize = this.getSizeLimit(door)) > 0 && door.getBlockCount() > maxDoorSize) {
            this.plugin.getMyLogger().logMessage("Portcullis " + door.toSimpleString() + " Exceeds the size limit: " + maxDoorSize, true, false);
            return this.abort(DoorOpenResult.ERROR, door.getDoorUID());
        }
        if (door.getBlocksToMove() > BigDoors.get().getConfigLoader().getMaxBlocksToMove()) {
            this.plugin.getMyLogger().logMessage("Portcullis " + door.toSimpleString() + " Exceeds blocksToMove limit: " + door.getBlocksToMove() + ". Limit = " + BigDoors.get().getConfigLoader().getMaxBlocksToMove(), true, false);
            return this.abort(DoorOpenResult.BLOCKSTOMOVEINVALID, door.getDoorUID());
        }
        int blocksToMove = this.getBlocksToMove(door);
        if (blocksToMove == 0) {
            return this.abort(DoorOpenResult.NODIRECTION, door.getDoorUID());
        }
        Location newMin = door.getMinimum().add(0.0, (double)blocksToMove, 0.0);
        Location newMax = door.getMaximum().add(0.0, (double)blocksToMove, 0.0);
        if (!bypassProtectionHooks && !this.hasAccessToLocations(door, newMin, newMax)) {
            return this.abort(DoorOpenResult.NOPERMISSION, door.getDoorUID());
        }
        if (!this.isRotateDirectionValid(door)) {
            RotateDirection openDirection = door.isOpen() ? (blocksToMove > 0 ? RotateDirection.DOWN : RotateDirection.UP) : (blocksToMove > 0 ? RotateDirection.UP : RotateDirection.DOWN);
            this.plugin.getMyLogger().logMessage("Updating openDirection of portcullis " + door.toSimpleString() + " to " + openDirection.name() + ". If this is undesired, change it via the GUI.", true, false);
            this.plugin.getCommander().updateDoorOpenDirection(door.getDoorUID(), openDirection);
        }
        if (this.fireDoorEventTogglePrepare(door, instantOpen)) {
            return this.abort(DoorOpenResult.CANCELLED, door.getDoorUID());
        }
        this.plugin.getCommander().addBlockMover(new VerticalMover(this.plugin, door.getWorld(), time, door, instantOpen, blocksToMove, this.plugin.getConfigLoader().pcMultiplier()));
        this.fireDoorEventToggleStart(door, instantOpen);
        return DoorOpenResult.SUCCESS;
    }

    private int getBlocksInDir(Door door, RotateDirection upDown) {
        int yGoal;
        int blocksUp = 0;
        int xMin = door.getMinimum().getBlockX();
        int yMin = door.getMinimum().getBlockY();
        int zMin = door.getMinimum().getBlockZ();
        int xMax = door.getMaximum().getBlockX();
        int yMax = door.getMaximum().getBlockY();
        int zMax = door.getMaximum().getBlockZ();
        int yLen = yMax - yMin + 1;
        int blocksToMoveLimit = BigDoors.get().getConfigLoader().getMaxBlocksToMove();
        int distanceToWorldLimit = this.getDistanceToWorldLimit(door, this.plugin.getWorldHeightManager(), upDown);
        int blocksToMove = door.getBlocksToMove() < 1 ? yLen : door.getBlocksToMove();
        int distanceToCheck = Util.minPositive(blocksToMove, blocksToMoveLimit, distanceToWorldLimit);
        if (distanceToCheck <= 0) {
            return 0;
        }
        World world = door.getWorld();
        int delta = upDown == RotateDirection.DOWN ? -1 : 1;
        int yAxis = upDown == RotateDirection.DOWN ? yMin - 1 : yMax + 1;
        int n = yGoal = upDown == RotateDirection.DOWN ? yMin - distanceToCheck - 1 : yMax + distanceToCheck + 1;
        while (yAxis != yGoal) {
            for (int xAxis = xMin; xAxis <= xMax; ++xAxis) {
                for (int zAxis = zMin; zAxis <= zMax; ++zAxis) {
                    if (Util.canOverwriteMaterial(world.getBlockAt(xAxis, yAxis, zAxis).getType())) continue;
                    return blocksUp;
                }
            }
            yAxis += delta;
            blocksUp += delta;
        }
        return blocksUp;
    }

    private RotateDirection getCurrentDirection(Door door) {
        if (!door.isOpen()) {
            return door.getOpenDir();
        }
        if (door.getOpenDir().equals((Object)RotateDirection.UP)) {
            return RotateDirection.DOWN;
        }
        if (door.getOpenDir().equals((Object)RotateDirection.DOWN)) {
            return RotateDirection.UP;
        }
        return RotateDirection.NONE;
    }

    private int getBlocksToMove(Door door) {
        int blocksDown;
        RotateDirection openDir = this.getCurrentDirection(door);
        if (this.isRotateDirectionValid(openDir)) {
            return this.getBlocksInDir(door, openDir);
        }
        int blocksUp = this.getBlocksInDir(door, RotateDirection.UP);
        return blocksUp > -1 * (blocksDown = this.getBlocksInDir(door, RotateDirection.DOWN)) ? blocksUp : blocksDown;
    }
}

