/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.moveBlocks;

import java.util.ArrayList;
import nl.pim16aap2.bigDoors.BigDoors;
import nl.pim16aap2.bigDoors.Door;
import nl.pim16aap2.bigDoors.NMS.CustomCraftFallingBlock;
import nl.pim16aap2.bigDoors.NMS.FallingBlockFactory;
import nl.pim16aap2.bigDoors.NMS.NMSBlock;
import nl.pim16aap2.bigDoors.moveBlocks.BlockMover;
import nl.pim16aap2.bigDoors.moveBlocks.Cylindrical.getNewLocation.GetNewLocation;
import nl.pim16aap2.bigDoors.moveBlocks.Cylindrical.getNewLocation.GetNewLocationEast;
import nl.pim16aap2.bigDoors.moveBlocks.Cylindrical.getNewLocation.GetNewLocationNorth;
import nl.pim16aap2.bigDoors.moveBlocks.Cylindrical.getNewLocation.GetNewLocationSouth;
import nl.pim16aap2.bigDoors.moveBlocks.Cylindrical.getNewLocation.GetNewLocationWest;
import nl.pim16aap2.bigDoors.util.DoorDirection;
import nl.pim16aap2.bigDoors.util.MyBlockData;
import nl.pim16aap2.bigDoors.util.RotateDirection;
import nl.pim16aap2.bigDoors.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.material.MaterialData;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class CylindricalMover
extends BlockMover {
    private GetNewLocation gnl;
    private final FallingBlockFactory fabf;
    private final double time;
    private final Door door;
    private final World world;
    private final int dx;
    private final int dz;
    private final BigDoors plugin;
    private final int tickRate;
    private double endStepSum;
    private double multiplier;
    private double startStepSum;
    private final RotateDirection rotDirection;
    private final Location pointOpposite;
    private final int stepMultiplier;
    private final int xMin;
    private final int xMax;
    private final int yMin;
    private final int yMax;
    private final int zMin;
    private final int zMax;
    private final DoorDirection currentDirection;
    private final Location turningPoint;
    private int endCount = 0;
    private BukkitRunnable animationRunnable;

    public CylindricalMover(BigDoors plugin, World world, int qCircleLimit, RotateDirection rotDirection, double time, Location pointOpposite, DoorDirection currentDirection, Door door, boolean instantOpen, double multiplier) {
        super(plugin, door, instantOpen);
        this.rotDirection = rotDirection;
        this.currentDirection = currentDirection;
        this.plugin = plugin;
        this.world = world;
        this.door = door;
        this.pointOpposite = pointOpposite;
        this.turningPoint = door.getEngine();
        this.fabf = plugin.getFABF();
        this.stepMultiplier = rotDirection == RotateDirection.CLOCKWISE ? -1 : 1;
        this.xMin = Math.min(this.turningPoint.getBlockX(), pointOpposite.getBlockX());
        this.yMin = Math.min(this.turningPoint.getBlockY(), pointOpposite.getBlockY());
        this.zMin = Math.min(this.turningPoint.getBlockZ(), pointOpposite.getBlockZ());
        this.xMax = Math.max(this.turningPoint.getBlockX(), pointOpposite.getBlockX());
        this.yMax = Math.max(this.turningPoint.getBlockY(), pointOpposite.getBlockY());
        this.zMax = Math.max(this.turningPoint.getBlockZ(), pointOpposite.getBlockZ());
        int xLen = Math.abs(door.getMaximum().getBlockX() - door.getMinimum().getBlockX());
        int zLen = Math.abs(door.getMaximum().getBlockZ() - door.getMinimum().getBlockZ());
        int doorSize = Math.max(xLen, zLen) + 1;
        double[] vars = Util.calculateTimeAndTickRate(doorSize, time, multiplier, 3.7);
        this.time = vars[0];
        this.tickRate = (int)vars[1];
        this.multiplier = vars[2];
        this.dx = pointOpposite.getBlockX() > this.turningPoint.getBlockX() ? 1 : -1;
        this.dz = pointOpposite.getBlockZ() > this.turningPoint.getBlockZ() ? 1 : -1;
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)plugin, this::createAnimatedBlocks, 2L);
    }

    private void createAnimatedBlocks() {
        this.savedBlocks.ensureCapacity(this.door.getBlockCount());
        ArrayList<NMSBlock> edges = new ArrayList<NMSBlock>(Math.min(this.door.getBlockCount(), (this.xMax - this.xMin + 1) * 2 + (this.yMax - this.yMin + 1) * 2 + (this.zMax - this.zMin + 1) * 2));
        int xAxis = this.turningPoint.getBlockX();
        do {
            int zAxis = this.turningPoint.getBlockZ();
            do {
                double xRadius = Math.abs(xAxis - this.turningPoint.getBlockX());
                double zRadius = Math.abs(zAxis - this.turningPoint.getBlockZ());
                double radius = Math.max(xRadius, zRadius);
                for (int yAxis = this.yMin; yAxis <= this.yMax; ++yAxis) {
                    Location startLocation = new Location(this.world, (double)xAxis + 0.5, (double)yAxis, (double)zAxis + 0.5);
                    Location newFBlockLocation = new Location(this.world, (double)xAxis + 0.5, (double)yAxis, (double)zAxis + 0.5);
                    Block vBlock = this.world.getBlockAt(xAxis, yAxis, zAxis);
                    Material mat = vBlock.getType();
                    if (!Util.isAllowedBlock(mat)) continue;
                    byte matData = vBlock.getData();
                    BlockState bs = vBlock.getState();
                    MaterialData materialData = bs.getData();
                    NMSBlock block2 = this.fabf.nmsBlockFactory(this.world, xAxis, yAxis, zAxis);
                    NMSBlock block22 = null;
                    byte matByte = matData;
                    int canRotate = Util.canRotate(mat);
                    if (canRotate != 0) {
                        Location pos = new Location(this.world, (double)xAxis, (double)yAxis, (double)zAxis);
                        if (canRotate == 1 || canRotate == 3) {
                            matByte = this.rotateBlockDataLog(matData);
                        } else if (canRotate == 2) {
                            matByte = this.rotateBlockDataStairs(matData);
                        } else if (canRotate == 4) {
                            matByte = this.rotateBlockDataAnvil(matData);
                        } else if (canRotate == 7) {
                            matByte = this.rotateBlockDataEndRod(matData);
                        }
                        Block b = this.world.getBlockAt(pos);
                        materialData.setData(matByte);
                        if (BigDoors.isOnFlattenedVersion()) {
                            if (canRotate == 6 || canRotate == 8) {
                                block22 = this.fabf.nmsBlockFactory(this.world, xAxis, yAxis, zAxis);
                                block22.rotateCylindrical(this.rotDirection);
                            } else {
                                b.setType(mat);
                                BlockState bs2 = b.getState();
                                bs2.setData(materialData);
                                bs2.update();
                                block22 = this.fabf.nmsBlockFactory(this.world, xAxis, yAxis, zAxis);
                            }
                        }
                    }
                    if (!BigDoors.isOnFlattenedVersion()) {
                        vBlock.setType(Material.AIR);
                    }
                    CustomCraftFallingBlock fBlock = null;
                    if (!this.instantOpen) {
                        fBlock = this.fabf.fallingBlockFactory(newFBlockLocation, block2, matData, mat);
                    }
                    this.savedBlocks.add(new MyBlockData(mat, matByte, fBlock, radius, materialData, block22 == null ? block2 : block22, canRotate, startLocation));
                    if (xAxis != this.xMin && xAxis != this.xMax && yAxis != this.yMin && yAxis != this.yMax && zAxis != this.zMin && zAxis != this.zMax) continue;
                    edges.add(block2);
                }
            } while ((zAxis += this.dz) >= this.pointOpposite.getBlockZ() && this.dz == -1 || zAxis <= this.pointOpposite.getBlockZ() && this.dz == 1);
        } while ((xAxis += this.dx) >= this.pointOpposite.getBlockX() && this.dx == -1 || xAxis <= this.pointOpposite.getBlockX() && this.dx == 1);
        switch (this.currentDirection) {
            case NORTH: {
                this.gnl = new GetNewLocationNorth(this.world, this.xMin, this.xMax, this.zMin, this.zMax, this.rotDirection);
                this.startStepSum = Math.PI;
                this.endStepSum = this.rotDirection == RotateDirection.CLOCKWISE ? 1.5707963267948966 : 4.71238898038469;
                break;
            }
            case EAST: {
                this.gnl = new GetNewLocationEast(this.world, this.xMin, this.xMax, this.zMin, this.zMax, this.rotDirection);
                this.startStepSum = 1.5707963267948966;
                this.endStepSum = this.rotDirection == RotateDirection.CLOCKWISE ? 0.0 : Math.PI;
                break;
            }
            case SOUTH: {
                this.gnl = new GetNewLocationSouth(this.world, this.xMin, this.xMax, this.zMin, this.zMax, this.rotDirection);
                this.startStepSum = 0.0;
                this.endStepSum = this.rotDirection == RotateDirection.CLOCKWISE ? 4.71238898038469 : 1.5707963267948966;
                break;
            }
            case WEST: {
                this.gnl = new GetNewLocationWest(this.world, this.xMin, this.xMax, this.zMin, this.zMax, this.rotDirection);
                this.startStepSum = 4.71238898038469;
                double d = this.endStepSum = this.rotDirection == RotateDirection.CLOCKWISE ? Math.PI : 0.0;
            }
        }
        if (BigDoors.isOnFlattenedVersion()) {
            this.savedBlocks.forEach(myBlockData -> myBlockData.getBlock().deleteOriginalBlock(false));
            edges.forEach(block -> block.deleteOriginalBlock(true));
        }
        this.savedBlocks.trimToSize();
        if (!this.instantOpen) {
            this.rotateEntities();
        } else {
            this.putBlocks(false);
        }
    }

    @Override
    public synchronized void cancel(boolean onDisable) {
        if (this.animationRunnable == null) {
            return;
        }
        this.animationRunnable.cancel();
        this.putBlocks(onDisable);
    }

    @Override
    public synchronized void putBlocks(boolean onDisable) {
        super.putBlocks(onDisable, this.time, this.endCount, this.gnl::getNewLocation, () -> CylindricalMover.updateCoords(this.door, this.currentDirection, this.rotDirection, -1, false));
    }

    private void rotateEntities() {
        this.endCount = (int)((double)(20.0f / (float)this.tickRate) * this.time);
        this.animationRunnable = new BukkitRunnable(){
            final Location center;
            boolean replace;
            double counter;
            final double step;
            double stepSum;
            final int totalTicks;
            final int replaceCount;
            long startTime;
            long lastTime;
            long currentTime;
            {
                this.center = new Location(CylindricalMover.this.world, (double)CylindricalMover.this.turningPoint.getBlockX() + 0.5, (double)CylindricalMover.this.yMin, (double)CylindricalMover.this.turningPoint.getBlockZ() + 0.5);
                this.replace = false;
                this.counter = 0.0;
                this.step = 1.5707963267948966 / (double)CylindricalMover.this.endCount * (double)CylindricalMover.this.stepMultiplier;
                this.stepSum = CylindricalMover.this.startStepSum;
                this.totalTicks = (int)((double)CylindricalMover.this.endCount * CylindricalMover.this.multiplier);
                this.replaceCount = CylindricalMover.this.endCount / 2;
                this.startTime = System.nanoTime();
                this.currentTime = System.nanoTime();
            }

            public void run() {
                if (this.counter == 0.0 || this.counter < (double)(CylindricalMover.this.endCount - 27 / CylindricalMover.this.tickRate) && this.counter % (double)(5 * CylindricalMover.this.tickRate / 4) == 0.0) {
                    Util.playSound(CylindricalMover.this.door.getEngine(), "bd.dragging2", 0.5f, 0.6f);
                }
                this.lastTime = this.currentTime;
                this.currentTime = System.nanoTime();
                long msSinceStart = (this.currentTime - this.startTime) / 1000000L;
                if (!CylindricalMover.this.plugin.getCommander().isPaused()) {
                    this.counter = msSinceStart / (long)(50 * CylindricalMover.this.tickRate);
                } else {
                    this.startTime += this.currentTime - this.lastTime;
                }
                this.stepSum = this.counter < (double)(CylindricalMover.this.endCount - 1) ? CylindricalMover.this.startStepSum + this.step * this.counter : CylindricalMover.this.endStepSum;
                boolean bl = this.replace = this.counter == (double)this.replaceCount;
                if (!CylindricalMover.this.plugin.getCommander().canGo() || this.counter > (double)this.totalTicks) {
                    Util.playSound(CylindricalMover.this.door.getEngine(), "bd.closing-vault-door", 0.2f, 1.0f);
                    for (MyBlockData savedBlock : CylindricalMover.this.savedBlocks) {
                        if (savedBlock.getMat().equals((Object)Material.AIR)) continue;
                        savedBlock.getFBlock().setVelocity(new Vector(0.0, 0.0, 0.0));
                    }
                    Bukkit.getScheduler().callSyncMethod((Plugin)CylindricalMover.this.plugin, () -> {
                        CylindricalMover.this.putBlocks(false);
                        return null;
                    });
                    this.cancel();
                } else {
                    if (this.replace) {
                        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)CylindricalMover.this.plugin, () -> {
                            for (MyBlockData block : CylindricalMover.this.savedBlocks) {
                                if (block.canRot() == 0 || block.canRot() == 5) continue;
                                Material mat = block.getMat();
                                Location loc = block.getFBlock().getLocation();
                                byte matData = block.getBlockByte();
                                Vector veloc = block.getFBlock().getVelocity();
                                CustomCraftFallingBlock fBlock = CylindricalMover.this.fabf.fallingBlockFactory(loc, block.getBlock(), matData, mat);
                                block.getFBlock().remove();
                                block.setFBlock(fBlock);
                                block.getFBlock().setVelocity(veloc);
                            }
                        }, 0L);
                    }
                    double sin = Math.sin(this.stepSum);
                    double cos = Math.cos(this.stepSum);
                    for (MyBlockData block : CylindricalMover.this.savedBlocks) {
                        if (block.getMat().equals((Object)Material.AIR)) continue;
                        double radius = block.getRadius();
                        double yPos = block.getStartLocation().getBlockY();
                        if (radius == 0.0) continue;
                        double addX = radius * sin;
                        double addZ = radius * cos;
                        Location loc = new Location(null, this.center.getX() + addX, yPos, this.center.getZ() + addZ);
                        Vector vec = loc.toVector().subtract(block.getFBlock().getLocation().toVector());
                        vec.multiply(0.101);
                        block.getFBlock().setVelocity(vec);
                    }
                }
            }
        };
        this.animationRunnable.runTaskTimerAsynchronously((Plugin)this.plugin, 14L, (long)this.tickRate);
    }

    private byte rotateBlockDataLog(byte matData) {
        if (matData >= 4 && matData <= 7) {
            matData = (byte)(matData + 4);
        } else if (matData >= 7 && matData <= 11) {
            matData = (byte)(matData - 4);
        }
        return matData;
    }

    private byte rotateBlockDataEndRod(byte matData) {
        if (matData == 0 || matData == 1) {
            return matData;
        }
        if (this.rotDirection == RotateDirection.CLOCKWISE) {
            switch (matData) {
                case 2: {
                    return 5;
                }
                case 3: {
                    return 4;
                }
                case 4: {
                    return 2;
                }
                case 5: {
                    return 3;
                }
            }
            return matData;
        }
        switch (matData) {
            case 2: {
                return 5;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 2;
            }
        }
        return matData;
    }

    private byte rotateBlockDataAnvil(byte matData) {
        if (this.rotDirection == RotateDirection.CLOCKWISE) {
            if (matData == 0 || matData == 4 || matData == 8) {
                matData = (byte)(matData + 1);
            } else if (matData == 1 || matData == 5 || matData == 9) {
                matData = (byte)(matData + 1);
            } else if (matData == 2 || matData == 6 || matData == 10) {
                matData = (byte)(matData + 1);
            } else if (matData == 3 || matData == 7 || matData == 11) {
                matData = (byte)(matData - 3);
            }
        } else if (matData == 0 || matData == 4 || matData == 8) {
            matData = (byte)(matData + 3);
        } else if (matData == 1 || matData == 5 || matData == 9) {
            matData = (byte)(matData - 1);
        } else if (matData == 2 || matData == 6 || matData == 10) {
            matData = (byte)(matData - 1);
        } else if (matData == 3 || matData == 7 || matData == 11) {
            matData = (byte)(matData - 1);
        }
        return matData;
    }

    private byte rotateBlockDataStairs(byte matData) {
        if (this.rotDirection == RotateDirection.CLOCKWISE) {
            if (matData == 0 || matData == 4) {
                matData = (byte)(matData + 2);
            } else if (matData == 1 || matData == 5) {
                matData = (byte)(matData + 2);
            } else if (matData == 2 || matData == 6) {
                matData = (byte)(matData - 1);
            } else if (matData == 3 || matData == 7) {
                matData = (byte)(matData - 3);
            }
        } else if (matData == 0 || matData == 4) {
            matData = (byte)(matData + 3);
        } else if (matData == 1 || matData == 5) {
            matData = (byte)(matData + 1);
        } else if (matData == 2 || matData == 6) {
            matData = (byte)(matData - 2);
        } else if (matData == 3 || matData == 7) {
            matData = (byte)(matData - 2);
        }
        return matData;
    }

    public static void updateCoords(Door door, DoorDirection currentDirection, RotateDirection rotDirection, int moved, boolean shadow) {
        int xMin = door.getMinimum().getBlockX();
        int yMin = door.getMinimum().getBlockY();
        int zMin = door.getMinimum().getBlockZ();
        int xMax = door.getMaximum().getBlockX();
        int yMax = door.getMaximum().getBlockY();
        int zMax = door.getMaximum().getBlockZ();
        int xLen = xMax - xMin;
        int zLen = zMax - zMin;
        Location newMax = null;
        Location newMin = null;
        switch (currentDirection) {
            case NORTH: {
                if (rotDirection == RotateDirection.CLOCKWISE) {
                    newMin = new Location(door.getWorld(), (double)xMin, (double)yMin, (double)zMax);
                    newMax = new Location(door.getWorld(), (double)(xMin + zLen), (double)yMax, (double)zMax);
                    break;
                }
                newMin = new Location(door.getWorld(), (double)(xMin - zLen), (double)yMin, (double)zMax);
                newMax = new Location(door.getWorld(), (double)xMax, (double)yMax, (double)zMax);
                break;
            }
            case EAST: {
                if (rotDirection == RotateDirection.CLOCKWISE) {
                    newMin = new Location(door.getWorld(), (double)xMin, (double)yMin, (double)zMin);
                    newMax = new Location(door.getWorld(), (double)xMin, (double)yMax, (double)(zMax + xLen));
                    break;
                }
                newMin = new Location(door.getWorld(), (double)xMin, (double)yMin, (double)(zMin - xLen));
                newMax = new Location(door.getWorld(), (double)xMin, (double)yMax, (double)zMin);
                break;
            }
            case SOUTH: {
                if (rotDirection == RotateDirection.CLOCKWISE) {
                    newMin = new Location(door.getWorld(), (double)(xMin - zLen), (double)yMin, (double)zMin);
                    newMax = new Location(door.getWorld(), (double)xMax, (double)yMax, (double)zMin);
                    break;
                }
                newMin = new Location(door.getWorld(), (double)xMin, (double)yMin, (double)zMin);
                newMax = new Location(door.getWorld(), (double)(xMin + zLen), (double)yMax, (double)zMin);
                break;
            }
            case WEST: {
                if (rotDirection == RotateDirection.CLOCKWISE) {
                    newMin = new Location(door.getWorld(), (double)xMax, (double)yMin, (double)(zMin - xLen));
                    newMax = new Location(door.getWorld(), (double)xMax, (double)yMax, (double)zMax);
                    break;
                }
                newMin = new Location(door.getWorld(), (double)xMax, (double)yMin, (double)zMin);
                newMax = new Location(door.getWorld(), (double)xMax, (double)yMax, (double)(zMax + xLen));
            }
        }
        door.setMaximum(newMax);
        door.setMinimum(newMin);
        boolean isOpen = shadow ? door.isOpen() : !door.isOpen();
        BigDoors.get().getCommander().updateDoorCoords(door.getDoorUID(), isOpen, newMin.getBlockX(), newMin.getBlockY(), newMin.getBlockZ(), newMax.getBlockX(), newMax.getBlockY(), newMax.getBlockZ());
    }

    @Override
    public long getDoorUID() {
        return this.door.getDoorUID();
    }

    @Override
    public Door getDoor() {
        return this.door;
    }
}

