/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.moveBlocks;

import java.util.ArrayList;
import nl.pim16aap2.bigDoors.BigDoors;
import nl.pim16aap2.bigDoors.Door;
import nl.pim16aap2.bigDoors.NMS.CustomCraftFallingBlock;
import nl.pim16aap2.bigDoors.NMS.FallingBlockFactory;
import nl.pim16aap2.bigDoors.NMS.NMSBlock;
import nl.pim16aap2.bigDoors.moveBlocks.BlockMover;
import nl.pim16aap2.bigDoors.moveBlocks.Bridge.getNewLocation.GetNewLocation;
import nl.pim16aap2.bigDoors.moveBlocks.Bridge.getNewLocation.GetNewLocationEast;
import nl.pim16aap2.bigDoors.moveBlocks.Bridge.getNewLocation.GetNewLocationNorth;
import nl.pim16aap2.bigDoors.moveBlocks.Bridge.getNewLocation.GetNewLocationSouth;
import nl.pim16aap2.bigDoors.moveBlocks.Bridge.getNewLocation.GetNewLocationWest;
import nl.pim16aap2.bigDoors.util.DoorDirection;
import nl.pim16aap2.bigDoors.util.MyBlockData;
import nl.pim16aap2.bigDoors.util.RotateDirection;
import nl.pim16aap2.bigDoors.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.material.MaterialData;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class BridgeMover
extends BlockMover {
    private final World world;
    private final BigDoors plugin;
    private final int tickRate;
    private final double multiplier;
    private int dx;
    private int dz;
    private final double time;
    private final FallingBlockFactory fabf;
    private final boolean NS;
    private GetNewLocation gnl;
    private final Door door;
    private final RotateDirection upDown;
    private final DoorDirection engineSide;
    private final double endStepSum;
    private Location turningPoint;
    private double startStepSum;
    private final DoorDirection openDirection;
    private Location pointOpposite;
    private int stepMultiplier;
    private final int xMin;
    private final int yMin;
    private final int zMin;
    private final int xMax;
    private final int yMax;
    private final int zMax;
    private int endCount;
    private BukkitRunnable animationRunnable;

    public BridgeMover(BigDoors plugin, World world, double time, Door door, RotateDirection upDown, DoorDirection openDirection, boolean instantOpen, double multiplier) {
        super(plugin, door, instantOpen);
        this.fabf = plugin.getFABF();
        this.engineSide = door.getEngSide();
        this.NS = this.engineSide == DoorDirection.NORTH || this.engineSide == DoorDirection.SOUTH;
        this.door = door;
        this.world = world;
        this.plugin = plugin;
        this.upDown = upDown;
        this.openDirection = openDirection;
        this.xMin = door.getMinimum().getBlockX();
        this.yMin = door.getMinimum().getBlockY();
        this.zMin = door.getMinimum().getBlockZ();
        this.xMax = door.getMaximum().getBlockX();
        this.yMax = door.getMaximum().getBlockY();
        this.zMax = door.getMaximum().getBlockZ();
        int xLen = Math.abs(door.getMaximum().getBlockX() - door.getMinimum().getBlockX());
        int yLen = Math.abs(door.getMaximum().getBlockY() - door.getMinimum().getBlockY());
        int zLen = Math.abs(door.getMaximum().getBlockZ() - door.getMinimum().getBlockZ());
        int doorSize = Math.max(xLen, Math.max(yLen, zLen)) + 1;
        double[] vars = Util.calculateTimeAndTickRate(doorSize, time, multiplier, 5.2);
        this.time = vars[0];
        this.tickRate = (int)vars[1];
        this.multiplier = vars[2];
        this.startStepSum = -1.0;
        this.stepMultiplier = -1;
        switch (this.engineSide) {
            case NORTH: {
                this.turningPoint = new Location(world, (double)this.xMin, (double)this.yMin, (double)this.zMin);
                this.dx = 1;
                this.dz = 1;
                if (upDown.equals((Object)RotateDirection.UP)) {
                    this.pointOpposite = new Location(world, (double)this.xMax, (double)this.yMin, (double)this.zMax);
                    this.startStepSum = 1.5707963267948966;
                    this.stepMultiplier = -1;
                    break;
                }
                this.pointOpposite = new Location(world, (double)this.xMax, (double)this.yMax, (double)this.zMin);
                if (openDirection.equals((Object)DoorDirection.NORTH)) {
                    this.stepMultiplier = -1;
                    break;
                }
                if (!openDirection.equals((Object)DoorDirection.SOUTH)) break;
                this.stepMultiplier = 1;
                break;
            }
            case SOUTH: {
                this.turningPoint = new Location(world, (double)this.xMax, (double)this.yMin, (double)this.zMax);
                this.dx = -1;
                this.dz = -1;
                if (upDown.equals((Object)RotateDirection.UP)) {
                    this.pointOpposite = new Location(world, (double)this.xMin, (double)this.yMin, (double)this.zMin);
                    this.startStepSum = -1.5707963267948966;
                    this.stepMultiplier = 1;
                    break;
                }
                this.pointOpposite = new Location(world, (double)this.xMin, (double)this.yMax, (double)this.zMax);
                if (openDirection.equals((Object)DoorDirection.NORTH)) {
                    this.stepMultiplier = -1;
                    break;
                }
                if (!openDirection.equals((Object)DoorDirection.SOUTH)) break;
                this.stepMultiplier = 1;
                break;
            }
            case EAST: {
                this.turningPoint = new Location(world, (double)this.xMax, (double)this.yMin, (double)this.zMin);
                this.dx = -1;
                this.dz = 1;
                if (upDown.equals((Object)RotateDirection.UP)) {
                    this.pointOpposite = new Location(world, (double)this.xMin, (double)this.yMin, (double)this.zMax);
                    this.startStepSum = -1.5707963267948966;
                    this.stepMultiplier = 1;
                    break;
                }
                this.pointOpposite = new Location(world, (double)this.xMax, (double)this.yMax, (double)this.zMax);
                if (openDirection.equals((Object)DoorDirection.EAST)) {
                    this.stepMultiplier = 1;
                    break;
                }
                if (!openDirection.equals((Object)DoorDirection.WEST)) break;
                this.stepMultiplier = -1;
                break;
            }
            case WEST: {
                this.turningPoint = new Location(world, (double)this.xMin, (double)this.yMin, (double)this.zMax);
                this.dx = 1;
                this.dz = -1;
                if (upDown.equals((Object)RotateDirection.UP)) {
                    this.pointOpposite = new Location(world, (double)this.xMax, (double)this.yMin, (double)this.zMin);
                    this.startStepSum = 1.5707963267948966;
                    this.stepMultiplier = -1;
                    break;
                }
                this.pointOpposite = new Location(world, (double)this.xMin, (double)this.yMax, (double)this.zMin);
                if (openDirection.equals((Object)DoorDirection.EAST)) {
                    this.stepMultiplier = 1;
                    break;
                }
                if (!openDirection.equals((Object)DoorDirection.WEST)) break;
                this.stepMultiplier = -1;
            }
        }
        this.endStepSum = upDown.equals((Object)RotateDirection.UP) ? 0.0 : 1.5707963267948966 * (double)this.stepMultiplier;
        this.startStepSum = upDown.equals((Object)RotateDirection.DOWN) ? 0.0 : this.startStepSum;
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)plugin, this::createAnimatedBlocks, 2L);
    }

    private void createAnimatedBlocks() {
        this.savedBlocks.ensureCapacity(this.door.getBlockCount());
        ArrayList<NMSBlock> edges = new ArrayList<NMSBlock>(Math.min(this.door.getBlockCount(), (this.xMax - this.xMin + 1) * 2 + (this.yMax - this.yMin + 1) * 2 + (this.zMax - this.zMin + 1) * 2));
        int xAxis = this.turningPoint.getBlockX();
        do {
            int zAxis = this.turningPoint.getBlockZ();
            do {
                double radius = 0.0;
                if (this.upDown == RotateDirection.UP) {
                    radius = this.NS ? (double)Math.abs(zAxis - this.turningPoint.getBlockZ()) : (double)Math.abs(xAxis - this.turningPoint.getBlockX());
                }
                for (int yAxis = this.yMin; yAxis <= this.yMax; ++yAxis) {
                    Location startLocation = new Location(this.world, (double)xAxis + 0.5, (double)yAxis, (double)zAxis + 0.5);
                    if (this.upDown == RotateDirection.DOWN) {
                        radius = yAxis - this.turningPoint.getBlockY();
                    }
                    Location newFBlockLocation = new Location(this.world, (double)xAxis + 0.5, (double)yAxis, (double)zAxis + 0.5);
                    Block vBlock = this.world.getBlockAt(xAxis, yAxis, zAxis);
                    Material mat = vBlock.getType();
                    if (!Util.isAllowedBlock(mat)) continue;
                    byte matData = vBlock.getData();
                    BlockState bs = vBlock.getState();
                    MaterialData materialData = bs.getData();
                    NMSBlock block2 = this.fabf.nmsBlockFactory(this.world, xAxis, yAxis, zAxis);
                    NMSBlock block22 = null;
                    int canRotate = 0;
                    byte matByte = matData;
                    canRotate = Util.canRotate(mat);
                    if (canRotate == 1 || canRotate == 2 || canRotate == 3 || canRotate == 6 || canRotate == 7 || canRotate == 8) {
                        if (canRotate == 7) {
                            this.rotateEndRotBlockData(matData);
                        }
                        if (canRotate != 6 && canRotate != 8) {
                            matByte = canRotate == 7 ? this.rotateEndRotBlockData(matData) : this.rotateBlockData(matData);
                        }
                        Block b = this.world.getBlockAt(xAxis, yAxis, zAxis);
                        materialData.setData(matByte);
                        if (BigDoors.isOnFlattenedVersion()) {
                            if (canRotate == 6) {
                                block22 = this.fabf.nmsBlockFactory(this.world, xAxis, yAxis, zAxis);
                                block22.rotateBlockUpDown(this.NS);
                            } else if (canRotate == 8) {
                                block22 = this.fabf.nmsBlockFactory(this.world, xAxis, yAxis, zAxis);
                                block22.rotateVerticallyInDirection(this.openDirection);
                            } else {
                                b.setType(mat);
                                BlockState bs2 = b.getState();
                                bs2.setData(materialData);
                                bs2.update();
                                block22 = this.fabf.nmsBlockFactory(this.world, xAxis, yAxis, zAxis);
                            }
                        }
                    }
                    if (!BigDoors.isOnFlattenedVersion()) {
                        vBlock.setType(Material.AIR);
                    }
                    CustomCraftFallingBlock fBlock = null;
                    if (!this.instantOpen) {
                        fBlock = this.fabf.fallingBlockFactory(newFBlockLocation, block2, matData, mat);
                    }
                    this.savedBlocks.add(new MyBlockData(mat, matByte, fBlock, radius, materialData, block22 == null ? block2 : block22, canRotate, startLocation));
                    if (xAxis != this.xMin && xAxis != this.xMax && yAxis != this.yMin && yAxis != this.yMax && zAxis != this.zMin && zAxis != this.zMax) continue;
                    edges.add(block2);
                }
            } while ((zAxis += this.dz) >= this.pointOpposite.getBlockZ() && this.dz == -1 || zAxis <= this.pointOpposite.getBlockZ() && this.dz == 1);
        } while ((xAxis += this.dx) >= this.pointOpposite.getBlockX() && this.dx == -1 || xAxis <= this.pointOpposite.getBlockX() && this.dx == 1);
        switch (this.openDirection) {
            case NORTH: {
                this.gnl = new GetNewLocationNorth(this.world, this.xMin, this.xMax, this.yMin, this.yMax, this.zMin, this.zMax, this.upDown, this.openDirection);
                break;
            }
            case EAST: {
                this.gnl = new GetNewLocationEast(this.world, this.xMin, this.xMax, this.yMin, this.yMax, this.zMin, this.zMax, this.upDown, this.openDirection);
                break;
            }
            case SOUTH: {
                this.gnl = new GetNewLocationSouth(this.world, this.xMin, this.xMax, this.yMin, this.yMax, this.zMin, this.zMax, this.upDown, this.openDirection);
                break;
            }
            case WEST: {
                this.gnl = new GetNewLocationWest(this.world, this.xMin, this.xMax, this.yMin, this.yMax, this.zMin, this.zMax, this.upDown, this.openDirection);
            }
        }
        if (BigDoors.isOnFlattenedVersion()) {
            this.savedBlocks.forEach(myBlockData -> myBlockData.getBlock().deleteOriginalBlock(false));
            edges.forEach(block -> block.deleteOriginalBlock(true));
        }
        this.savedBlocks.trimToSize();
        if (!this.instantOpen) {
            this.rotateEntities();
        } else {
            this.putBlocks(false);
        }
    }

    @Override
    public synchronized void cancel(boolean onDisable) {
        if (this.animationRunnable == null) {
            return;
        }
        this.animationRunnable.cancel();
        this.putBlocks(onDisable);
    }

    @Override
    public synchronized void putBlocks(boolean onDisable) {
        super.putBlocks(onDisable, this.time, this.endCount, this.gnl::getNewLocation, () -> BridgeMover.updateCoords(this.door, this.openDirection, this.upDown, -1, false));
    }

    private void rotateEntities() {
        this.endCount = (int)((double)(20.0f / (float)this.tickRate) * this.time);
        this.animationRunnable = new BukkitRunnable(){
            final Location center;
            boolean replace;
            double counter;
            final double step;
            double stepSum;
            final int totalTicks;
            final int replaceCount;
            long startTime;
            long lastTime;
            long currentTime;
            {
                this.center = new Location(BridgeMover.this.world, (double)BridgeMover.this.turningPoint.getBlockX() + 0.5, (double)BridgeMover.this.yMin, (double)BridgeMover.this.turningPoint.getBlockZ() + 0.5);
                this.replace = false;
                this.counter = 0.0;
                this.step = 1.5707963267948966 / (double)BridgeMover.this.endCount * (double)BridgeMover.this.stepMultiplier;
                this.stepSum = BridgeMover.this.startStepSum;
                this.totalTicks = (int)((double)BridgeMover.this.endCount * BridgeMover.this.multiplier);
                this.replaceCount = BridgeMover.this.endCount / 2;
                this.startTime = System.nanoTime();
                this.currentTime = System.nanoTime();
            }

            public void run() {
                if (this.counter == 0.0 || this.counter < (double)(BridgeMover.this.endCount - 45 / BridgeMover.this.tickRate) && this.counter % (double)(6 * BridgeMover.this.tickRate / 4) == 0.0) {
                    Util.playSound(BridgeMover.this.door.getEngine(), "bd.drawbridge-rattling", 0.8f, 0.7f);
                }
                this.lastTime = this.currentTime;
                this.currentTime = System.nanoTime();
                long msSinceStart = (this.currentTime - this.startTime) / 1000000L;
                if (!BridgeMover.this.plugin.getCommander().isPaused()) {
                    this.counter = msSinceStart / (long)(50 * BridgeMover.this.tickRate);
                } else {
                    this.startTime += this.currentTime - this.lastTime;
                }
                this.stepSum = this.counter < (double)(BridgeMover.this.endCount - 1) ? BridgeMover.this.startStepSum + this.step * this.counter : BridgeMover.this.endStepSum;
                boolean bl = this.replace = this.counter == (double)this.replaceCount;
                if (!BridgeMover.this.plugin.getCommander().canGo() || this.counter > (double)this.totalTicks) {
                    Util.playSound(BridgeMover.this.door.getEngine(), "bd.thud", 2.0f, 0.15f);
                    for (MyBlockData savedBlock : BridgeMover.this.savedBlocks) {
                        if (savedBlock.getMat().equals((Object)Material.AIR)) continue;
                        savedBlock.getFBlock().setVelocity(new Vector(0.0, 0.0, 0.0));
                    }
                    Bukkit.getScheduler().callSyncMethod((Plugin)BridgeMover.this.plugin, () -> {
                        BridgeMover.this.putBlocks(false);
                        return null;
                    });
                    this.cancel();
                } else {
                    if (this.replace) {
                        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)BridgeMover.this.plugin, () -> {
                            for (MyBlockData block : BridgeMover.this.savedBlocks) {
                                if (block.canRot() == 0 || block.canRot() == 4) continue;
                                Material mat = block.getMat();
                                Location loc = block.getFBlock().getLocation();
                                byte matData = block.getBlockByte();
                                Vector veloc = block.getFBlock().getVelocity();
                                CustomCraftFallingBlock fBlock = BridgeMover.this.fabf.fallingBlockFactory(loc, block.getBlock(), matData, mat);
                                block.getFBlock().remove();
                                block.setFBlock(fBlock);
                                block.getFBlock().setVelocity(veloc);
                            }
                        }, 0L);
                    }
                    for (MyBlockData block : BridgeMover.this.savedBlocks) {
                        double posZ;
                        double posX;
                        double radius;
                        if (block.getMat().equals((Object)Material.AIR) || (radius = block.getRadius()) == 0.0) continue;
                        double posY = this.center.getY() + radius * Math.cos(this.stepSum);
                        if (!BridgeMover.this.NS) {
                            posX = this.center.getX() + radius * Math.sin(this.stepSum);
                            posZ = block.getFBlock().getLocation().getZ();
                        } else {
                            posX = block.getFBlock().getLocation().getX();
                            posZ = this.center.getZ() + radius * Math.sin(this.stepSum);
                        }
                        Location loc = new Location(null, posX, posY, posZ);
                        Vector vec = loc.toVector().subtract(block.getFBlock().getLocation().toVector());
                        vec.multiply(0.101);
                        block.getFBlock().setVelocity(vec);
                    }
                }
            }
        };
        this.animationRunnable.runTaskTimerAsynchronously((Plugin)this.plugin, 14L, (long)this.tickRate);
    }

    private byte rotateBlockData(byte matData) {
        if (!this.NS) {
            if (matData >= 0 && matData < 4) {
                return (byte)(matData + 4);
            }
            if (matData >= 4 && matData < 8) {
                return (byte)(matData - 4);
            }
            return matData;
        }
        if (matData >= 0 && matData < 4) {
            return (byte)(matData + 8);
        }
        if (matData >= 8 && matData < 12) {
            return (byte)(matData - 8);
        }
        return matData;
    }

    private byte rotateEndRotBlockData(byte matData) {
        if (!this.NS) {
            if (matData == 0) {
                return (byte)(this.openDirection.equals((Object)DoorDirection.EAST) ? 4 : 5);
            }
            if (matData == 1) {
                return (byte)(this.openDirection.equals((Object)DoorDirection.EAST) ? 5 : 4);
            }
            if (matData == 4) {
                return (byte)(this.openDirection.equals((Object)DoorDirection.EAST) ? 1 : 0);
            }
            if (matData == 5) {
                return (byte)(!this.openDirection.equals((Object)DoorDirection.EAST) ? 1 : 0);
            }
            return matData;
        }
        if (matData == 0) {
            return (byte)(this.openDirection.equals((Object)DoorDirection.NORTH) ? 3 : 2);
        }
        if (matData == 1) {
            return (byte)(this.openDirection.equals((Object)DoorDirection.NORTH) ? 2 : 3);
        }
        if (matData == 2) {
            return (byte)(!this.openDirection.equals((Object)DoorDirection.NORTH) ? 1 : 0);
        }
        if (matData == 3) {
            return (byte)(this.openDirection.equals((Object)DoorDirection.NORTH) ? 1 : 0);
        }
        return matData;
    }

    public static void updateCoords(Door door, DoorDirection openDirection, RotateDirection upDown, int moved, boolean shadow) {
        int xMin = door.getMinimum().getBlockX();
        int yMin = door.getMinimum().getBlockY();
        int zMin = door.getMinimum().getBlockZ();
        int xMax = door.getMaximum().getBlockX();
        int yMax = door.getMaximum().getBlockY();
        int zMax = door.getMaximum().getBlockZ();
        int xLen = xMax - xMin;
        int yLen = yMax - yMin;
        int zLen = zMax - zMin;
        Location newMax = null;
        Location newMin = null;
        DoorDirection newEngSide = door.getEngSide();
        switch (openDirection) {
            case NORTH: {
                if (upDown == RotateDirection.UP) {
                    newEngSide = DoorDirection.NORTH;
                    newMin = new Location(door.getWorld(), (double)xMin, (double)yMin, (double)zMin);
                    newMax = new Location(door.getWorld(), (double)xMax, (double)(yMin + zLen), (double)zMin);
                    break;
                }
                newEngSide = DoorDirection.SOUTH;
                newMin = new Location(door.getWorld(), (double)xMin, (double)yMin, (double)(zMin - yLen));
                newMax = new Location(door.getWorld(), (double)xMax, (double)yMin, (double)zMin);
                break;
            }
            case EAST: {
                if (upDown == RotateDirection.UP) {
                    newEngSide = DoorDirection.EAST;
                    newMin = new Location(door.getWorld(), (double)xMax, (double)yMin, (double)zMin);
                    newMax = new Location(door.getWorld(), (double)xMax, (double)(yMin + xLen), (double)zMax);
                    break;
                }
                newEngSide = DoorDirection.WEST;
                newMin = new Location(door.getWorld(), (double)xMax, (double)yMin, (double)zMin);
                newMax = new Location(door.getWorld(), (double)(xMax + yLen), (double)yMin, (double)zMax);
                break;
            }
            case SOUTH: {
                if (upDown == RotateDirection.UP) {
                    newEngSide = DoorDirection.SOUTH;
                    newMin = new Location(door.getWorld(), (double)xMin, (double)yMin, (double)zMax);
                    newMax = new Location(door.getWorld(), (double)xMax, (double)(yMin + zLen), (double)zMax);
                    break;
                }
                newEngSide = DoorDirection.NORTH;
                newMin = new Location(door.getWorld(), (double)xMin, (double)yMin, (double)zMax);
                newMax = new Location(door.getWorld(), (double)xMax, (double)yMin, (double)(zMax + yLen));
                break;
            }
            case WEST: {
                if (upDown == RotateDirection.UP) {
                    newEngSide = DoorDirection.WEST;
                    newMin = new Location(door.getWorld(), (double)xMin, (double)yMin, (double)zMin);
                    newMax = new Location(door.getWorld(), (double)xMin, (double)(yMin + xLen), (double)zMax);
                    break;
                }
                newEngSide = DoorDirection.EAST;
                newMin = new Location(door.getWorld(), (double)(xMin - yLen), (double)yMin, (double)zMin);
                newMax = new Location(door.getWorld(), (double)xMin, (double)yMin, (double)zMax);
            }
        }
        door.setMaximum(newMax);
        door.setMinimum(newMin);
        door.setEngineSide(newEngSide);
        boolean isOpen = shadow ? door.isOpen() : !door.isOpen();
        BigDoors.get().getCommander().updateDoorCoords(door.getDoorUID(), isOpen, newMin.getBlockX(), newMin.getBlockY(), newMin.getBlockZ(), newMax.getBlockX(), newMax.getBlockY(), newMax.getBlockZ(), newEngSide);
    }

    @Override
    public long getDoorUID() {
        return this.door.getDoorUID();
    }

    @Override
    public Door getDoor() {
        return this.door;
    }
}

