/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.moveBlocks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import nl.pim16aap2.bigDoors.BigDoors;
import nl.pim16aap2.bigDoors.Door;
import nl.pim16aap2.bigDoors.events.DoorEventAutoToggle;
import nl.pim16aap2.bigDoors.events.DoorEventToggle;
import nl.pim16aap2.bigDoors.events.DoorEventToggleEnd;
import nl.pim16aap2.bigDoors.lib.xseries.XMaterial;
import nl.pim16aap2.bigDoors.util.MyBlockData;
import nl.pim16aap2.bigDoors.util.MyBlockFace;
import nl.pim16aap2.bigDoors.util.Util;
import nl.pim16aap2.bigDoors.util.Vector3D;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.PistonMoveReaction;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.event.Event;
import org.bukkit.material.MaterialData;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class BlockMover {
    private final BigDoors plugin;
    @Nullable
    private final Door door;
    protected final AtomicBoolean blocksPlaced = new AtomicBoolean(false);
    protected final ArrayList<MyBlockData> savedBlocks = new ArrayList();
    private final List<MyBlockData> publicSavedBlocks = Collections.unmodifiableList(this.savedBlocks);
    protected final boolean instantOpen;

    protected BlockMover(BigDoors plugin, @Nullable Door door, boolean instantOpen) {
        this.plugin = plugin;
        this.door = door;
        this.instantOpen = instantOpen;
        if (door == null) {
            return;
        }
        plugin.getAutoCloseScheduler().cancelTimer(door.getDoorUID());
        this.preprocess();
    }

    private void preprocess() {
        if (this.door == null) {
            return;
        }
        Location powerBlockLoc = this.door.getPowerBlockLoc();
        Location min = this.door.getMinimum();
        Location max = this.door.getMaximum();
        if (!Util.isPosInCuboid(powerBlockLoc, min.clone().add(-1.0, -1.0, -1.0), max.clone().add(1.0, 1.0, 1.0))) {
            return;
        }
        for (MyBlockFace blockFace : MyBlockFace.getValues()) {
            Block block;
            Vector3D vec = MyBlockFace.getDirection(blockFace);
            Location newLocation = powerBlockLoc.clone().add((double)vec.getX(), (double)vec.getY(), (double)vec.getZ());
            if (!Util.isPosInCuboid(newLocation, min, max) || (block = newLocation.getBlock()).getPistonMoveReaction() != PistonMoveReaction.BREAK) continue;
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> ((Block)block).breakNaturally(), 1L);
        }
        for (Entity entity : powerBlockLoc.getWorld().getNearbyEntities(powerBlockLoc, 1.1, 1.1, 1.1)) {
            if (!(entity instanceof ItemFrame) || !Util.isPosInCuboid(entity.getLocation(), min, max)) continue;
            ItemFrame itemFrame = (ItemFrame)entity;
            powerBlockLoc.getWorld().dropItemNaturally(itemFrame.getLocation(), itemFrame.getItem());
            powerBlockLoc.getWorld().dropItemNaturally(itemFrame.getLocation(), XMaterial.ITEM_FRAME.parseItem());
            itemFrame.remove();
        }
    }

    public abstract void putBlocks(boolean var1);

    public abstract long getDoorUID();

    public abstract Door getDoor();

    public abstract void cancel(boolean var1);

    public int buttonDelay(int endCount) {
        return Math.max(0, 17 - endCount);
    }

    protected synchronized void putBlocks(boolean onDisable, final double time, int endCount, LocationFinder locationUpdater, Runnable coordinateUpdater) {
        if (this.blocksPlaced.getAndSet(true)) {
            return;
        }
        World world = Objects.requireNonNull(this.door).getWorld();
        for (MyBlockData savedBlock : this.savedBlocks) {
            Block b;
            Material mat = savedBlock.getMat();
            byte matByte = savedBlock.getBlockByte();
            Location newPos = locationUpdater.apply(savedBlock.getRadius(), savedBlock.getStartX(), savedBlock.getStartY(), savedBlock.getStartZ());
            if (!this.instantOpen) {
                savedBlock.getFBlock().remove();
            }
            if (savedBlock.getMat().equals((Object)Material.AIR)) continue;
            if (BigDoors.isOnFlattenedVersion()) {
                savedBlock.getBlock().putBlock(newPos);
                b = world.getBlockAt(newPos);
                BlockState bs = b.getState();
                bs.update();
                continue;
            }
            b = world.getBlockAt(newPos);
            MaterialData matData = savedBlock.getMatData();
            matData.setData(matByte);
            b.setType(mat);
            BlockState bs = b.getState();
            bs.setData(matData);
            bs.update();
        }
        coordinateUpdater.run();
        this.toggleOpen(this.door);
        if (onDisable) {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                BlockMover.this.plugin.getCommander().setDoorAvailable(BlockMover.this.door.getDoorUID());
                DoorEventToggle.ToggleType toggleType = BlockMover.this.door.isOpen() ? DoorEventToggle.ToggleType.OPEN : DoorEventToggle.ToggleType.CLOSE;
                Bukkit.getPluginManager().callEvent((Event)new DoorEventToggleEnd(BlockMover.this.door, toggleType, BlockMover.this.instantOpen));
                if (BlockMover.this.canAutoToggle(BlockMover.this.door)) {
                    BlockMover.this.plugin.getAutoCloseScheduler().scheduleAutoClose(BlockMover.this.door, time, BlockMover.this.instantOpen);
                }
            }
        }.runTaskLater((Plugin)this.plugin, (long)this.getDelay(endCount));
    }

    private int getDelay(int endCount) {
        return this.buttonDelay(endCount) + Math.min(this.plugin.getMinimumDoorDelay(), this.plugin.getConfigLoader().coolDown() * 20);
    }

    private boolean canAutoToggle(Door door) {
        if (!door.isOpen() || door.getAutoClose() <= 0) {
            return false;
        }
        DoorEventAutoToggle preparationEvent = new DoorEventAutoToggle(door);
        Bukkit.getPluginManager().callEvent((Event)preparationEvent);
        return !preparationEvent.isCancelled();
    }

    protected void toggleOpen(Door door) {
        door.setOpenStatus(!door.isOpen());
    }

    public final List<MyBlockData> getSavedBlocks() {
        return this.publicSavedBlocks;
    }

    @FunctionalInterface
    public static interface LocationFinder {
        public Location apply(double var1, double var3, double var5, double var7);
    }
}

