/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.lib.jcalculator;

import java.util.Collections;
import java.util.List;
import java.util.OptionalDouble;

class Variables {
    private final List<String> names;
    private final double[] values;

    public Variables(List<String> names, double[] values) {
        if (names.size() != values.length) {
            throw new IllegalArgumentException(String.format("Size of parameters %d does not match number of values %d!", names.size(), values.length));
        }
        this.names = Collections.unmodifiableList(names);
        this.values = values;
    }

    public OptionalDouble getValue(String name) {
        int idx = this.names.indexOf(name);
        if (idx == -1) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(this.values[idx]);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int idx = 0; idx < this.values.length; ++idx) {
            sb.append("[").append("\"").append(this.names.get(idx)).append("\": ").append(this.values[idx]).append("], ");
        }
        String ret = sb.length() > 2 ? sb.substring(0, sb.length() - 2) : sb.toString();
        return "Variables: {" + ret + "}";
    }
}

