/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.handlers;

import nl.pim16aap2.bigDoors.BigDoors;
import nl.pim16aap2.bigDoors.Door;
import nl.pim16aap2.bigDoors.util.ConfigLoader;
import nl.pim16aap2.bigDoors.util.DoorOpenResult;
import nl.pim16aap2.bigDoors.util.Util;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockRedstoneEvent;

public class RedstoneHandler
implements Listener {
    private final BigDoors plugin;

    public RedstoneHandler(BigDoors plugin) {
        this.plugin = plugin;
    }

    public boolean checkDoor(Location loc) {
        Door door = this.plugin.getCommander().doorFromPowerBlockLoc(loc);
        return door != null && !door.isLocked() && this.plugin.getDoorOpener(door.getType()).openDoor(door, 0.0, false, true) == DoorOpenResult.SUCCESS;
    }

    @EventHandler
    public void onBlockRedstoneChange(BlockRedstoneEvent event) {
        block9: {
            try {
                Block block = event.getBlock();
                Location location = block.getLocation();
                if (event.getOldCurrent() != 0 && event.getNewCurrent() != 0) {
                    return;
                }
                int x = location.getBlockX();
                int y = location.getBlockY();
                int z = location.getBlockZ();
                if (this.plugin.getConfigLoader().getPowerBlockTypes().contains(location.getWorld().getBlockAt(x, y, z - 1).getType())) {
                    this.checkDoor(new Location(location.getWorld(), (double)x, (double)y, (double)(z - 1)));
                }
                if (this.plugin.getConfigLoader().getPowerBlockTypes().contains(location.getWorld().getBlockAt(x + 1, y, z).getType())) {
                    this.checkDoor(new Location(location.getWorld(), (double)(x + 1), (double)y, (double)z));
                }
                if (this.plugin.getConfigLoader().getPowerBlockTypes().contains(location.getWorld().getBlockAt(x, y, z + 1).getType())) {
                    this.checkDoor(new Location(location.getWorld(), (double)x, (double)y, (double)(z + 1)));
                }
                if (this.plugin.getConfigLoader().getPowerBlockTypes().contains(location.getWorld().getBlockAt(x - 1, y, z).getType())) {
                    this.checkDoor(new Location(location.getWorld(), (double)(x - 1), (double)y, (double)z));
                }
                if (this.plugin.getConfigLoader().getPowerBlockTypes().contains(location.getWorld().getBlockAt(x, y + 1, z).getType())) {
                    this.checkDoor(new Location(location.getWorld(), (double)x, (double)(y + 1), (double)z));
                }
                if (this.plugin.getConfigLoader().getPowerBlockTypes().contains(location.getWorld().getBlockAt(x, y - 1, z).getType())) {
                    this.checkDoor(new Location(location.getWorld(), (double)x, (double)(y - 1), (double)z));
                }
            }
            catch (Exception e) {
                this.plugin.getMyLogger().logMessage("Exception thrown while handling redstone event!", true, false);
                this.plugin.getMyLogger().logMessageToLogFile(Util.throwableToString(e));
                BigDoors.get().getConfigLoader();
                if (!ConfigLoader.DEBUG) break block9;
                e.printStackTrace();
            }
        }
    }
}

