/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.handlers;

import nl.pim16aap2.bigDoors.BigDoors;
import nl.pim16aap2.bigDoors.GUI.GUI;
import nl.pim16aap2.bigDoors.util.Messages;
import nl.pim16aap2.bigDoors.util.PageType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class GUIHandler
implements Listener {
    private final Messages messages;
    private final BigDoors plugin;

    public GUIHandler(BigDoors plugin) {
        this.plugin = plugin;
        this.messages = plugin.getMessages();
    }

    public boolean isInBigDoorsInventory(Player player) {
        return player.getOpenInventory() != null && PageType.valueOfName(this.messages.getStringReverse(player.getOpenInventory().getTitle())) != PageType.NOTBIGDOORS;
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        final Player player = (Player)event.getPlayer();
        final GUI gui = this.plugin.getGUIUser(player);
        if (gui != null) {
            new BukkitRunnable(){

                public void run() {
                    if (!GUIHandler.this.isInBigDoorsInventory(player)) {
                        gui.close();
                    }
                }
            }.runTaskLater((Plugin)this.plugin, 1L);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!this.isInBigDoorsInventory(player)) {
            return;
        }
        GUI gui = this.plugin.getGUIUser(player);
        if (gui == null) {
            return;
        }
        event.setCancelled(true);
        gui.handleInput(event.getRawSlot());
    }
}

