/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.handlers;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import nl.pim16aap2.bigDoors.BigDoors;
import nl.pim16aap2.bigDoors.Door;
import nl.pim16aap2.bigDoors.GUI.GUI;
import nl.pim16aap2.bigDoors.lib.xseries.XMaterial;
import nl.pim16aap2.bigDoors.moveBlocks.Opener;
import nl.pim16aap2.bigDoors.toolUsers.DoorCreator;
import nl.pim16aap2.bigDoors.toolUsers.DrawbridgeCreator;
import nl.pim16aap2.bigDoors.toolUsers.PortcullisCreator;
import nl.pim16aap2.bigDoors.toolUsers.PowerBlockInspector;
import nl.pim16aap2.bigDoors.toolUsers.PowerBlockRelocator;
import nl.pim16aap2.bigDoors.toolUsers.SlidingDoorCreator;
import nl.pim16aap2.bigDoors.toolUsers.ToolUser;
import nl.pim16aap2.bigDoors.util.Abortable;
import nl.pim16aap2.bigDoors.util.DoorAttribute;
import nl.pim16aap2.bigDoors.util.DoorOpenResult;
import nl.pim16aap2.bigDoors.util.DoorType;
import nl.pim16aap2.bigDoors.util.RotateDirection;
import nl.pim16aap2.bigDoors.util.Util;
import nl.pim16aap2.bigDoors.waitForCommand.WaitForAddOwner;
import nl.pim16aap2.bigDoors.waitForCommand.WaitForCommand;
import nl.pim16aap2.bigDoors.waitForCommand.WaitForRemoveOwner;
import nl.pim16aap2.bigDoors.waitForCommand.WaitForSetBlocksToMove;
import nl.pim16aap2.bigDoors.waitForCommand.WaitForSetTime;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class CommandHandler
implements CommandExecutor {
    BigDoors plugin;
    private static final String upgradeWarning = "\n===================================================================================\n===================================== WARNING =====================================\n===================================================================================\n||  Are you absolutely sure you want to upgrade the database to v2 of BigDoors?  ||\n||  You will NOT BE ABLE to use this database on the current version anymore!    ||\n||  If you are aware of the consequences, execute the following command:         ||\n||  \"bigdoors upgradedatabaseforv2 confirm\"                                      ||\n===================================================================================\n===================================== WARNING =====================================\n===================================================================================";

    public CommandHandler(BigDoors plugin) {
        this.plugin = plugin;
    }

    public void openDoorCommand(CommandSender sender, Door door, double time, boolean instant) {
        int globalLimit;
        if (sender instanceof Player && !this.plugin.getCommander().hasPermissionForAction((Player)sender, door.getDoorUID(), DoorAttribute.TOGGLE)) {
            return;
        }
        int personalLimit = sender instanceof Player ? Util.getMaxDoorSizeForPlayer((Player)sender) : -1;
        int sizeLimit = Util.minPositive(personalLimit, globalLimit = BigDoors.get().getConfigLoader().maxDoorSize());
        if (sizeLimit > 0 && sizeLimit <= door.getBlockCount()) {
            this.plugin.getMyLogger().returnToSender(sender, Level.INFO, ChatColor.RED, this.plugin.getMessages().getString("GENERAL.TooManyBlocks"));
            return;
        }
        boolean bypass = this.hasBypassAccess(sender instanceof Player ? (Player)sender : null, DoorAttribute.TOGGLE);
        Door newDoor = this.plugin.getCommander().getDoor(sender instanceof Player ? ((Player)sender).getUniqueId() : null, door.getDoorUID(), bypass);
        if (newDoor == null) {
            this.plugin.getMyLogger().returnToSender(sender, Level.INFO, ChatColor.RED, this.plugin.getMessages().getString("GENERAL.ToggleFailure"));
            return;
        }
        if (newDoor.isLocked()) {
            this.plugin.getMyLogger().returnToSender(sender, Level.INFO, ChatColor.RED, this.plugin.getMessages().getString("GENERAL.DoorIsLocked"));
        } else {
            DoorOpenResult result;
            Opener opener = this.plugin.getDoorOpener(newDoor.getType());
            DoorOpenResult doorOpenResult = result = opener == null ? DoorOpenResult.TYPEDISABLED : opener.openDoor(newDoor, time, instant);
            if (result != DoorOpenResult.SUCCESS) {
                this.plugin.getMyLogger().returnToSender(sender, Level.INFO, ChatColor.RED, this.plugin.getMessages().getString(DoorOpenResult.getMessage(result)));
            }
        }
    }

    public void openDoorCommand(Player player, Door door, double time) {
        this.openDoorCommand((CommandSender)player, door, time, false);
    }

    public void openDoorCommand(Player player, Door door) {
        this.openDoorCommand((CommandSender)player, door, 0.0, false);
    }

    public long countDoors(Player player, String doorName) {
        return this.plugin.getCommander().countDoors(player.getUniqueId().toString(), doorName);
    }

    public void listDoors(Player player, String doorName) {
        ArrayList<Door> doors = this.plugin.getCommander().getDoors(player.getUniqueId().toString(), doorName);
        for (Door door : doors) {
            Util.messagePlayer(player, Util.getBasicDoorInfo(door));
        }
        if (doors.size() == 0) {
            Util.messagePlayer(player, this.plugin.getMessages().getString("GENERAL.NoDoorsFound"));
        }
    }

    public void listDoorInfo(Player player, String name) {
        long doorUID = Util.longFromString(name, -1L);
        if (doorUID != -1L) {
            if (this.plugin.getCommander().hasPermissionForAction(player, doorUID, DoorAttribute.INFO)) {
                Util.messagePlayer(player, Util.getFullDoorInfo(this.plugin.getCommander().getDoor(player.getUniqueId(), doorUID)));
            }
        } else {
            ArrayList<Door> doors = this.plugin.getCommander().getDoors(player.getUniqueId().toString(), name);
            for (Door door : doors) {
                if (!this.plugin.getCommander().hasPermissionForAction(player, door.getDoorUID(), DoorAttribute.INFO)) continue;
                Util.messagePlayer(player, Util.getFullDoorInfo(door));
            }
            if (doors.size() == 0) {
                Util.messagePlayer(player, this.plugin.getMessages().getString("GENERAL.NoDoorsFound"));
            }
        }
    }

    public void listDoorInfo(Player player, Door door) {
        if (this.plugin.getCommander().hasPermissionForAction(player, door.getDoorUID(), DoorAttribute.INFO)) {
            Util.messagePlayer(player, Util.getFullDoorInfo(door));
        }
    }

    public void listDoorInfoIgnorePermission(Player player, Door door) {
        Util.messagePlayer(player, Util.getFullDoorInfo(door));
    }

    public void listDoorInfoFromConsole(String str) {
        long doorUID = Util.longFromString(str, -1L);
        if (doorUID == -1L) {
            ArrayList<Door> doors = this.plugin.getCommander().getDoors(null, str);
            for (Door door : doors) {
                this.plugin.getMyLogger().myLogger(Level.INFO, this.plugin.getCommander().playerNameFromUUID(door.getPlayerUUID()) + ": " + Util.getFullDoorInfo(door));
            }
            if (doors.size() == 0) {
                this.plugin.getMyLogger().myLogger(Level.INFO, this.plugin.getMessages().getString("GENERAL.NoDoorsFound"));
            }
            return;
        }
        Door door = this.plugin.getCommander().getDoor(null, doorUID);
        if (door == null) {
            this.plugin.getMyLogger().myLogger(Level.INFO, this.plugin.getMessages().getString("GENERAL.NoDoorsFound"));
            return;
        }
        this.plugin.getMyLogger().myLogger(Level.INFO, Util.nameFromUUID(door.getPlayerUUID()) + ": " + Util.getFullDoorInfo(door));
    }

    private void listPlayerDoors(CommandSender receiver, UUID targetUUID, String targetName) {
        ArrayList<Door> doors = this.plugin.getCommander().getDoors(targetUUID.toString(), null);
        for (Door door : doors) {
            this.plugin.getMyLogger().returnToSender(receiver, Level.WARNING, ChatColor.WHITE, targetName + ": " + Util.getBasicDoorInfo(door));
        }
        if (doors.isEmpty()) {
            this.plugin.getMyLogger().returnToSender(receiver, Level.WARNING, ChatColor.RED, this.plugin.getMessages().getString("GENERAL.NoDoorsFound"));
        }
    }

    private void listDoorsFromConsole(String playerUUID, String name) {
        ArrayList<Door> doors = playerUUID == null && name == null ? new ArrayList<Door>(this.plugin.getCommander().getDoors()) : this.plugin.getCommander().getDoors(playerUUID, name);
        if (doors.size() == 0) {
            this.plugin.getMyLogger().myLogger(Level.INFO, this.plugin.getMessages().getString("GENERAL.NoDoorsFound"));
        }
        doors.sort(Comparator.comparing(Door::getDoorUID));
        StringBuilder sb = new StringBuilder("List of found doors:\n");
        for (Door door : doors) {
            String playerName = door.getPlayerName();
            sb.append(String.format("%17s ", playerName == null ? "" : playerName + ":")).append(Util.getBasicDoorInfo(door)).append("\n");
        }
        this.plugin.getMyLogger().myLogger(Level.INFO, sb.toString());
    }

    public void listDoorsFromConsole(String str) {
        UUID playerUUID = this.plugin.getCommander().playerUUIDFromName(str);
        if (playerUUID != null) {
            this.listDoorsFromConsole(playerUUID.toString(), null);
        } else {
            this.plugin.getMyLogger().info("Player \"" + str + "\" was not found!");
        }
    }

    public boolean isValidDoorName(String name) {
        try {
            Integer.parseInt(name);
            return false;
        }
        catch (NumberFormatException e) {
            return true;
        }
    }

    public void startCreator(Player player, String name, DoorType type) {
        if (!player.hasPermission(DoorType.getPermission(type))) {
            Util.messagePlayer(player, ChatColor.RED, this.plugin.getMessages().getString("GENERAL.NoDoorTypeCreationPermission"));
            return;
        }
        long doorCount = this.plugin.getCommander().countDoors(player.getUniqueId().toString(), null);
        int maxCount = Util.getMaxDoorsForPlayer(player);
        if (maxCount >= 0 && doorCount >= (long)maxCount) {
            Util.messagePlayer(player, ChatColor.RED, this.plugin.getMessages().getString("GENERAL.TooManyDoors"));
            return;
        }
        if (name != null && !this.isValidDoorName(name)) {
            Util.messagePlayer(player, ChatColor.RED, "\"" + name + "\"" + this.plugin.getMessages().getString("GENERAL.InvalidDoorName"));
            return;
        }
        if (this.isPlayerBusy(player)) {
            return;
        }
        ToolUser tu = type == DoorType.DOOR ? new DoorCreator(this.plugin, player, name) : (type == DoorType.DRAWBRIDGE ? new DrawbridgeCreator(this.plugin, player, name) : (type == DoorType.PORTCULLIS ? new PortcullisCreator(this.plugin, player, name) : (type == DoorType.SLIDINGDOOR ? new SlidingDoorCreator(this.plugin, player, name) : null)));
        this.startTimerForAbortable(tu, 2400);
    }

    public void startTimerForAbortable(final Abortable abortable, int time) {
        BukkitTask task = new BukkitRunnable(){

            public void run() {
                abortable.abort(false);
            }
        }.runTaskLater((Plugin)this.plugin, (long)time);
        abortable.setTask(task);
    }

    public void setDoorOpenTime(Player player, long doorUID, int autoClose) {
        if (this.plugin.getCommander().hasPermissionForAction(player, doorUID, DoorAttribute.CHANGETIMER)) {
            this.plugin.getCommander().updateDoorAutoClose(doorUID, autoClose);
        }
    }

    public void setDoorBlocksToMove(Player player, long doorUID, int autoClose) {
        if (this.plugin.getCommander().hasPermissionForAction(player, doorUID, DoorAttribute.BLOCKSTOMOVE)) {
            this.plugin.getCommander().updateDoorBlocksToMove(doorUID, autoClose);
        }
    }

    public void startBlocksToMoveSetter(Player player, long doorUID) {
        if (this.isPlayerBusy(player)) {
            return;
        }
        this.startTimerForAbortable(new WaitForSetBlocksToMove(this.plugin, player, doorUID), this.plugin.getConfigLoader().commandWaiterTimeout() * 20);
    }

    private void replaceWaitForCommand(Player player) {
        WaitForCommand cw = this.plugin.getCommandWaiter(player);
        if (cw != null) {
            cw.setFinished(true);
            this.abortAbortable(cw);
        }
    }

    public void startTimerSetter(Player player, long doorUID) {
        this.replaceWaitForCommand(player);
        this.startTimerForAbortable(new WaitForSetTime(this.plugin, player, doorUID), this.plugin.getConfigLoader().commandWaiterTimeout() * 20);
    }

    public void startAddOwner(Player player, long doorUID) {
        this.replaceWaitForCommand(player);
        this.startTimerForAbortable(new WaitForAddOwner(this.plugin, player, doorUID), this.plugin.getConfigLoader().commandWaiterTimeout() * 20);
    }

    public void startRemoveOwner(Player player, long doorUID) {
        this.replaceWaitForCommand(player);
        this.startTimerForAbortable(new WaitForRemoveOwner(this.plugin, player, doorUID), this.plugin.getConfigLoader().commandWaiterTimeout() * 20);
    }

    private boolean isPlayerBusy(Player player) {
        boolean isBusy;
        boolean bl = isBusy = this.plugin.getToolUser(player) != null || this.plugin.getCommandWaiter(player) != null;
        if (isBusy) {
            Util.messagePlayer(player, this.plugin.getMessages().getString("GENERAL.IsBusy"));
        }
        return isBusy;
    }

    private void abortAbortable(Abortable abortable) {
        if (abortable instanceof ToolUser) {
            ((ToolUser)abortable).setIsDone(true);
        }
        abortable.abort();
    }

    public void startPowerBlockRelocator(Player player, Door door) {
        this.startTimerForAbortable(new PowerBlockRelocator(this.plugin, player, door), this.plugin.getConfigLoader().commandWaiterTimeout() * 20);
    }

    public void killAllBigDoorsEntities() {
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                if (entity.getCustomName() == null || !entity.getCustomName().equals("BigDoorsEntity")) continue;
                entity.remove();
            }
        }
    }

    private void prepareDatabaseForV2(CommandSender sender, Command cmd, String label, String[] args) {
        if (sender instanceof Player) {
            ((Player)sender).sendMessage(ChatColor.RED + "Players cannot execute this command!");
            return;
        }
        if (sender instanceof Entity || sender instanceof BlockCommandSender) {
            return;
        }
        if (args.length == 2 && args[1].equals("confirm")) {
            this.plugin.getCommander().prepareDatabaseForV2();
        } else {
            this.plugin.getMyLogger().logMessageToConsoleOnly(upgradeWarning);
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        Player player;
        Player player2 = player = sender instanceof Player ? (Player)sender : null;
        if (cmd.getName().equalsIgnoreCase("killbigdoorsentities")) {
            this.killAllBigDoorsEntities();
            this.plugin.getMyLogger().returnToSender(sender, Level.INFO, ChatColor.GREEN, "All entities have been removed!");
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("bigdoors")) {
            String firstCommand;
            switch (firstCommand = args.length == 0 ? "" : args[0].toLowerCase()) {
                case "version": {
                    if (player != null && !player.hasPermission("bigdoors.admin.version")) break;
                    this.plugin.getMyLogger().returnToSender(sender, Level.INFO, ChatColor.GREEN, "This server uses version " + this.plugin.getDescription().getVersion() + " of this plugin!");
                    break;
                }
                case "disabletoggle": {
                    if (player != null && !player.hasPermission("bigdoors.admin.disabletoggle")) break;
                    this.plugin.getCommander().setCanGo(false);
                    this.plugin.getCommander().stopMovers(false);
                    if (player != null) {
                        this.plugin.getMyLogger().returnToSender(sender, Level.INFO, ChatColor.GREEN, this.plugin.getMessages().getString("COMMAND.ToggleDisabled"));
                        break;
                    }
                    this.plugin.getMyLogger().info("All door toggles have been stopped! Doors will not be able to toggle until you run '/bigdoors enabletoggle'.");
                    break;
                }
                case "enabletoggle": {
                    if (player != null && !player.hasPermission("bigdoors.admin.disabletoggle")) break;
                    this.plugin.getCommander().setCanGo(true);
                    if (player != null) {
                        this.plugin.getMyLogger().returnToSender(sender, Level.INFO, ChatColor.GREEN, this.plugin.getMessages().getString("COMMAND.ToggleEnabled"));
                        break;
                    }
                    this.plugin.getMyLogger().info("Door toggles have been activated again!");
                    break;
                }
                case "menu": {
                    if (player == null || !player.hasPermission("bigdoors.user.gui")) break;
                    this.plugin.addGUIUser(new GUI(this.plugin, player));
                    break;
                }
                case "reload": 
                case "restart": {
                    if (player != null && !player.hasPermission("bigdoors.admin.restart")) break;
                    this.plugin.restart();
                    this.plugin.getMyLogger().returnToSender(sender, Level.INFO, ChatColor.GREEN, "BigDoors has been restarted!");
                    break;
                }
                case "stop": {
                    if ((player == null || !player.hasPermission("bigdoors.admin.stopdoors")) && player != null) break;
                    this.plugin.getCommander().stopMovers(false);
                    break;
                }
                case "pause": {
                    if ((player == null || !player.hasPermission("bigdoors.admin.pausedoors")) && player != null) break;
                    this.plugin.getCommander().togglePaused();
                    break;
                }
                case "addowner": {
                    if (player == null || !player.hasPermission("bigdoors.user.addowner")) break;
                    if (args.length > 1) {
                        WaitForCommand cw = this.plugin.getCommandWaiter(player);
                        if (cw != null) {
                            return cw.executeCommand(args);
                        }
                        boolean bypass = this.hasBypassAccess(player, DoorAttribute.ADDOWNER);
                        Door door = this.plugin.getCommander().getDoor(args[1], player, bypass);
                        if (door == null) {
                            this.plugin.getMyLogger().returnToSender(sender, Level.INFO, ChatColor.RED, "\"" + args[1] + "\" " + this.plugin.getMessages().getString("GENERAL.InvalidDoorName"));
                            return true;
                        }
                        UUID playerUUID = null;
                        int permission = 1;
                        try {
                            playerUUID = this.plugin.getCommander().playerUUIDFromName(args[2]);
                            if (args.length == 4) {
                                permission = Integer.parseInt(args[3]);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (playerUUID != null) {
                            if (this.plugin.getCommander().addOwner(playerUUID, door, permission)) {
                                this.plugin.getMyLogger().returnToSender(sender, Level.INFO, ChatColor.RED, this.plugin.getMessages().getString("COMMAND.AddOwner.Success"));
                                return true;
                            }
                            this.plugin.getMyLogger().returnToSender(sender, Level.INFO, ChatColor.RED, this.plugin.getMessages().getString("COMMAND.AddOwner.Fail"));
                            return false;
                        }
                        this.plugin.getMyLogger().returnToSender(sender, Level.INFO, ChatColor.RED, this.plugin.getMessages().getString("GENERAL.PlayerNotFound") + ": \"" + args[2] + "\"");
                        return true;
                    }
                    return true;
                }
                case "removeowner": {
                    if (player == null || !player.hasPermission("bigdoors.user.removeowner")) break;
                    if (args.length == 2) {
                        WaitForCommand cw = this.plugin.getCommandWaiter(player);
                        if (cw == null) break;
                        return cw.executeCommand(args);
                    }
                    if (args.length <= 2) break;
                    WaitForCommand cw = this.plugin.getCommandWaiter(player);
                    if (cw != null && cw.getCommand().equals("removeowner")) {
                        cw.abortSilently();
                    }
                    boolean bypass = this.hasBypassAccess(player, DoorAttribute.REMOVEOWNER);
                    Door door = this.plugin.getCommander().getDoor(args[1], player, bypass);
                    if (door == null) {
                        this.plugin.getMyLogger().returnToSender(sender, Level.INFO, ChatColor.RED, "\"" + args[1] + "\" " + this.plugin.getMessages().getString("GENERAL.InvalidDoorName"));
                        return true;
                    }
                    UUID playerUUID = Util.playerUUIDFromString(args[2]);
                    if (playerUUID == null) break;
                    if (this.plugin.getCommander().removeOwner(door, playerUUID, player)) {
                        this.plugin.getMyLogger().returnToSender(sender, Level.INFO, ChatColor.RED, this.plugin.getMessages().getString("COMMAND.RemoveOwner.Success"));
                        return true;
                    }
                    this.plugin.getMyLogger().returnToSender(sender, Level.INFO, ChatColor.RED, this.plugin.getMessages().getString("COMMAND.RemoveOwner.Fail"));
                    return false;
                }
                default: {
                    this.showHelpInfo(sender);
                }
            }
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("stopdoors")) {
            this.plugin.getCommander().stopMovers(false);
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("setnotification")) {
            boolean notify;
            if (player == null) {
                this.plugin.getMyLogger().warn("Only players can use 'togglenotification'!");
                return true;
            }
            if (args.length != 2) {
                return false;
            }
            try {
                notify = Boolean.parseBoolean(args[1]);
            }
            catch (NumberFormatException e) {
                return false;
            }
            Door door = this.plugin.getCommander().getDoor(args[0], player);
            if (door == null) {
                return true;
            }
            if (door.getPermission() != 0) {
                player.sendMessage(this.plugin.getMessages().getString("GENERAL.NotACreator"));
                return true;
            }
            door.setNotificationEnabled(notify);
            this.plugin.getCommander().updateDoorNotify(door.getDoorUID(), notify);
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("doordebug")) {
            this.doorDebug(player, args);
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("setautoclosetime")) {
            if (args.length == 1 && player != null) {
                WaitForCommand cw = this.plugin.getCommandWaiter(player);
                if (cw != null) {
                    return cw.executeCommand(args);
                }
            } else if (args.length == 2) {
                WaitForCommand cw = this.plugin.getCommandWaiter(player);
                if (cw != null && cw.getCommand().equals("setautoclosetime")) {
                    cw.abortSilently();
                }
                boolean bypass = this.hasBypassAccess(player, DoorAttribute.CHANGETIMER);
                Door door = this.plugin.getCommander().getDoor(args[0], player, bypass);
                if (door == null) {
                    return false;
                }
                if (!this.plugin.getCommander().hasPermissionForAction(player, door.getDoorUID(), DoorAttribute.CHANGETIMER)) {
                    return true;
                }
                try {
                    int time = Integer.parseInt(args[1]);
                    this.setDoorOpenTime(player, door.getDoorUID(), time);
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
            return false;
        }
        if (cmd.getName().equalsIgnoreCase("setblockstomove")) {
            if (args.length == 1 && player != null) {
                WaitForCommand cw = this.plugin.getCommandWaiter(player);
                if (cw != null) {
                    return cw.executeCommand(args);
                }
            } else if (args.length == 2) {
                WaitForCommand cw = this.plugin.getCommandWaiter(player);
                if (cw != null && cw.getCommand().equals("setblockstomove")) {
                    cw.abortSilently();
                }
                boolean bypass = this.hasBypassAccess(player, DoorAttribute.BLOCKSTOMOVE);
                Door door = this.plugin.getCommander().getDoor(args[0], player, bypass);
                if (door == null) {
                    return false;
                }
                if (!this.plugin.getCommander().hasPermissionForAction(player, door.getDoorUID(), DoorAttribute.BLOCKSTOMOVE)) {
                    return true;
                }
                try {
                    int blocksToMove = Integer.parseInt(args[1]);
                    if (blocksToMove > BigDoors.get().getConfigLoader().getMaxBlocksToMove()) {
                        this.plugin.getMyLogger().returnToSender(sender, Level.WARNING, ChatColor.RED, BigDoors.get().getMessages().getString("GENERAL.InvalidBlocksToMoveRange"));
                    } else {
                        this.setDoorBlocksToMove(player, door.getDoorUID(), blocksToMove);
                    }
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
            return false;
        }
        if (cmd.getName().equalsIgnoreCase("setdoorrotation")) {
            if (args.length != 2) {
                return false;
            }
            boolean bypass = this.hasBypassAccess(player, DoorAttribute.DIRECTION_ROTATE);
            Door door = this.plugin.getCommander().getDoor(args[0], player, bypass);
            if (door == null) {
                return false;
            }
            if (!this.plugin.getCommander().hasPermissionForAction(player, door.getDoorUID(), DoorAttribute.DIRECTION_ROTATE)) {
                return true;
            }
            RotateDirection openDir = null;
            if (door.getType() == DoorType.SLIDINGDOOR) {
                if (args[1].equalsIgnoreCase("NORTH")) {
                    openDir = RotateDirection.NORTH;
                } else if (args[1].equalsIgnoreCase("EAST")) {
                    openDir = RotateDirection.NORTH;
                } else if (args[1].equalsIgnoreCase("SOUTH")) {
                    openDir = RotateDirection.NORTH;
                } else if (args[1].equalsIgnoreCase("WEST")) {
                    openDir = RotateDirection.NORTH;
                }
            } else if (args[1].equalsIgnoreCase("CLOCK") || args[1].equalsIgnoreCase("CLOCKWISE")) {
                openDir = RotateDirection.CLOCKWISE;
            } else if (args[1].equalsIgnoreCase("COUNTER") || args[1].equalsIgnoreCase("COUNTERCLOCKWISE")) {
                openDir = RotateDirection.COUNTERCLOCKWISE;
            }
            if (openDir == null) {
                return false;
            }
            this.plugin.getCommander().updateDoorOpenDirection(door.getDoorUID(), openDir);
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("filldoor")) {
            if (args.length != 1) {
                return false;
            }
            Door door = this.plugin.getCommander().getDoor(args[0], player);
            if (door == null) {
                return false;
            }
            for (int i = door.getMinimum().getBlockX(); i <= door.getMaximum().getBlockX(); ++i) {
                for (int j = door.getMinimum().getBlockY(); j <= door.getMaximum().getBlockY(); ++j) {
                    for (int k = door.getMinimum().getBlockZ(); k <= door.getMaximum().getBlockZ(); ++k) {
                        door.getWorld().getBlockAt(i, j, k).setType(XMaterial.STONE.parseMaterial());
                    }
                }
            }
            door.getPowerBlockLoc().getBlock().setType(this.plugin.getConfigLoader().getPowerBlockTypes().iterator().next());
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("recalculatepowerblocks")) {
            this.plugin.getCommander().recalculatePowerBlockHashes();
            this.plugin.getMyLogger().returnToSender(sender, Level.INFO, ChatColor.GREEN, "power block hashes have been regenerated!");
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("pausedoors")) {
            this.plugin.getCommander().togglePaused();
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("opendoor") || cmd.getName().equalsIgnoreCase("closedoor") || cmd.getName().equalsIgnoreCase("toggledoor")) {
            int type;
            boolean instantly = false;
            int n = cmd.getName().equalsIgnoreCase("opendoor") ? 0 : (type = cmd.getName().equalsIgnoreCase("closedoor") ? 1 : 2);
            if (args.length >= 1) {
                String lastStr = args[args.length - 1];
                double time = Util.longFromString(lastStr, -1L) == -1L ? Util.doubleFromString(lastStr, 0.0) : 0.0;
                int endIDX = args.length;
                if (time != 0.0) {
                    --endIDX;
                    if (time < 0.0) {
                        instantly = true;
                    }
                }
                boolean bypass = this.hasBypassAccess(player, DoorAttribute.TOGGLE);
                for (int index = 0; index < endIDX; ++index) {
                    Door door = this.plugin.getCommander().getDoor(args[index], player, bypass);
                    if (door == null) {
                        this.plugin.getMyLogger().returnToSender(sender, Level.INFO, ChatColor.RED, "\"" + args[index] + "\" " + this.plugin.getMessages().getString("GENERAL.InvalidDoorName"));
                        if (player != null) continue;
                        this.plugin.getMyLogger().returnToSender(sender, Level.INFO, ChatColor.RED, "Don't forget that you should use the DoorUID in the console/command blocks! DoorName won't work here!");
                        continue;
                    }
                    if (type == 2 || door.getOpenDir().equals((Object)RotateDirection.NONE)) {
                        this.openDoorCommand(sender, door, time, instantly);
                        continue;
                    }
                    if (type == 1) {
                        if (door.isOpen()) {
                            this.openDoorCommand(sender, door, time, instantly);
                            continue;
                        }
                        this.plugin.getMyLogger().returnToSender(sender, Level.INFO, ChatColor.RED, this.plugin.getMessages().getString("GENERAL.Door") + " " + door.toSimpleString() + " " + this.plugin.getMessages().getString("GENERAL.DoorAlreadyClosed"));
                        continue;
                    }
                    if (type != 0) continue;
                    if (!door.isOpen()) {
                        this.openDoorCommand(sender, door, time, instantly);
                        continue;
                    }
                    this.plugin.getMyLogger().returnToSender(sender, Level.INFO, ChatColor.RED, this.plugin.getMessages().getString("GENERAL.Door") + " " + door.toSimpleString() + " " + this.plugin.getMessages().getString("GENERAL.DoorAlreadyOpen"));
                }
                return true;
            }
        } else {
            if (cmd.getName().equalsIgnoreCase("listplayerdoors")) {
                if (args.length == 0) {
                    return false;
                }
                UUID uuid = null;
                String name = null;
                Optional<UUID> uuidOpt = Util.parseUUID(args[0]);
                if (uuidOpt.isPresent()) {
                    uuid = uuidOpt.get();
                    name = this.plugin.getCommander().playerNameFromUUID(uuid);
                } else {
                    name = args[0];
                    uuid = this.plugin.getCommander().playerUUIDFromName(name);
                }
                if (name == null || uuid == null) {
                    this.plugin.getMyLogger().returnToSender(sender, Level.WARNING, ChatColor.RED, "Failed to find player: \"" + args[0] + "\"");
                    return true;
                }
                this.listPlayerDoors(sender, uuid, name);
                return true;
            }
            if (cmd.getName().equalsIgnoreCase("listdoors")) {
                if (player != null) {
                    if (args.length == 0) {
                        this.listDoors(player, null);
                    } else if (args.length == 1) {
                        this.listDoors(player, args[0]);
                    }
                } else if (args.length == 0) {
                    this.listDoorsFromConsole(null, null);
                } else if (args.length == 1) {
                    this.listDoorsFromConsole(args[0]);
                }
                return true;
            }
            if (cmd.getName().equalsIgnoreCase("doorinfo")) {
                if (args.length == 1) {
                    if (player != null) {
                        this.listDoorInfo(player, args[0]);
                    } else {
                        this.listDoorInfoFromConsole(args[0]);
                    }
                    return true;
                }
            } else if (player != null) {
                ToolUser tu;
                if (cmd.getName().equalsIgnoreCase("inspectpowerblockloc")) {
                    if (this.isPlayerBusy(player)) {
                        return false;
                    }
                    this.startTimerForAbortable(new PowerBlockInspector(this.plugin, player, -1L), this.plugin.getConfigLoader().commandWaiterTimeout() * 20);
                    return true;
                }
                if (cmd.getName().equalsIgnoreCase("bdm") || cmd.getName().equalsIgnoreCase("doors")) {
                    this.plugin.addGUIUser(new GUI(this.plugin, player));
                    return true;
                }
                if (cmd.getName().equalsIgnoreCase("namedoor")) {
                    tu = this.plugin.getToolUser(player);
                    if (tu != null) {
                        if (args.length == 1 && this.isValidDoorName(args[0])) {
                            tu.setName(args[0]);
                            return true;
                        }
                    } else {
                        Util.messagePlayer(player, this.plugin.getMessages().getString("GENERAL.NotBusy"));
                    }
                }
                if (cmd.getName().equalsIgnoreCase("changePowerBlockLoc")) {
                    if (args.length < 1) {
                        return false;
                    }
                    boolean bypass = this.hasBypassAccess(player, DoorAttribute.RELOCATEPOWERBLOCK);
                    Door door = this.plugin.getCommander().getDoor(args[0], player, bypass);
                    if (door == null) {
                        Util.messagePlayer(player, ChatColor.RED, "No door found by that name!");
                        return true;
                    }
                    if (this.plugin.getCommander().hasPermissionForAction(player, door.getDoorUID(), DoorAttribute.RELOCATEPOWERBLOCK)) {
                        this.startPowerBlockRelocator(player, door);
                    }
                    return true;
                }
                if (cmd.getName().equalsIgnoreCase("bdcancel")) {
                    tu = this.plugin.getToolUser(player);
                    if (tu != null) {
                        this.abortAbortable(tu);
                        this.plugin.getMyLogger().returnToSender((CommandSender)player, Level.INFO, ChatColor.RED, this.plugin.getMessages().getString("CREATOR.GENERAL.Cancelled"));
                    } else {
                        WaitForCommand cw = this.plugin.getCommandWaiter(player);
                        if (cw != null) {
                            this.abortAbortable(cw);
                        }
                    }
                    return true;
                }
                if (cmd.getName().equalsIgnoreCase("deldoor") && args.length == 1) {
                    this.delDoor(player, args[0]);
                    return true;
                }
                if (cmd.getName().equalsIgnoreCase("newdoor") && args.length >= 1) {
                    String name;
                    DoorType type = DoorType.DOOR;
                    if (args.length == 2) {
                        type = DoorType.valueOfFlag(args[0].toUpperCase());
                        if (type == null) {
                            return false;
                        }
                        name = args[1];
                    } else {
                        name = args[0];
                    }
                    this.startCreator(player, name, type);
                    return true;
                }
                if (cmd.getName().equalsIgnoreCase("newportcullis") && args.length == 1) {
                    this.startCreator(player, args[0], DoorType.PORTCULLIS);
                    return true;
                }
                if (cmd.getName().equalsIgnoreCase("newslidingdoor") && args.length == 1) {
                    this.startCreator(player, args[0], DoorType.SLIDINGDOOR);
                    return true;
                }
                if (cmd.getName().equalsIgnoreCase("newdrawbridge") && args.length == 1) {
                    this.startCreator(player, args[0], DoorType.DRAWBRIDGE);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean hasBypassAccess(Player player, DoorAttribute doorAttribute) {
        return player != null && (player.isOp() || DoorAttribute.getAdminPermission(doorAttribute) != null && player.hasPermission(DoorAttribute.getAdminPermission(doorAttribute)));
    }

    public void delDoor(Player player, String doorName) {
        long doorUID = -1L;
        try {
            doorUID = Long.parseLong(doorName);
        }
        catch (NumberFormatException e) {
            long doorCount = this.countDoors(player, doorName);
            if (doorCount == 0L) {
                Util.messagePlayer(player, ChatColor.RED, "No door found by that name!");
                return;
            }
            if (doorCount == 1L) {
                boolean bypass = this.hasBypassAccess(player, DoorAttribute.DELETE);
                doorUID = this.plugin.getCommander().getDoor(doorName, player, bypass).getDoorUID();
            }
            Util.messagePlayer(player, ChatColor.RED, "More than one door found with that name! Please use their ID instead:");
            this.listDoors(player, doorName);
            return;
        }
        if (this.plugin.getCommander().removeDoor(player, doorUID)) {
            Util.messagePlayer(player, ChatColor.GREEN, "Door deleted!");
        }
    }

    public void doorDebug(Player player, String[] args) {
    }

    private String helpFormat(String command, String explanation) {
        String help = "";
        help = help + String.format(ChatColor.GREEN + "%s " + ChatColor.BLUE + "%s\n", command, explanation);
        return help;
    }

    private void showHelpInfo(CommandSender sender) {
        Player player = sender instanceof Player ? (Player)sender : null;
        String help = player == null ? "\n" : "";
        String commandPrefix = player == null ? "" : "/";
        help = help + ChatColor.GREEN + "====[ BigDoors Help ]====\n";
        help = help + this.helpFormat(commandPrefix + "BigDoors menu", "Opens BigDoors' GUI.");
        help = help + this.helpFormat(commandPrefix + "BigDoors version", "Get the version of this plugin.");
        help = help + this.helpFormat(commandPrefix + "BigDoors removeowner <door> <player>", "Add another owner for a door.");
        help = help + this.helpFormat(commandPrefix + "BigDoors addowner <door> <player> [permission]", "Add another owner for a door.");
        if (player == null || player.hasPermission("bigdoors.admin.restart")) {
            help = help + this.helpFormat("BigDoors restart", "Restart the plugin. Reinitializes almost everything.");
        }
        if (player == null || player.hasPermission("bigdoors.admin.stopdoors")) {
            help = help + this.helpFormat("BigDoors stop", "Forces all doors to finish instantly.");
        }
        if (player == null || player.hasPermission("bigdoors.admin.pausedoors")) {
            help = help + this.helpFormat("BigDoors pause", "Pauses all door movement until the command is run again.");
        }
        if (player == null || player.hasPermission("bigdoors.admin.disabletoggle")) {
            help = help + this.helpFormat("BigDoors disabletoggle", "Stops all active doors and prevents any doors from being toggled until this is enabled again.");
            help = help + this.helpFormat("BigDoors enabletoggle", "Enables doors being toggled again. Has no effect if they are not currently disabled.");
        }
        if (player == null) {
            help = help + this.helpFormat("BigDoors upgradedatabaseforv2", "Prepares the database for v2 of BigDoors.");
        }
        if (player == null) {
            help = ChatColor.stripColor((String)help);
        }
        this.plugin.getMyLogger().returnToSender(sender, Level.INFO, ChatColor.RED, help);
    }
}

