/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.compatibility;

import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.utils.PlayerCacheUtil;
import nl.pim16aap2.bigDoors.compatibility.HookContext;
import nl.pim16aap2.bigDoors.compatibility.IProtectionCompat;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public class TownyProtectionCompat
implements IProtectionCompat {
    private final boolean success;
    private final HookContext hookContext;

    public TownyProtectionCompat(HookContext hookContext) {
        this.hookContext = hookContext;
        TownyAPI townyAPI = TownyAPI.getInstance();
        this.success = townyAPI != null;
    }

    @Override
    public boolean canBreakBlock(Player player, Location loc) {
        return PlayerCacheUtil.getCachePermission((Player)player, (Location)loc, (Material)loc.getBlock().getType(), (TownyPermission.ActionType)TownyPermission.ActionType.DESTROY);
    }

    @Override
    public boolean canBreakBlocksBetweenLocs(Player player, Location loc1, Location loc2) {
        int x1 = Math.min(loc1.getBlockX(), loc2.getBlockX());
        int y1 = Math.min(loc1.getBlockY(), loc2.getBlockY());
        int z1 = Math.min(loc1.getBlockZ(), loc2.getBlockZ());
        int x2 = Math.max(loc1.getBlockX(), loc2.getBlockX());
        int y2 = Math.max(loc1.getBlockY(), loc2.getBlockY());
        int z2 = Math.max(loc1.getBlockZ(), loc2.getBlockZ());
        for (int xPos = x1; xPos <= x2; ++xPos) {
            for (int yPos = y1; yPos <= y2; ++yPos) {
                for (int zPos = z1; zPos <= z2; ++zPos) {
                    if (this.canBreakBlock(player, new Location(loc1.getWorld(), (double)xPos, (double)yPos, (double)zPos))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean success() {
        return this.success;
    }

    @Override
    public String getName() {
        return this.hookContext.getProtectionCompatDefinition().getName();
    }
}

