/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.compatibility;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import javax.annotation.Nullable;
import nl.pim16aap2.bigDoors.BigDoors;
import nl.pim16aap2.bigDoors.compatibility.FakePlayerCreator;
import nl.pim16aap2.bigDoors.compatibility.HookContext;
import nl.pim16aap2.bigDoors.compatibility.IProtectionCompat;
import nl.pim16aap2.bigDoors.compatibility.IProtectionCompatDefinition;
import nl.pim16aap2.bigDoors.compatibility.ProtectionCompatDefinition;
import nl.pim16aap2.bigDoors.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;

public class ProtectionCompatManager
implements Listener {
    private static final String BYPASS_PERMISSION = "bigdoors.admin.bypasscompat";
    private final Map<String, IProtectionCompatDefinition> registeredDefinitions;
    private final ArrayList<IProtectionCompat> protectionCompats;
    private final FakePlayerCreator fakePlayerCreator;
    private final BigDoors plugin;

    public ProtectionCompatManager(BigDoors plugin) {
        this.plugin = plugin;
        this.registeredDefinitions = this.registerDefaultProtectionCompatDefinitions();
        this.fakePlayerCreator = plugin.getFakePlayerCreator();
        this.protectionCompats = new ArrayList();
        this.restart();
    }

    public void restart() {
        this.protectionCompats.clear();
        for (Plugin p : this.plugin.getServer().getPluginManager().getPlugins()) {
            this.loadFromPluginName(p.getName());
        }
    }

    private boolean canByPass(Player player) {
        if (player.isOp()) {
            return true;
        }
        if (!player.hasMetadata("isBigDoorsFakePlayer")) {
            return player.hasPermission(BYPASS_PERMISSION);
        }
        return this.offlinePlayerHasPermission((OfflinePlayer)player, player.getWorld().getName());
    }

    private boolean offlinePlayerHasPermission(OfflinePlayer oPlayer, String world) {
        try {
            CompletableFuture<Boolean> future = CompletableFuture.supplyAsync(() -> this.plugin.getVaultManager().hasPermission(oPlayer, BYPASS_PERMISSION, world));
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Nullable
    private Player getPlayer(UUID playerUUID, String playerName, World world) {
        Player player = Bukkit.getPlayer((UUID)playerUUID);
        if (player == null) {
            player = this.fakePlayerCreator.getFakePlayer(Bukkit.getOfflinePlayer((UUID)playerUUID), playerName, world);
        }
        return player;
    }

    public String canBreakBlock(UUID playerUUID, String playerName, Location loc) {
        if (this.protectionCompats.isEmpty()) {
            return null;
        }
        Player fakePlayer = this.getPlayer(playerUUID, playerName, loc.getWorld());
        if (fakePlayer == null) {
            return "InvalidFakePlayer";
        }
        if (this.canByPass(fakePlayer)) {
            return null;
        }
        for (IProtectionCompat compat : this.protectionCompats) {
            try {
                if (compat.canBreakBlock(fakePlayer, loc)) continue;
                return compat.getName();
            }
            catch (Exception e) {
                this.plugin.getMyLogger().warn("Failed to use \"" + compat.getName() + "\"! Please send this error to pim16aap2:");
                e.printStackTrace();
                this.plugin.getMyLogger().logMessageToLogFile(compat.getName() + "\n" + Util.throwableToString(e));
            }
        }
        return null;
    }

    public String canBreakBlocksBetweenLocs(UUID playerUUID, String playerName, World world, Location loc1, Location loc2) {
        if (this.protectionCompats.isEmpty()) {
            return null;
        }
        Player fakePlayer = this.getPlayer(playerUUID, playerName, world);
        if (fakePlayer == null) {
            return "InvalidFakePlayer";
        }
        if (this.canByPass(fakePlayer)) {
            return null;
        }
        if (this.protectionCompats.isEmpty()) {
            return null;
        }
        loc1 = loc1.clone();
        loc2 = loc2.clone();
        loc1.setWorld(world);
        loc2.setWorld(world);
        for (IProtectionCompat compat : this.protectionCompats) {
            try {
                if (compat.canBreakBlocksBetweenLocs(fakePlayer, loc1, loc2)) continue;
                return compat.getName();
            }
            catch (Exception e) {
                this.plugin.getMyLogger().warn("Failed to use \"" + compat.getName() + "\"! Please send this error to pim16aap2:");
                e.printStackTrace();
                this.plugin.getMyLogger().logMessageToLogFile(Util.throwableToString(e));
            }
        }
        return null;
    }

    private boolean protectionAlreadyLoaded(Class<? extends IProtectionCompat> compatClass) {
        for (IProtectionCompat compat : this.protectionCompats) {
            if (!compat.getClass().equals(compatClass)) continue;
            return true;
        }
        return false;
    }

    private void addProtectionCompat(IProtectionCompat hook) {
        if (hook.success()) {
            this.protectionCompats.add(hook);
            this.plugin.getMyLogger().logMessage(Level.INFO, "Successfully hooked into \"" + hook.getName() + "\"!");
        } else {
            this.plugin.getMyLogger().logMessage(Level.INFO, "Failed to hook into \"" + hook.getName() + "\"!");
        }
    }

    @EventHandler
    protected void onPluginEnable(PluginEnableEvent event) {
        this.loadFromPluginName(event.getPlugin().getName());
    }

    private void loadFromPluginName(String compatName) {
        IProtectionCompatDefinition compatDefinition = this.registeredDefinitions.get(compatName);
        if (compatDefinition == null) {
            return;
        }
        if (!this.plugin.getConfigLoader().isHookEnabled(compatDefinition)) {
            return;
        }
        String version = null;
        try {
            version = this.plugin.getServer().getPluginManager().getPlugin(compatDefinition.getName()).getDescription().getVersion();
            Class<? extends IProtectionCompat> compatClass = Objects.requireNonNull(compatDefinition.getClass(version), "Compat class cannot be null!");
            if (this.protectionAlreadyLoaded(compatClass)) {
                return;
            }
            HookContext hookContext = new HookContext(this.plugin, compatDefinition, this.plugin.getVaultManager());
            this.addProtectionCompat(compatClass.getConstructor(HookContext.class).newInstance(hookContext));
        }
        catch (Exception | NoClassDefFoundError e) {
            this.plugin.getMyLogger().logMessageToConsole("Failed to initialize the \"" + compatName + "\" (version \"" + version + "\") compatibility hook!");
            this.plugin.getMyLogger().logMessageToConsole("Now resuming normal startup with the \"" + compatName + "\" Compatibility Hook disabled!");
            this.plugin.getMyLogger().logMessage(Util.throwableToString(e), true, true);
        }
    }

    private Map<String, IProtectionCompatDefinition> registerDefaultProtectionCompatDefinitions() {
        HashMap<String, IProtectionCompatDefinition> ret = new HashMap<String, IProtectionCompatDefinition>(ProtectionCompatDefinition.DEFAULT_COMPAT_DEFINITIONS.size());
        for (IProtectionCompatDefinition compatDefinition : ProtectionCompatDefinition.DEFAULT_COMPAT_DEFINITIONS) {
            ret.put(compatDefinition.getName(), compatDefinition);
        }
        return ret;
    }

    public void registerProtectionCompatDefinition(IProtectionCompatDefinition compatDefinition) {
        this.registeredDefinitions.put(compatDefinition.getName(), compatDefinition);
    }
}

