/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.compatibility;

import com.github.intellectualsites.plotsquared.bukkit.BukkitMain;
import com.github.intellectualsites.plotsquared.bukkit.util.BukkitUtil;
import com.github.intellectualsites.plotsquared.plot.config.Captions;
import com.github.intellectualsites.plotsquared.plot.config.Settings;
import com.github.intellectualsites.plotsquared.plot.flag.Flag;
import com.github.intellectualsites.plotsquared.plot.flag.Flags;
import com.github.intellectualsites.plotsquared.plot.object.Location;
import com.github.intellectualsites.plotsquared.plot.object.Plot;
import com.github.intellectualsites.plotsquared.plot.object.PlotArea;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import java.util.Optional;
import java.util.Set;
import nl.pim16aap2.bigDoors.compatibility.HookContext;
import nl.pim16aap2.bigDoors.compatibility.IProtectionCompat;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class PlotSquared4ProtectionCompat
implements IProtectionCompat {
    private final HookContext hookContext;
    private final JavaPlugin plotSquaredPlugin;
    private final boolean success;

    public PlotSquared4ProtectionCompat(HookContext hookContext) {
        this.hookContext = hookContext;
        this.plotSquaredPlugin = JavaPlugin.getPlugin(BukkitMain.class);
        this.success = this.plotSquaredPlugin != null;
    }

    @Override
    public boolean canBreakBlock(Player player, org.bukkit.Location loc) {
        Location psLocation = BukkitUtil.getLocation((org.bukkit.Location)loc);
        PlotArea area = psLocation.getPlotArea();
        if (area == null) {
            return true;
        }
        return this.canBreakBlock(player, area, area.getPlot(psLocation), loc);
    }

    private boolean isHeightAllowed(Player player, PlotArea area, int height) {
        if (height == 0) {
            return this.hookContext.getPermissionsManager().hasPermission(player, Captions.PERMISSION_ADMIN_DESTROY_GROUNDLEVEL.getTranslated());
        }
        return height <= area.MAX_BUILD_HEIGHT && height >= area.MIN_BUILD_HEIGHT || this.hookContext.getPermissionsManager().hasPermission(player, Captions.PERMISSION_ADMIN_BUILD_HEIGHT_LIMIT.getTranslated());
    }

    private boolean canBreakBlock(Player player, PlotArea area, Plot plot, org.bukkit.Location loc) {
        if (plot != null) {
            if (!this.isHeightAllowed(player, area, loc.getBlockY())) {
                return false;
            }
            if (!plot.hasOwner()) {
                return this.hookContext.getPermissionsManager().hasPermission(player, Captions.PERMISSION_ADMIN_DESTROY_UNOWNED.getTranslated());
            }
            if (!plot.isAdded(player.getUniqueId())) {
                Optional destroy = plot.getFlag((Flag)Flags.BREAK);
                Block block = loc.getBlock();
                if (destroy.isPresent() && ((Set)destroy.get()).contains(BukkitAdapter.asBlockType((Material)block.getType()))) {
                    return true;
                }
                return this.hookContext.getPermissionsManager().hasPermission(player, Captions.PERMISSION_ADMIN_DESTROY_OTHER.getTranslated());
            }
            if (Settings.Done.RESTRICT_BUILDING && plot.getFlags().containsKey(Flags.DONE)) {
                return this.hookContext.getPermissionsManager().hasPermission(player, Captions.PERMISSION_ADMIN_BUILD_OTHER.getTranslated());
            }
            return true;
        }
        return this.canBreakRoads(player);
    }

    private boolean canBreakRoads(Player player) {
        return this.hookContext.getPermissionsManager().hasPermission(player, Captions.PERMISSION_ADMIN_DESTROY_ROAD.getTranslated());
    }

    @Override
    public boolean canBreakBlocksBetweenLocs(Player player, org.bukkit.Location loc1, org.bukkit.Location loc2) {
        int x1 = Math.min(loc1.getBlockX(), loc2.getBlockX());
        int y1 = Math.min(loc1.getBlockY(), loc2.getBlockY());
        int z1 = Math.min(loc1.getBlockZ(), loc2.getBlockZ());
        int x2 = Math.max(loc1.getBlockX(), loc2.getBlockX());
        int y2 = Math.max(loc1.getBlockY(), loc2.getBlockY());
        int z2 = Math.max(loc1.getBlockZ(), loc2.getBlockZ());
        boolean canBreakRoads = this.canBreakRoads(player);
        for (int xPos = x1; xPos <= x2; ++xPos) {
            for (int zPos = z1; zPos <= z2; ++zPos) {
                org.bukkit.Location loc = new org.bukkit.Location(loc1.getWorld(), (double)xPos, (double)y1, (double)zPos);
                Location psLocation = BukkitUtil.getLocation((org.bukkit.Location)loc);
                PlotArea area = psLocation.getPlotArea();
                if (area == null) continue;
                if (!this.isHeightAllowed(player, area, y1) || !this.isHeightAllowed(player, area, y2)) {
                    return false;
                }
                loc.setY((double)(area.MAX_BUILD_HEIGHT - 1));
                Plot newPlot = area.getPlot(psLocation);
                if (newPlot == null && !canBreakRoads) {
                    return false;
                }
                if (this.canBreakBlock(player, area, newPlot, loc)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean success() {
        return this.success;
    }

    @Override
    public String getName() {
        return this.plotSquaredPlugin.getName();
    }
}

