/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.compatibility;

import com.intellectualcrafters.plot.api.PlotAPI;
import com.intellectualcrafters.plot.config.C;
import com.intellectualcrafters.plot.config.Settings;
import com.intellectualcrafters.plot.flag.Flags;
import com.intellectualcrafters.plot.object.Plot;
import com.intellectualcrafters.plot.object.PlotArea;
import com.plotsquared.bukkit.BukkitMain;
import com.plotsquared.bukkit.util.BukkitUtil;
import nl.pim16aap2.bigDoors.compatibility.HookContext;
import nl.pim16aap2.bigDoors.compatibility.IProtectionCompat;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class PlotSquared3ProtectionCompat
implements IProtectionCompat {
    private final PlotAPI plotSquared;
    private final JavaPlugin plotSquaredPlugin;
    private final HookContext hookContext;
    private final boolean success;

    public PlotSquared3ProtectionCompat(HookContext hookContext) {
        this.hookContext = hookContext;
        this.plotSquared = new PlotAPI();
        this.plotSquaredPlugin = JavaPlugin.getPlugin(BukkitMain.class);
        this.success = this.plotSquaredPlugin != null;
    }

    @Override
    public boolean canBreakBlock(Player player, Location loc) {
        com.intellectualcrafters.plot.object.Location psLocation = BukkitUtil.getLocation((Location)loc);
        PlotArea area = psLocation.getPlotArea();
        if (area == null) {
            return true;
        }
        return this.canBreakBlock(player, area, area.getPlot(psLocation), loc);
    }

    private boolean isHeightAllowed(Player player, PlotArea area, int height) {
        return !(height == 0 ? !this.hookContext.getPermissionsManager().hasPermission(player, C.PERMISSION_ADMIN_DESTROY_GROUNDLEVEL.s()) : (height > area.MAX_BUILD_HEIGHT || height < area.MIN_BUILD_HEIGHT) && !this.hookContext.getPermissionsManager().hasPermission(player, C.PERMISSION_ADMIN_BUILD_HEIGHTLIMIT.s()));
    }

    private boolean canBreakBlock(Player player, PlotArea area, Plot plot, Location loc) {
        if (plot != null) {
            if (!this.isHeightAllowed(player, area, loc.getBlockY())) {
                return false;
            }
            if (!plot.hasOwner()) {
                return this.hookContext.getPermissionsManager().hasPermission(player, C.PERMISSION_ADMIN_DESTROY_UNOWNED.s());
            }
            if (!plot.isAdded(player.getUniqueId())) {
                return this.hookContext.getPermissionsManager().hasPermission(player, C.PERMISSION_ADMIN_DESTROY_OTHER.s());
            }
            return !Settings.Done.RESTRICT_BUILDING || !plot.getFlags().containsKey(Flags.DONE) || this.hookContext.getPermissionsManager().hasPermission(player, C.PERMISSION_ADMIN_BUILD_OTHER.s());
        }
        return this.canBreakRoads(player);
    }

    private boolean canBreakRoads(Player player) {
        return this.hookContext.getPermissionsManager().hasPermission(player, C.PERMISSION_ADMIN_DESTROY_ROAD.s());
    }

    @Override
    public boolean canBreakBlocksBetweenLocs(Player player, Location loc1, Location loc2) {
        if (!this.plotSquared.isPlotWorld(loc1.getWorld())) {
            return true;
        }
        int x1 = Math.min(loc1.getBlockX(), loc2.getBlockX());
        int y1 = Math.min(loc1.getBlockY(), loc2.getBlockY());
        int z1 = Math.min(loc1.getBlockZ(), loc2.getBlockZ());
        int x2 = Math.max(loc1.getBlockX(), loc2.getBlockX());
        int y2 = Math.max(loc1.getBlockY(), loc2.getBlockY());
        int z2 = Math.max(loc1.getBlockZ(), loc2.getBlockZ());
        boolean canBreakRoads = this.canBreakRoads(player);
        for (int xPos = x1; xPos <= x2; ++xPos) {
            for (int zPos = z1; zPos <= z2; ++zPos) {
                Location loc = new Location(loc1.getWorld(), (double)xPos, (double)y1, (double)zPos);
                com.intellectualcrafters.plot.object.Location psLocation = BukkitUtil.getLocation((Location)loc);
                PlotArea area = psLocation.getPlotArea();
                if (area == null) continue;
                if (!this.isHeightAllowed(player, area, y1) || !this.isHeightAllowed(player, area, y2)) {
                    return false;
                }
                loc.setY((double)(area.MAX_BUILD_HEIGHT - 1));
                Plot newPlot = area.getPlot(psLocation);
                if (newPlot == null && !canBreakRoads) {
                    return false;
                }
                if (this.canBreakBlock(player, area, newPlot, loc)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean success() {
        return this.success;
    }

    @Override
    public String getName() {
        return this.plotSquaredPlugin.getName();
    }
}

