/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.compatibility;

import com.dansplugins.factionsystem.MedievalFactions;
import com.dansplugins.factionsystem.area.MfBlockPosition;
import com.dansplugins.factionsystem.claim.MfClaimedChunk;
import com.dansplugins.factionsystem.faction.MfFaction;
import com.dansplugins.factionsystem.player.MfPlayer;
import com.dansplugins.factionsystem.service.Services;
import nl.pim16aap2.bigDoors.compatibility.HookContext;
import nl.pim16aap2.bigDoors.compatibility.IProtectionCompat;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class MedievalFactionsProtectionCompat
implements IProtectionCompat {
    private final HookContext hookContext;
    private final MedievalFactions medievalFactions;
    private final Services services;

    public MedievalFactionsProtectionCompat(HookContext hookContext) {
        this.hookContext = hookContext;
        this.medievalFactions = (MedievalFactions)Bukkit.getPluginManager().getPlugin("MedievalFactions");
        this.services = this.medievalFactions == null ? null : this.medievalFactions.getServices();
    }

    private boolean locationIntersectsWithGate(Location loc) {
        MfBlockPosition blockPosition = MfBlockPosition.Companion.fromBukkitLocation(loc);
        if (blockPosition == null) {
            return false;
        }
        return this.services.getGateService().getGatesAt(blockPosition).size() > 0 || this.services.getGateService().getGatesByTrigger(blockPosition).size() > 0;
    }

    @Override
    public boolean canBreakBlock(Player player, Location loc) {
        if (this.locationIntersectsWithGate(loc)) {
            return false;
        }
        MfClaimedChunk claim = this.services.getClaimService().getClaim(loc.getChunk());
        if (claim == null) {
            return true;
        }
        MfFaction faction = this.services.getFactionService().getFactionByFactionId(claim.getFactionId());
        if (faction == null) {
            return true;
        }
        MfPlayer mfPlayer = this.services.getPlayerService().getPlayerByBukkitPlayer((OfflinePlayer)player);
        if (mfPlayer == null) {
            return false;
        }
        if (this.services.getClaimService().isInteractionAllowedForPlayerInChunk(mfPlayer.getId(), claim)) {
            return true;
        }
        return mfPlayer.isBypassEnabled() && player.hasPermission("mf.bypass");
    }

    @Override
    public boolean canBreakBlocksBetweenLocs(Player player, Location loc1, Location loc2) {
        World world = loc1.getWorld();
        int x1 = Math.min(loc1.getBlockX(), loc2.getBlockX());
        int y1 = Math.min(loc1.getBlockY(), loc2.getBlockY());
        int z1 = Math.min(loc1.getBlockZ(), loc2.getBlockZ());
        int x2 = Math.max(loc1.getBlockX(), loc2.getBlockX());
        int y2 = Math.max(loc1.getBlockY(), loc2.getBlockY());
        int z2 = Math.max(loc1.getBlockZ(), loc2.getBlockZ());
        Location loc = new Location(world, 0.0, 0.0, 0.0);
        for (int x = x1; x <= x2; ++x) {
            loc.setX((double)x);
            for (int z = z1; z <= z2; ++z) {
                loc.setZ((double)z);
                for (int y = y1; y <= y2; ++y) {
                    loc.setY((double)y);
                    if (this.canBreakBlock(player, loc)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean success() {
        return this.medievalFactions != null;
    }

    @Override
    public String getName() {
        return this.hookContext.getProtectionCompatDefinition().getName();
    }
}

