/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.compatibility;

import java.util.UUID;
import me.angeschossen.lands.api.flags.Flags;
import me.angeschossen.lands.api.integration.LandsIntegration;
import me.angeschossen.lands.api.land.Area;
import nl.pim16aap2.bigDoors.compatibility.HookContext;
import nl.pim16aap2.bigDoors.compatibility.IProtectionCompat;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class LandsProtectionCompat
implements IProtectionCompat {
    private final LandsIntegration landsAddon;
    private final HookContext hookContext;

    public LandsProtectionCompat(HookContext hookContext) {
        this.hookContext = hookContext;
        this.landsAddon = new LandsIntegration((Plugin)hookContext.getPlugin());
    }

    @Override
    public boolean canBreakBlock(Player player, Location loc) {
        @Nullable Area area = this.landsAddon.getAreaByLoc(loc);
        if (area == null) {
            return true;
        }
        return area.hasFlag(player.getUniqueId(), Flags.BLOCK_BREAK);
    }

    @Override
    public boolean canBreakBlocksBetweenLocs(Player player, Location loc1, Location loc2) {
        UUID playerUUID = player.getUniqueId();
        World world = loc1.getWorld();
        int x1 = Math.min(loc1.getBlockX(), loc2.getBlockX()) >> 4;
        int y1 = Math.min(loc1.getBlockY(), loc2.getBlockY());
        int z1 = Math.min(loc1.getBlockZ(), loc2.getBlockZ()) >> 4;
        int x2 = Math.max(loc1.getBlockX(), loc2.getBlockX()) >> 4;
        int y2 = Math.max(loc1.getBlockY(), loc2.getBlockY());
        int z2 = Math.max(loc1.getBlockZ(), loc2.getBlockZ()) >> 4;
        Location loc = new Location(world, 0.0, 0.0, 0.0);
        for (int chunkX = x1; chunkX <= x2; ++chunkX) {
            loc.setX((double)(chunkX << 4));
            for (int chunkZ = z1; chunkZ <= z2; ++chunkZ) {
                loc.setZ((double)(chunkZ << 4));
                for (int y = y1; y <= y2; ++y) {
                    loc.setY((double)y);
                    @Nullable Area area = this.landsAddon.getAreaByLoc(loc);
                    if (area == null || area.hasFlag(playerUUID, Flags.BLOCK_BREAK)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean success() {
        return true;
    }

    @Override
    public String getName() {
        return this.hookContext.getProtectionCompatDefinition().getName();
    }
}

