/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.compatibility;

import java.util.Objects;
import konquest.Konquest;
import konquest.KonquestPlugin;
import konquest.api.model.KonquestOfflinePlayer;
import konquest.api.model.KonquestTerritoryType;
import konquest.api.model.KonquestTown;
import konquest.api.model.KonquestUpgrade;
import konquest.model.KonCamp;
import konquest.model.KonCapital;
import konquest.model.KonDirective;
import konquest.model.KonMonumentTemplate;
import konquest.model.KonPlayer;
import konquest.model.KonTerritory;
import konquest.model.KonTown;
import nl.pim16aap2.bigDoors.compatibility.HookContext;
import nl.pim16aap2.bigDoors.compatibility.IProtectionCompat;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class KonquestProtectionCompat
implements IProtectionCompat {
    private static final String NAME = "Konquest";
    @Nullable
    private final Konquest konquest;

    public KonquestProtectionCompat(HookContext hookContext) {
        @Nullable KonquestPlugin konquestPlugin = (KonquestPlugin)Bukkit.getPluginManager().getPlugin(NAME);
        this.konquest = konquestPlugin == null ? null : konquestPlugin.getKonquestInstance();
    }

    @Override
    public boolean canBreakBlock(Player player, Location loc) {
        if (this.konquest == null) {
            return true;
        }
        World world = Objects.requireNonNull(loc.getWorld());
        if (this.konquest.isWorldIgnored(world)) {
            return true;
        }
        KonPlayer konPlayer = this.konquest.getPlayerManager().getPlayer(player);
        return this.konquest.getKingdomManager().isChunkClaimed(loc) ? this.checkTerritory(this.konquest, konPlayer, loc, this.konquest.getKingdomManager().getChunkTerritory(loc)) : this.wildAllowed(this.konquest, konPlayer);
    }

    public boolean wildAllowed(Konquest konquest, KonPlayer player) {
        boolean wildConfigured = konquest.getConfigManager().getConfig("core").getBoolean("core.kingdoms.wild_build", true);
        return player.isAdminBypassActive() || wildConfigured;
    }

    private boolean checkTerritory(Konquest konquest, KonPlayer player, Location loc, KonTerritory territory) {
        if (player.isAdminBypassActive()) {
            return true;
        }
        if (territory instanceof KonCapital) {
            if (!konquest.getConfigManager().getConfig("core").getBoolean("core.kingdoms.capital_build", false)) {
                return false;
            }
            @Nullable KonMonumentTemplate template = territory.getKingdom().getMonumentTemplate();
            if (template != null && template.isLocInside(loc)) {
                return false;
            }
            if (!player.getKingdom().equals(territory.getKingdom())) {
                return false;
            }
        }
        if (territory.getTerritoryType().equals((Object)KonquestTerritoryType.TOWN) && territory instanceof KonTown) {
            KonTown town = (KonTown)territory;
            if (town.isLocInsideCenterChunk(loc)) {
                return false;
            }
            if (!player.getKingdom().equals(town.getKingdom())) {
                if (territory.getKingdom().isPeaceful() || player.getKingdom().isPeaceful() || town.getKingdom().isOfflineProtected()) {
                    return false;
                }
                int upgradeLevel = konquest.getUpgradeManager().getTownUpgradeLevel((KonquestTown)town, KonquestUpgrade.WATCH);
                if (upgradeLevel > 0 && town.getNumResidentsOnline() < upgradeLevel || konquest.getGuildManager().isArmistice((KonquestOfflinePlayer)player, (KonquestTown)town) || town.isShielded() || town.isArmored()) {
                    return false;
                }
            } else {
                if (!town.isOpen() && !town.isPlayerResident(player.getOfflineBukkitPlayer())) {
                    return false;
                }
                if (town.isOpen() || !town.isOpen() && town.isPlayerResident(player.getOfflineBukkitPlayer())) {
                    if (konquest.getPlotManager().isPlayerPlotProtectBuild((KonquestTown)town, loc, player.getBukkitPlayer())) {
                        return false;
                    }
                    if (town.isPlotOnly() && !town.isPlayerKnight(player.getOfflineBukkitPlayer()) && !town.hasPlot(loc)) {
                        return false;
                    }
                }
                konquest.getDirectiveManager().updateDirectiveProgress(player, KonDirective.BUILD_TOWN);
            }
        }
        if (territory.getTerritoryType().equals((Object)KonquestTerritoryType.CAMP) && territory instanceof KonCamp) {
            KonCamp camp = (KonCamp)territory;
            boolean isMemberAllowedEdit = konquest.getConfigManager().getConfig("core").getBoolean("core.camps.clan_allow_edit_offline", false);
            if (camp.isProtected() && !isMemberAllowedEdit) {
                return false;
            }
        }
        return !territory.getTerritoryType().equals((Object)KonquestTerritoryType.RUIN);
    }

    @Override
    public boolean canBreakBlocksBetweenLocs(Player player, Location loc1, Location loc2) {
        if (this.konquest == null) {
            return true;
        }
        World world = Objects.requireNonNull(loc1.getWorld());
        if (this.konquest.isWorldIgnored(world)) {
            return true;
        }
        KonPlayer konPlayer = this.konquest.getPlayerManager().getPlayer(player);
        int x1 = Math.min(loc1.getBlockX(), loc2.getBlockX()) >> 4;
        int y1 = Math.min(loc1.getBlockY(), loc2.getBlockY());
        int z1 = Math.min(loc1.getBlockZ(), loc2.getBlockZ()) >> 4;
        int x2 = Math.max(loc1.getBlockX(), loc2.getBlockX()) >> 4;
        int y2 = Math.max(loc1.getBlockY(), loc2.getBlockY());
        int z2 = Math.max(loc1.getBlockZ(), loc2.getBlockZ()) >> 4;
        Location loc = new Location(world, 0.0, (double)((float)(y2 + y1) / 2.0f), 0.0);
        boolean wildChecked = false;
        for (int chunkX = x1; chunkX <= x2; ++chunkX) {
            loc.setX((double)(chunkX << 4));
            for (int chunkZ = z1; chunkZ <= z2; ++chunkZ) {
                loc.setZ((double)(chunkZ << 4));
                boolean claimed = this.konquest.getKingdomManager().isChunkClaimed(loc);
                if (claimed) {
                    KonTerritory territory = this.konquest.getKingdomManager().getChunkTerritory(loc);
                    if (this.checkTerritory(this.konquest, konPlayer, loc, territory)) continue;
                    return false;
                }
                if (wildChecked) continue;
                if (!this.wildAllowed(this.konquest, konPlayer)) {
                    return false;
                }
                wildChecked = true;
            }
        }
        return true;
    }

    @Override
    public boolean success() {
        return this.konquest != null;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

