/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.compatibility;

import com.griefdefender.api.Core;
import com.griefdefender.api.GriefDefender;
import com.griefdefender.api.User;
import com.griefdefender.api.claim.Claim;
import nl.pim16aap2.bigDoors.compatibility.HookContext;
import nl.pim16aap2.bigDoors.compatibility.IProtectionCompat;
import nl.pim16aap2.bigDoors.lib.xseries.XMaterial;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class GriefDefender2ProtectionCompat
implements IProtectionCompat {
    private final Core griefDefender = GriefDefender.getCore();

    public GriefDefender2ProtectionCompat(HookContext hookContext) {
    }

    private boolean enabledInWorldChecks(World world) {
        return GriefDefender.getCore().isEnabled(world.getUID());
    }

    private boolean isTypeBlockIgnored(Location loc) {
        Block block = loc.getBlock();
        Material type = block.getType();
        return type.equals((Object)XMaterial.AIR.parseMaterial()) || type.equals((Object)XMaterial.CAVE_AIR.parseMaterial()) || type.equals((Object)XMaterial.VOID_AIR.parseMaterial());
    }

    private boolean checkLocation(Player player, Location loc) {
        if (this.isTypeBlockIgnored(loc)) {
            return true;
        }
        Claim targetClaim = this.griefDefender.getClaimAt((Object)loc);
        if (targetClaim == null || targetClaim.isWilderness()) {
            return true;
        }
        User wrappedPlayer = GriefDefender.getCore().getUser(player.getUniqueId());
        return targetClaim.canBreak((Object)player, (Object)loc, wrappedPlayer);
    }

    @Override
    public boolean canBreakBlock(Player player, Location loc) {
        if (!this.enabledInWorldChecks(loc.getWorld())) {
            return true;
        }
        return this.checkLocation(player, loc);
    }

    @Override
    public boolean canBreakBlocksBetweenLocs(Player player, Location loc1, Location loc2) {
        if (!this.enabledInWorldChecks(loc1.getWorld())) {
            return true;
        }
        int x1 = Math.min(loc1.getBlockX(), loc2.getBlockX());
        int y1 = Math.min(loc1.getBlockY(), loc2.getBlockY());
        int z1 = Math.min(loc1.getBlockZ(), loc2.getBlockZ());
        int x2 = Math.max(loc1.getBlockX(), loc2.getBlockX());
        int y2 = Math.max(loc1.getBlockY(), loc2.getBlockY());
        int z2 = Math.max(loc1.getBlockZ(), loc2.getBlockZ());
        for (int xPos = x1; xPos <= x2; ++xPos) {
            for (int yPos = y1; yPos <= y2; ++yPos) {
                for (int zPos = z1; zPos <= z2; ++zPos) {
                    if (this.checkLocation(player, new Location(loc1.getWorld(), (double)xPos, (double)yPos, (double)zPos))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean success() {
        return this.griefDefender != null;
    }

    @Override
    public String getName() {
        return "GriefDefender";
    }
}

