/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.compatibility;

import com.griefdefender.GriefDefenderPlugin;
import com.griefdefender.api.Tristate;
import com.griefdefender.api.claim.Claim;
import com.griefdefender.api.claim.TrustTypes;
import com.griefdefender.api.permission.flag.Flags;
import com.griefdefender.claim.GDClaim;
import com.griefdefender.permission.GDPermissionManager;
import com.griefdefender.permission.flag.GDFlags;
import java.util.UUID;
import nl.pim16aap2.bigDoors.compatibility.HookContext;
import nl.pim16aap2.bigDoors.compatibility.IProtectionCompat;
import nl.pim16aap2.bigDoors.lib.xseries.XMaterial;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class GriefDefender1ProtectionCompat
implements IProtectionCompat {
    private final GriefDefenderPlugin griefDefenderPlugin = GriefDefenderPlugin.getInstance();

    public GriefDefender1ProtectionCompat(HookContext hookContext) {
    }

    private boolean enabledInWorldChecks(World world) {
        if (!GDFlags.BLOCK_BREAK) {
            return false;
        }
        return this.griefDefenderPlugin.claimsEnabledForWorld(world.getUID());
    }

    private boolean isTypeBlockIgnored(Location loc) {
        Block block = loc.getBlock();
        Material type = block.getType();
        if (type.equals((Object)XMaterial.AIR.parseMaterial()) || type.equals((Object)XMaterial.CAVE_AIR.parseMaterial()) || type.equals((Object)XMaterial.VOID_AIR.parseMaterial())) {
            return true;
        }
        return GriefDefenderPlugin.isTargetIdBlacklisted((String)Flags.BLOCK_BREAK.getName(), (Object)block, (UUID)loc.getWorld().getUID());
    }

    private boolean checkLocation(Player player, Location loc) {
        if (this.isTypeBlockIgnored(loc)) {
            return true;
        }
        GDClaim targetClaim = this.griefDefenderPlugin.dataStore.getClaimAt(loc);
        Tristate result = GDPermissionManager.getInstance().getFinalPermission(null, loc, (Claim)targetClaim, Flags.BLOCK_BREAK, (Object)player, (Object)loc.getBlock(), player, TrustTypes.BUILDER, true);
        return result != Tristate.FALSE;
    }

    @Override
    public boolean canBreakBlock(Player player, Location loc) {
        if (!this.enabledInWorldChecks(loc.getWorld())) {
            return true;
        }
        return this.checkLocation(player, loc);
    }

    @Override
    public boolean canBreakBlocksBetweenLocs(Player player, Location loc1, Location loc2) {
        if (!this.enabledInWorldChecks(loc1.getWorld())) {
            return true;
        }
        int x1 = Math.min(loc1.getBlockX(), loc2.getBlockX());
        int y1 = Math.min(loc1.getBlockY(), loc2.getBlockY());
        int z1 = Math.min(loc1.getBlockZ(), loc2.getBlockZ());
        int x2 = Math.max(loc1.getBlockX(), loc2.getBlockX());
        int y2 = Math.max(loc1.getBlockY(), loc2.getBlockY());
        int z2 = Math.max(loc1.getBlockZ(), loc2.getBlockZ());
        for (int xPos = x1; xPos <= x2; ++xPos) {
            for (int yPos = y1; yPos <= y2; ++yPos) {
                for (int zPos = z1; zPos <= z2; ++zPos) {
                    if (this.checkLocation(player, new Location(loc1.getWorld(), (double)xPos, (double)yPos, (double)zPos))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean success() {
        return this.griefDefenderPlugin != null;
    }

    @Override
    public String getName() {
        return "GriefDefender";
    }
}

