/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.compatibility;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.UUID;
import javax.annotation.Nullable;
import nl.pim16aap2.bigDoors.BigDoors;
import nl.pim16aap2.bigDoors.reflection.ClassFinder;
import nl.pim16aap2.bigDoors.reflection.ConstructorFinder;
import nl.pim16aap2.bigDoors.reflection.FieldFinder;
import nl.pim16aap2.bigDoors.reflection.MethodFinder;
import nl.pim16aap2.bigDoors.reflection.ReflectionBuilder;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

class FakePlayerInstantiator {
    private Class<?> classCraftOfflinePlayer;
    private Class<?> classCraftWorld;
    private Class<?> classWorldServer;
    private Class<?> classEntityPlayer;
    private Class<?> classMinecraftServer;
    private Class<?> classPlayerInteractManager;
    private Class<?> classGameProfile;
    private Method methodGetHandle;
    private Method methodGetServer;
    private Method methodGetBukkitEntity;
    private Constructor<?> cTorEntityPlayerConstructor;
    @Nullable
    private Constructor<?> cTorPlayerInteractManager;
    private Field fieldUuid;
    private Field fieldProfile;
    private Field fieldPlayerNameVar;
    private final JavaPlugin plugin;

    FakePlayerInstantiator(JavaPlugin plugin) throws Exception {
        this.plugin = plugin;
        String nmsBase = "net.minecraft.server." + BigDoors.get().getPackageVersion() + ".";
        String craftBase = "org.bukkit.craftbukkit." + BigDoors.get().getPackageVersion() + ".";
        this.classCraftOfflinePlayer = ReflectionBuilder.findClass(craftBase + "CraftOfflinePlayer").get();
        this.classCraftWorld = ReflectionBuilder.findClass(craftBase + "CraftWorld").get();
        this.classWorldServer = ReflectionBuilder.findClass(nmsBase + "WorldServer", "net.minecraft.server.level.WorldServer").get();
        this.classEntityPlayer = ReflectionBuilder.findClass(nmsBase + "EntityPlayer", "net.minecraft.server.level.EntityPlayer").get();
        this.classMinecraftServer = ReflectionBuilder.findClass(nmsBase + "MinecraftServer", "net.minecraft.server.MinecraftServer").get();
        this.classPlayerInteractManager = ReflectionBuilder.findClass(nmsBase + "PlayerInteractManager", "net.minecraft.server.level.PlayerInteractManager").get();
        this.classGameProfile = ReflectionBuilder.findClass("com.mojang.authlib.GameProfile").get();
        Object classProfilePublicKey = ((ClassFinder)ReflectionBuilder.findClass("net.minecraft.world.entity.player.ProfilePublicKey").setNullable()).get();
        this.cTorEntityPlayerConstructor = ((ConstructorFinder.ConstructorFinderInSource)ReflectionBuilder.findConstructor().inClass(this.classEntityPlayer).withParameters(ReflectionBuilder.parameterBuilder().withRequiredParameters(this.classMinecraftServer, this.classWorldServer, this.classGameProfile).withOptionalParameters(new Class[]{this.classPlayerInteractManager, classProfilePublicKey}))).get();
        this.methodGetBukkitEntity = (Method)ReflectionBuilder.findMethod().inClass(this.classEntityPlayer).findMultiple().withName("getBukkitEntity").atLeast(1).get().get(0);
        this.methodGetHandle = ((MethodFinder.NamedMethodFinder)ReflectionBuilder.findMethod().inClass(this.classCraftWorld).withName("getHandle").withModifiers(1)).get();
        this.methodGetServer = ReflectionBuilder.findMethod().inClass(this.classMinecraftServer).withName("getServer").get();
        Object classNMSEntity = ReflectionBuilder.findClass(nmsBase + "Entity", "net.minecraft.world.entity.Entity").get();
        this.fieldUuid = ((FieldFinder.TypedFieldFinder)ReflectionBuilder.findField().inClass((Class<?>)classNMSEntity).ofType(UUID.class).withModifiers(4)).get();
        this.fieldUuid.setAccessible(true);
        this.fieldProfile = ReflectionBuilder.findField().inClass(this.classCraftOfflinePlayer).ofType(this.classGameProfile).get();
        this.fieldProfile.setAccessible(true);
        this.fieldPlayerNameVar = ReflectionBuilder.findField().inClass(this.classGameProfile).withName("name").get();
        this.fieldPlayerNameVar.setAccessible(true);
        Object classNMSWorld = ReflectionBuilder.findClass(nmsBase + "World", "net.minecraft.world.level.World").get();
        this.cTorPlayerInteractManager = ((ConstructorFinder.ConstructorFinderInSource)((ConstructorFinder.ConstructorFinderInSource)ReflectionBuilder.findConstructor().inClass(this.classPlayerInteractManager).withParameters(ReflectionBuilder.parameterBuilder().withOptionalParameters(this.classWorldServer).withOptionalParameters(new Class[]{classNMSWorld}))).setNullable()).get();
    }

    @Nullable
    public Player getFakePlayer(OfflinePlayer oPlayer, String playerName, World world) {
        if (oPlayer == null || world == null) {
            return null;
        }
        Player player = null;
        try {
            Object ePlayer;
            Object coPlayer = this.classCraftOfflinePlayer.cast(oPlayer);
            Object gProfile = this.fieldProfile.get(coPlayer);
            this.fieldPlayerNameVar.set(gProfile, playerName);
            Object craftServer = this.classCraftWorld.cast(world);
            Object worldServer = this.methodGetHandle.invoke(craftServer, new Object[0]);
            Object minecraftServer = this.methodGetServer.invoke(worldServer, new Object[0]);
            if (this.cTorPlayerInteractManager == null) {
                ePlayer = this.cTorEntityPlayerConstructor.getParameterCount() == 3 ? this.cTorEntityPlayerConstructor.newInstance(minecraftServer, worldServer, gProfile) : this.cTorEntityPlayerConstructor.newInstance(minecraftServer, worldServer, gProfile, null);
            } else {
                Object playerInteractManager = this.cTorPlayerInteractManager.newInstance(worldServer);
                ePlayer = this.cTorEntityPlayerConstructor.newInstance(minecraftServer, worldServer, gProfile, playerInteractManager);
            }
            this.fieldUuid.set(ePlayer, oPlayer.getUniqueId());
            player = (Player)this.methodGetBukkitEntity.invoke(ePlayer, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
        if (player != null) {
            player.setMetadata("isBigDoorsFakePlayer", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
        }
        return player;
    }
}

