/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.codegeneration;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Set;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.FieldAccessor;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodCall;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.StubMethod;
import net.bytebuddy.implementation.bind.annotation.FieldValue;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.This;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import nl.pim16aap2.bigDoors.NMS.NMSBlock;
import nl.pim16aap2.bigDoors.codegeneration.ClassGenerator;
import nl.pim16aap2.bigDoors.codegeneration.ReflectionRepository;
import nl.pim16aap2.bigDoors.lib.xseries.XMaterial;
import nl.pim16aap2.bigDoors.reflection.MethodFinder;
import nl.pim16aap2.bigDoors.reflection.ReflectionBuilder;
import nl.pim16aap2.bigDoors.util.DoorDirection;
import nl.pim16aap2.bigDoors.util.NMSUtil;
import nl.pim16aap2.bigDoors.util.RotateDirection;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.block.data.type.Fence;
import org.bukkit.entity.FallingBlock;
import org.jetbrains.annotations.NotNull;

final class NMSBlockClassGenerator
extends ClassGenerator {
    @NotNull
    private static final Class<?>[] CONSTRUCTOR_PARAMETER_TYPES = new Class[]{World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, ReflectionRepository.classBlockBaseInfo, ReflectionRepository.asArrayType(ReflectionRepository.classEnumDirectionAxis), ReflectionRepository.asArrayType(ReflectionRepository.classEnumBlockRotation)};
    public static final String FIELD_AXES_VALUES = "generated$axesValues";
    public static final String FIELD_ROTATION_VALUES = "generated$blockRotationValues";
    public static final String FIELD_CRAFT_BLOCK_DATA = "generated$craftBlockData";
    public static final String FIELD_BLOCK_DATA = "generated$blockData";
    public static final String FIELD_LOCATION = "generated$loc";
    public static final String FIELD_XMATERIAL = "generated$xMaterial";
    public static final Method METHOD_RETRIEVE_BLOCK_DATA = ReflectionBuilder.findMethod().inClass(IGeneratedNMSBlock.class).withName("generated$retrieveBlockData").get();
    public static final Method METHOD_SET_BLOCK_DATA = ReflectionBuilder.findMethod().inClass(IGeneratedNMSBlock.class).withName("generated$setBlockData").get();
    public static final Method METHOD_SET_BLOCK_TYPE = ReflectionBuilder.findMethod().inClass(IGeneratedNMSBlock.class).withName("generated$setBlockType").get();
    public static final Method METHOD_TO_STRING = ReflectionBuilder.findMethod().inClass(Object.class).withName("toString").get();
    public static final Method METHOD_ROTATE_UP_DOWN_NS = ((MethodFinder.NamedMethodFinder)ReflectionBuilder.findMethod().inClass(NMSBlock.class).withName("rotateBlockUpDown").withParameters(Boolean.TYPE)).get();
    public static final Method METHOD_ROTATE_VERTICALLY_IN_DIRECTION = ((MethodFinder.NamedMethodFinder)ReflectionBuilder.findMethod().inClass(NMSBlock.class).withName("rotateVerticallyInDirection").withParameters(DoorDirection.class)).get();
    public static final Method METHOD_UTIL_ROTATE_VERTICALLY_IN_DIRECTION = ((MethodFinder.NamedMethodFinder)ReflectionBuilder.findMethod().inClass(NMSUtil.class).withName("rotateVerticallyInDirection").withParameters(DoorDirection.class, Object.class)).get();
    public static final Method METHOD_CAN_ROTATE = ReflectionBuilder.findMethod().inClass(NMSBlock.class).withName("canRotate").get();
    public static final Method METHOD_DELETE_ORIGINAL_BLOCK = ((MethodFinder.NamedMethodFinder)ReflectionBuilder.findMethod().inClass(NMSBlock.class).withName("deleteOriginalBlock").withParameters(Boolean.TYPE)).get();
    public static final Method METHOD_PUT_BLOCK = ReflectionBuilder.findMethod().inClass(NMSBlock.class).withName("putBlock").get();
    public static final String METHOD_UPDATE_CRAFT_BLOCK_DATA = "generated$updateCraftBlockData";
    public static final String METHOD_UPDATE_BLOCK_DATA = "generated$updateBlockData";
    public static final String METHOD_CHECK_WATERLOGGED = "generated$checkWaterLogged";
    public static final String METHOD_GET_MY_BLOCK_DATA = "generated$getMyBlockData";
    public static final String METHOD_UPDATE_MULTIPLE_FACING = "generated$updateCraftBlockDataMultipleFacing";
    public static final String METHOD_ROTATE_UP_DOWN_NS_IMPL = "generated$rotateBlockUpDown";
    public static final String METHOD_ROTATE = "generated$rotateBlockMethod";
    public static final String METHOD_ROTATE_CYLINDRICAL = "generated$rotateBlockCylindrical";
    public static final String METHOD_DELETE_ORIGINAL_BLOCK_PRIVATE = "generated$deleteOriginalBlock";

    public NMSBlockClassGenerator(@NotNull String mappingsVersion) throws Exception {
        super(mappingsVersion);
        this.generate();
    }

    @Override
    @NotNull
    protected Class<?>[] getConstructorArgumentTypes() {
        return CONSTRUCTOR_PARAMETER_TYPES;
    }

    @Override
    @NotNull
    protected String getBaseName() {
        return "NMSBlock";
    }

    @Override
    protected void generateImpl() throws Exception {
        DynamicType.Builder<?> builder = this.createBuilder(ReflectionRepository.classBlockBase).implement(new Type[]{FallingBlock.class, NMSBlock.class, IGeneratedNMSBlock.class});
        builder = this.addFields(builder);
        builder = this.addCTor(builder);
        builder = this.addBasicMethods(builder);
        builder = this.addDeleteOriginalBlockMethods(builder);
        builder = this.addPutBlockMethod(builder);
        builder = this.addRotateBlockMethod(builder);
        builder = this.addRotateBlockUpDownMethodNorthSouth(builder);
        builder = this.addRotateBlockUpDownMethodDirection(builder);
        builder = this.addUpdateMultipleFacingMethod(builder);
        builder = this.addRotateCylindricalMethod(builder);
        this.finishBuilder(builder);
    }

    private DynamicType.Builder<?> addCTor(DynamicType.Builder<?> builder) {
        MethodCall getBlockAtLoc = MethodCall.invoke((Method)ReflectionRepository.methodGetBlockAtCoords).onArgument(0).withArgument(new int[]{1, 2, 3});
        return builder.defineConstructor(new ModifierContributor.ForMethod[]{Visibility.PUBLIC}).withParameters((Type[])this.getConstructorArgumentTypes()).intercept((Implementation)MethodCall.invoke(ReflectionRepository.ctorBlockBase).withArgument(new int[]{4}).andThen((Implementation.Composable)MethodCall.construct(ReflectionRepository.ctorLocation).withArgument(new int[]{0, 1, 2, 3}).setsField((ElementMatcher)ElementMatchers.named((String)FIELD_LOCATION))).andThen(FieldAccessor.ofField((String)FIELD_AXES_VALUES).setsArgumentAt(5)).andThen(FieldAccessor.ofField((String)FIELD_ROTATION_VALUES).setsArgumentAt(6)).andThen(MethodCall.invoke((Method)ReflectionRepository.methodGetBlockData).onMethodCall(getBlockAtLoc).setsField((ElementMatcher)ElementMatchers.named((String)FIELD_CRAFT_BLOCK_DATA)).withAssigner(Assigner.DEFAULT, Assigner.Typing.DYNAMIC)).andThen((Implementation.Composable)MethodCall.invoke((ElementMatcher)ElementMatchers.named((String)METHOD_CHECK_WATERLOGGED)).withField(new String[]{FIELD_CRAFT_BLOCK_DATA})).andThen((Implementation.Composable)MethodCall.invoke((ElementMatcher)ElementMatchers.named((String)METHOD_UPDATE_BLOCK_DATA))).andThen((Implementation.Composable)MethodCall.invoke((Method)ReflectionRepository.methodMatchXMaterial).withMethodCall(MethodCall.invoke((Method)ReflectionRepository.methodGetBlockMaterial).onMethodCall(getBlockAtLoc)).setsField((ElementMatcher)ElementMatchers.named((String)FIELD_XMATERIAL))));
    }

    private DynamicType.Builder<?> addFields(DynamicType.Builder<?> builder) {
        return builder.defineField(FIELD_BLOCK_DATA, ReflectionRepository.classIBlockData, new ModifierContributor.ForField[]{Visibility.PRIVATE}).defineField(FIELD_CRAFT_BLOCK_DATA, ReflectionRepository.classCraftBlockData, new ModifierContributor.ForField[]{Visibility.PRIVATE}).defineField(FIELD_XMATERIAL, XMaterial.class, new ModifierContributor.ForField[]{Visibility.PRIVATE}).defineField(FIELD_LOCATION, Location.class, new ModifierContributor.ForField[]{Visibility.PRIVATE}).defineField(FIELD_AXES_VALUES, ReflectionRepository.asArrayType(ReflectionRepository.classEnumDirectionAxis), new ModifierContributor.ForField[]{Visibility.PRIVATE}).defineField(FIELD_ROTATION_VALUES, ReflectionRepository.asArrayType(ReflectionRepository.classEnumBlockRotation), new ModifierContributor.ForField[]{Visibility.PRIVATE});
    }

    private DynamicType.Builder<?> addRotateBlockBaseMethod(DynamicType.Builder<?> builder, MethodDelegation delegation, String baseName, String delegationName) {
        builder = builder.defineMethod(delegationName, ReflectionRepository.classEnumBlockRotation, new ModifierContributor.ForMethod[]{Visibility.PRIVATE}).withParameters(new Type[]{RotateDirection.class, ReflectionRepository.asArrayType(ReflectionRepository.classEnumBlockRotation)}).intercept((Implementation)delegation);
        builder = builder.defineMethod(baseName, Void.TYPE, new ModifierContributor.ForMethod[0]).withParameters(new Type[]{RotateDirection.class}).intercept((Implementation)MethodCall.invoke((Method)ReflectionRepository.methodRotateBlockData).onField(FIELD_BLOCK_DATA).withMethodCall(MethodCall.invoke((ElementMatcher)ElementMatchers.named((String)delegationName)).withArgument(new int[]{0}).withField(new String[]{FIELD_ROTATION_VALUES})).setsField((ElementMatcher)ElementMatchers.named((String)FIELD_BLOCK_DATA)).andThen((Implementation.Composable)MethodCall.invoke((ElementMatcher)ElementMatchers.named((String)METHOD_UPDATE_CRAFT_BLOCK_DATA))));
        return builder;
    }

    private DynamicType.Builder<?> addRotateBlockMethod(DynamicType.Builder<?> builder) {
        MethodDelegation findBlockRotation = MethodDelegation.to((rotateDirection, values) -> {
            switch (rotateDirection) {
                case CLOCKWISE: {
                    return values[1];
                }
                case COUNTERCLOCKWISE: {
                    return values[2];
                }
            }
            return values[0];
        }, IRotateBlock.class);
        return this.addRotateBlockBaseMethod(builder, findBlockRotation, "rotateBlock", METHOD_ROTATE);
    }

    private DynamicType.Builder<?> addRotateCylindricalMethod(DynamicType.Builder<?> builder) {
        MethodDelegation findBlockRotation = MethodDelegation.to((rotateDirection, values) -> {
            if (rotateDirection.equals((Object)RotateDirection.CLOCKWISE)) {
                return values[1];
            }
            return values[3];
        }, IRotateBlock.class);
        return this.addRotateBlockBaseMethod(builder, findBlockRotation, "rotateCylindrical", METHOD_ROTATE_CYLINDRICAL);
    }

    private DynamicType.Builder<?> addRotateBlockUpDownMethodDirection(DynamicType.Builder<?> builder) {
        return builder.define(METHOD_ROTATE_VERTICALLY_IN_DIRECTION).intercept((Implementation)MethodCall.invoke((Method)METHOD_UTIL_ROTATE_VERTICALLY_IN_DIRECTION).withArgument(new int[]{0}).withField(new String[]{FIELD_CRAFT_BLOCK_DATA}).andThen((Implementation.Composable)MethodCall.invoke((ElementMatcher)ElementMatchers.named((String)METHOD_UPDATE_BLOCK_DATA))));
    }

    private DynamicType.Builder<?> addRotateBlockUpDownMethodNorthSouth(DynamicType.Builder<?> builder) throws IllegalAccessException {
        Object blockRotatableAxis = ReflectionRepository.fieldBlockRotatableAxis.get(null);
        MethodCall getCurrentAxis = (MethodCall)MethodCall.invoke((Method)ReflectionRepository.methodEnumOrdinal).onMethodCall((MethodCall)MethodCall.invoke((Method)ReflectionRepository.methodGetIBlockDataHolderState).onField(FIELD_BLOCK_DATA).with(new Object[]{blockRotatableAxis}).withAssigner(Assigner.DEFAULT, Assigner.Typing.DYNAMIC)).withAssigner(Assigner.DEFAULT, Assigner.Typing.DYNAMIC);
        MethodCall getNewAxis = (MethodCall)MethodCall.invoke((ElementMatcher)ElementMatchers.named((String)METHOD_ROTATE_UP_DOWN_NS_IMPL)).withArgument(new int[]{0}).withMethodCall(getCurrentAxis).withField(new String[]{FIELD_AXES_VALUES}).withAssigner(Assigner.DEFAULT, Assigner.Typing.DYNAMIC);
        MethodCall setNewAxis = (MethodCall)MethodCall.invoke((Method)ReflectionRepository.methodSetIBlockDataHolderState).onField(FIELD_BLOCK_DATA).with(new Object[]{blockRotatableAxis}).withMethodCall(getNewAxis).withAssigner(Assigner.DEFAULT, Assigner.Typing.DYNAMIC);
        builder = builder.define(METHOD_ROTATE_UP_DOWN_NS).intercept((Implementation)setNewAxis.setsField((ElementMatcher)ElementMatchers.named((String)FIELD_BLOCK_DATA)).andThen((Implementation.Composable)MethodCall.invoke((ElementMatcher)ElementMatchers.named((String)METHOD_UPDATE_CRAFT_BLOCK_DATA))));
        builder = builder.defineMethod(METHOD_ROTATE_UP_DOWN_NS_IMPL, ReflectionRepository.classEnumDirectionAxis, new ModifierContributor.ForMethod[]{Visibility.PRIVATE}).withParameters(new Type[]{Boolean.TYPE, Integer.TYPE, ReflectionRepository.asArrayType(ReflectionRepository.classEnumDirectionAxis)}).intercept((Implementation)MethodDelegation.to((northSouthAligned, currentAxes, values) -> {
            int newIdx;
            switch (currentAxes) {
                case 0: {
                    newIdx = northSouthAligned ? 0 : 1;
                    break;
                }
                case 1: {
                    newIdx = northSouthAligned ? 2 : 0;
                    break;
                }
                case 2: {
                    newIdx = northSouthAligned ? 1 : 2;
                    break;
                }
                default: {
                    throw new RuntimeException("Received unexpected direction " + currentAxes);
                }
            }
            return values[newIdx];
        }, IRotateBlockUpDownNS.class));
        return builder;
    }

    private DynamicType.Builder<?> addDeleteOriginalBlockMethods(DynamicType.Builder<?> builder) {
        builder = builder.define(METHOD_SET_BLOCK_TYPE).intercept((Implementation)MethodCall.invoke((Method)ReflectionRepository.methodSetBlockType).onMethodCall(MethodCall.invoke((Method)ReflectionRepository.methodLocationGetBlock).onField(FIELD_LOCATION)).withArgument(new int[]{0}).withArgument(new int[]{1}));
        builder = builder.defineMethod(METHOD_DELETE_ORIGINAL_BLOCK_PRIVATE, Void.TYPE, 2).withParameters(new Type[]{IGeneratedNMSBlock.class, Boolean.TYPE}).intercept((Implementation)MethodDelegation.to(DeleteOriginalBlock.class));
        builder = builder.define(METHOD_DELETE_ORIGINAL_BLOCK).intercept((Implementation)MethodCall.invoke((ElementMatcher)ElementMatchers.named((String)METHOD_DELETE_ORIGINAL_BLOCK_PRIVATE)).withThis().withArgument(new int[]{0}));
        return builder;
    }

    private DynamicType.Builder<?> addBasicMethods(DynamicType.Builder<?> builder) {
        builder = builder.defineMethod(METHOD_UPDATE_BLOCK_DATA, Void.TYPE, new ModifierContributor.ForMethod[]{Visibility.PRIVATE}).intercept((Implementation)MethodCall.invoke((Method)ReflectionRepository.methodGetCraftBlockDataState).onField(FIELD_CRAFT_BLOCK_DATA).setsField((ElementMatcher)ElementMatchers.named((String)FIELD_BLOCK_DATA)));
        builder = builder.defineMethod(METHOD_UPDATE_CRAFT_BLOCK_DATA, Void.TYPE, new ModifierContributor.ForMethod[]{Visibility.PRIVATE}).intercept((Implementation)MethodCall.invoke((Method)ReflectionRepository.methodCraftBockDataFromNMSBlockData).withField(new String[]{FIELD_BLOCK_DATA}).setsField((ElementMatcher)ElementMatchers.named((String)FIELD_CRAFT_BLOCK_DATA)));
        builder = builder.define(METHOD_CAN_ROTATE).intercept((Implementation)MethodCall.invoke((Method)ReflectionRepository.methodIsAssignableFrom).on(MultipleFacing.class).withMethodCall(MethodCall.invoke((Method)ReflectionRepository.methodGetClass).onField(FIELD_CRAFT_BLOCK_DATA)));
        builder = builder.defineMethod(METHOD_CHECK_WATERLOGGED, Void.TYPE, new ModifierContributor.ForMethod[]{Visibility.PRIVATE}).withParameters(new Type[]{BlockData.class}).intercept((Implementation)MethodDelegation.to(blockData -> {
            if (blockData instanceof Waterlogged) {
                ((Waterlogged)blockData).setWaterlogged(false);
            }
        }, ICheckWaterLogged.class));
        builder = builder.defineMethod(METHOD_GET_MY_BLOCK_DATA, ReflectionRepository.classIBlockData, 1).intercept((Implementation)FieldAccessor.ofField((String)FIELD_BLOCK_DATA));
        builder = builder.define(METHOD_TO_STRING).intercept((Implementation)MethodCall.invoke((ElementMatcher)ElementMatchers.named((String)METHOD_TO_STRING.getName())).onField(FIELD_BLOCK_DATA));
        builder = builder.define(ReflectionRepository.methodBlockBaseGetItem).intercept((Implementation)StubMethod.INSTANCE);
        Method getBlock = ((MethodFinder.TypedMethodFinder)ReflectionBuilder.findMethod().inClass(ReflectionRepository.classBlockBase).withReturnType(ReflectionRepository.classNMSBlock).withoutParameters()).get();
        builder = builder.define(getBlock).intercept((Implementation)StubMethod.INSTANCE);
        builder = builder.defineMethod(METHOD_RETRIEVE_BLOCK_DATA.getName(), BlockData.class, new ModifierContributor.ForMethod[]{Visibility.PUBLIC}).withParameters(new Type[]{Block.class}).intercept((Implementation)MethodCall.invoke((Method)ReflectionRepository.methodGetBlockData).onArgument(0).withAssigner(Assigner.DEFAULT, Assigner.Typing.DYNAMIC));
        builder = builder.define(METHOD_SET_BLOCK_DATA).intercept((Implementation)MethodCall.invoke((Method)ReflectionRepository.methodSetBlockData).onArgument(0).withArgument(new int[]{1}));
        return builder;
    }

    private DynamicType.Builder<?> addPutBlockMethod(DynamicType.Builder<?> builder) {
        MethodCall worldCast = (MethodCall)MethodCall.invoke((Method)ReflectionRepository.methodGetNMSWorld).onMethodCall(MethodCall.invoke((Method)ReflectionRepository.methodLocationGetWorld).onField(FIELD_LOCATION)).withAssigner(Assigner.DEFAULT, Assigner.Typing.DYNAMIC);
        return builder.define(METHOD_PUT_BLOCK).intercept((Implementation)FieldAccessor.ofField((String)FIELD_LOCATION).setsArgumentAt(0).andThen((Implementation.Composable)MethodCall.invoke((ElementMatcher)ElementMatchers.named((String)METHOD_UPDATE_MULTIPLE_FACING)).withThis().withField(new String[]{FIELD_CRAFT_BLOCK_DATA}).withField(new String[]{FIELD_LOCATION}).withField(new String[]{FIELD_XMATERIAL})).andThen((Implementation.Composable)MethodCall.invoke((Method)ReflectionRepository.methodSetTypeAndData).onMethodCall(worldCast).withMethodCall(MethodCall.construct(ReflectionRepository.cTorBlockPosition).withMethodCall(MethodCall.invoke((Method)ReflectionRepository.methodLocationGetX).onField(FIELD_LOCATION)).withMethodCall(MethodCall.invoke((Method)ReflectionRepository.methodLocationGetY).onField(FIELD_LOCATION)).withMethodCall(MethodCall.invoke((Method)ReflectionRepository.methodLocationGetZ).onField(FIELD_LOCATION))).withField(new String[]{FIELD_BLOCK_DATA}).with(new Object[]{1})));
    }

    private DynamicType.Builder<?> addUpdateMultipleFacingMethod(DynamicType.Builder<?> builder) {
        return builder.defineMethod(METHOD_UPDATE_MULTIPLE_FACING, Void.TYPE, new ModifierContributor.ForMethod[0]).withParameters(new Type[]{IGeneratedNMSBlock.class, Object.class, Location.class, XMaterial.class}).intercept((Implementation)MethodDelegation.to((origin, craftBlockData, loc, xMat) -> {
            if (!(craftBlockData instanceof MultipleFacing)) {
                return;
            }
            Set allowedFaces = ((MultipleFacing)craftBlockData).getAllowedFaces();
            allowedFaces.forEach(blockFace -> {
                Block otherBlock = loc.clone().add((double)blockFace.getModX(), (double)blockFace.getModY(), (double)blockFace.getModZ()).getBlock();
                BlockData otherData = origin.generated$retrieveBlockData(otherBlock);
                if (blockFace.equals((Object)BlockFace.UP)) {
                    ((MultipleFacing)craftBlockData).setFace(blockFace, true);
                } else if (otherBlock.getType().isSolid()) {
                    Set otherAllowedFaces;
                    boolean areBothFence;
                    ((MultipleFacing)craftBlockData).setFace(blockFace, true);
                    boolean isOtherMultipleFacing = otherData instanceof MultipleFacing;
                    boolean materialMatch = otherBlock.getType().equals((Object)xMat.parseMaterial());
                    boolean bl = areBothFence = craftBlockData instanceof Fence && otherData instanceof Fence;
                    if (isOtherMultipleFacing && (materialMatch || areBothFence) && (otherAllowedFaces = ((MultipleFacing)otherData).getAllowedFaces()).contains(blockFace.getOppositeFace())) {
                        ((MultipleFacing)otherData).setFace(blockFace.getOppositeFace(), true);
                        origin.generated$setBlockData(otherBlock, otherData);
                    }
                } else {
                    ((MultipleFacing)craftBlockData).setFace(blockFace, false);
                }
            });
        }, IUpdateMultipleFacing.class).andThen((Implementation.Composable)MethodCall.invoke((ElementMatcher)ElementMatchers.named((String)METHOD_UPDATE_BLOCK_DATA))));
    }

    public static interface IGeneratedNMSBlock {
        public BlockData generated$retrieveBlockData(Block var1);

        public void generated$setBlockData(Block var1, BlockData var2);

        public void generated$setBlockType(Material var1, boolean var2);
    }

    public static interface IRotateBlock {
        @RuntimeType
        public Object intercept(RotateDirection var1, Object[] var2);
    }

    public static interface IRotateBlockUpDownNS {
        @RuntimeType
        public Object intercept(boolean var1, int var2, Object[] var3);
    }

    public static class DeleteOriginalBlock {
        private static final Material RESET_MATERIAL = Objects.requireNonNull(XMaterial.CAVE_AIR.parseMaterial());

        public static void deleteOriginalBlock(@This IGeneratedNMSBlock origin, boolean applyPhysics) {
            if (!applyPhysics) {
                origin.generated$setBlockType(Material.AIR, false);
            } else {
                origin.generated$setBlockType(RESET_MATERIAL, false);
                origin.generated$setBlockType(Material.AIR, true);
            }
        }
    }

    public static interface ICheckWaterLogged {
        @RuntimeType
        public void intercept(BlockData var1);
    }

    public static interface IUpdateMultipleFacing {
        @RuntimeType
        public void intercept(IGeneratedNMSBlock var1, Object var2, @FieldValue(value="generated$loc") Location var3, @FieldValue(value="generated$xMaterial") XMaterial var4);
    }

    public static interface IRotateBlockUpDownDirection {
        @RuntimeType
        public Object intercept(RotateDirection var1, DoorDirection var2, Object var3);
    }
}

